#!/bin/bash

function log () {
	echo "[rootfs_downgrade] ${1}"
	echo "[rootfs_downgrade] ${1}" >> /usr/conf/permlog/downgrade_rootfs.log
}

# reset log-file
rm -rf /usr/conf/permlog/downgrade_rootfs.log

log "Started on $(date)."

# clean up Configuration
log "Resetting Configuration."
rm -rf /usr/conf/ari.db
rm -rf /usr/conf/hardware.conf*
rm -rf /usr/conf/isgw.*
rm -rf /usr/conf/misc.conf
rm -rf /usr/conf/network.acl


# clean up AppFS
log "Removing AppFS."
/usr/local/init/rcK &> /dev/null
mount -oremount,rw /usr/local
rm -rf /usr/local/*
mount -oremount,ro /usr/local

# stop the netconfigserver
/etc/init.d/S41ncs stop &> /dev/null
killall -9 netconfigserver &> /dev/null

# clean up RootFs
mount -oremount,rw /

# deleteFiles="/etc/init.d/* /lib/modules/csmencaps.ko /lib/modules/berofix-driver.ko /lib/modules/8021q.ko /lib/modules/bonding.ko /usr/php/include/* /usr/php/provisioningTool.php /usr/www/* /usr/fallback/* /sbin/mdio /sbin/vconfig /sbin/ifenslave /pkginfo"
deleteFiles="/etc/init.d/* /usr/php/include/* /usr/php/provisioningTool.php /usr/www/* /usr/fallback/* /sbin/ifenslave /pkginfo"

for f in $(echo ${deleteFiles}); do
	log "Deleting file '${f}'."
	rm -rf ${f}
done

# install old RootFs
copyFiles="/etc/issue /etc/network/interfaces /etc/lighttpd.conf /etc/php.ini /lib/modules/resetjumper.ko /usr/bin/VERSION.lighttpd /usr/php/include/updateTool.php /usr/php/rootfs-cloud.php /usr/sbin/netconfigserver /usr/sbin/netconfigverify /usr/sbin/userapp_pkg_install.sh /usr/sbin/rootfs_pkg_install.sh /usr/sbin/update-time /usr/sbin/install_daemon.sh /usr/share/udhcpc/default.script /VERSION"

for f in $(echo ${copyFiles}); do
	log "Installing file '${f}'."
	cp -a /apps/downgrade/conf/rootfs${f} ${f}
done

log "Installing directory '/etc/init.d/'."
cp -a /apps/downgrade/conf/rootfs/etc/init.d/* /etc/init.d/
log "Installing directory '/usr/www/'."
cp -a /apps/downgrade/conf/rootfs/usr/www/* /usr/www/
log "Installing directory '/usr/fallback/'."
cp -a /apps/downgrade/conf/rootfs/usr/fallback/* /usr/fallback/


mount -oremount,ro /

# Remove this app
mount -oremount,rw /home/admin
rm -rf /home/admin/apps/downgrade
rm -rf /home/admin/apps/VERSION
rm -rf /home/admin/apps/content.txt
rm -rf /home/admin/www/downgrade
mount -oremount,ro /home/admin

# Reboot the Gateway
# reboot
