<?php

# VERSION=4
# CHANGES="added !defined"

if (!defined('_BEROCONF_CLASS')) {
	define('_BEROCONF_CLASS', true);

	final class beroConf {
		private $prefix = "/usr/conf/";
		private $dbfile;
		private $db;
		private $err;
		private $valid = true;

		function __construct ( $db ) {

			$this->dbfile = $this->prefix . $db . '.db';
			$needs_init = !file_exists($this->dbfile);

			$this->db = sqlite_open($this->dbfile);
			if ($this->db == null) {
				// opening the db file failed, we return null
				$this->err = "Opening " . $this->dbfile . " failed: " . sqlite_error_string(sqlite_last_error($this->db));
				$this->valid = false;
				return;
			}

			if (!$needs_init) {
				return;
			}

			// initialize config db with tables and default values
			if (strcmp('root', $db) == 0) {
				$ok = sqlite_exec($this->db,
					"BEGIN;\n" .
					"CREATE TABLE root (id INTEGER PRIMARY KEY, key CHAR(255), value CHAR(255));\n" .
					"INSERT INTO root (key, value) VALUES ('root-version', '3');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-iface', 'eth0');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-mtu', '1500');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-dhcp', 'yes');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-ipaddr', '');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-netmask', '');\n" .
					"INSERT INTO root (key, value) VALUES ('lan-gateway', '');\n" .
					"INSERT INTO root (key, value) VALUES ('msp-iface', 'eth1');\n" .
					"INSERT INTO root (key, value) VALUES ('msp-ipaddr', 'auto');\n" .
					"INSERT INTO root (key, value) VALUES ('app-image', '');\n" .
					"INSERT INTO root (key, value) VALUES ('app-status', '');\n" .
					"INSERT INTO root (key, value) VALUES ('ntphost', 'ntp0.fau.de');\n" .
					"INSERT INTO root (key, value) VALUES ('beroAvahi-enabled', 'yes');\n" .
					"INSERT INTO root (key, value) VALUES ('need_prod', '0');\n" .
					"COMMIT;"
				);
			} else if (strcmp('app', $db) == 0)
				$ok = sqlite_exec($this->db, "
					BEGIN;
					CREATE TABLE app (id INTEGER PRIMARY KEY, key CHAR(255), value CHAR(255));
					COMMIT;"
				);
			else
				$ok = true;
			if (!$ok) {
				$this->err = "Initialization failed: " . sqlite_error_string(sqlite_last_error($this->db));
				$this->valid = false;
				return;
			}
		}

		function __destruct () {
			if ($this->db)
				sqlite_close($this->db);
		}

		function error () {
			return $this->err ? $this->err : "No error.";
		}

		function is_error () {
			return $this->err ? true : false;
		}

		function valid () {
			return $this->valid;
		}

		private function check_db ($func) {
			if ($this->db)
				return true;

			$this->err = "$func failed: No database handle.";
			return false;
		}

		private function unset_err () {
			if ($this->err)
				unset($this->err);
		}

		function set ($table, $key, $value = '') {

			$this->unset_err();
			if (!$this->check_db("set()"))
				return false;

			$sql = "UPDATE $table SET value = '$value' WHERE key = '$key'";
			$ok = sqlite_exec($this->db, $sql);
			if (!$ok) {
				$this->err = "set() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}
			if (sqlite_changes($this->db) == 1)
				// update succeeded
				return true;

			$sql = "INSERT INTO $table (key, value) VALUES ('$key', '$value')";
			$ok = sqlite_exec($this->db, $sql);
			if (!$ok) {
				$this->err = "set() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			return true;
		}

		function delete ($table, $key) {
			$this->unset_err();
			if (!$this->check_db("delete()"))
				return false;

			$sql = "DELETE FROM $table WHERE key = '$key'";
			$ok = sqlite_exec($this->db, $sql);
			if (!$ok) {
				$this->err = "delete() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			return true;
		}

		function get ($table, $key) {
			$this->unset_err();
			if (!$this->check_db("get()"))
				return false;

			$sql = "SELECT value FROM $table WHERE key = '$key'";
			$res = sqlite_query($this->db, $sql);
			if (!$res) {
				$this->err = "get() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			$row = sqlite_fetch_array($res);
			if (!$row) {
				$this->err = "get() failed: No such key ($key) in table ($table).";
				return false;
			}

			return $row[0];
		}

		function get_rows ($table) {
			$this->unset_err();
			if (!$this->check_db("get_rows()"))
				return false;

			$res = sqlite_query($this->db, "SELECT key, value FROM $table");
			if (!$res) {
				$this->err = "get_rows() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			return $res;
		}

		function get_next_row ($res) {
			return sqlite_fetch_array($res);
		}

		function dump ($table) {
			$this->unset_err();
			if (!$this->check_db("dump()"))
				return false;

			$res = sqlite_query($this->db, "SELECT key, value FROM $table");
			if (!$res) {
				$this->err = "dump() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			while ($row = sqlite_fetch_array($res))
				echo "$row[0] => $row[1]\n";

			return true;
		}

		function exec_sql ($sql) {
			$this->unset_err();
			if (!$this->check_db("exec_sql()"))
				return false;

			$ok = sqlite_exec($this->db, $sql);
			if (!$ok) {
				$this->err = "exec_sql() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			return true;
		}

		function query_sql ($sql) {
			$this->unset_err();
			if (!$this->check_db("exec_sql()"))
				return false;

			$res = sqlite_query($this->db, $sql);
			if (!$res) {
				$this->err = "exec_sql() failed: " . sqlite_error_string(sqlite_last_error($this->db));
				return false;
			}

			return $res;
		}

		function get_db_handle () {
			$this->unset_err();
			if (!$this->check_db("get_db_handle()"))
				return false;

			return $this->db;
		}
	}
}

?>
