#!/bin/bash
#
# VERSION=22
# CHANGES="changed to be just a starter-script for /usr/sbin/install_daemon.sh"
#

# constants #
PIDFILE=/var/run/install_daemon.pid
PIPEFILE=/tmp/install_pipe

if [ -z "${1}" ]; then
	echo "ERROR: No Package specified, leaving."
	exit 1
fi

# check if there is a PIDFILE
if [ -f ${PIDFILE} ]; then
	echo "ERROR: An Installation-Process seems to be running already, leaving."
	exit 2
fi

# create named pipe to catch output
rm -f ${PIPEFILE}
/bin/mknod ${PIPEFILE} p

/sbin/start-stop-daemon -S -b -m -p ${PIDFILE} -x /usr/sbin/install_daemon.sh -- ${1}
sleep 2

while true; do
	if [ ! -f ${PIDFILE} ]; then
		killall -3 tail
		break
	fi
	sleep 2
done &

tail -f ${PIPEFILE}

sleep 1
rm -f ${PIPEFILE}

exit 0
