#!/usr/bin/php -q
<?php

$apiVersion="1.0";
/*
 * Einbindung der nötigen externen Klassen
 */
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/fallback/beroConf.php');

/*
 * Datenbank Klassen instanziieren
 */
$bc = new beroConf('root');
$ba=new beroAri('/usr/conf/ari.db');

$apiUrl='https://'.$ba->get('cloudAddress').'/index.php?r=api';


/*
 * Seriennummer der Karte herausfinden
 */
$res=file_get_contents('/proc/cmdline');
preg_match("/[^a-zA-Z0-9=]*?d=(?<serial>.+) /",$res,$serial);
$serial=$serial['serial'];
$apiKey=$bc->get('root','cloud_key'); //Dummy
$proxyAddress=$ba->get('proxyAddress');
$proxyPort=$ba->get('proxyPort');
$proxyUser=$ba->get('proxyUser');
$proxySecret=$ba->get('proxySecret');
$proxyType=$ba->get('proxyType');

$pstn_to_sip_arr=array();
$sip_to_pstn_arr=array();

$sleep_interval=$bc->get('root', 'cloud_interval');
if (!$sleep_interval) $sleep_interval=60;

$cloud_enable=$bc->get('root', 'cloud_enable');
if ($cloud_enable != 1 ) {
	exit(1);
}

try {
    if ($ba->get("cloudFileName")!="")
	getFW();
} catch(Exception $e) {
	file_put_contents('/var/log/api-error.log' , $e->getMessage(). ' ' .$e->getFile(). ' ' .$e->getLine() . "\n" , FILE_APPEND);
}


/**
  * Geplante Aufgaben aus dem Server lesen
  *
  * Diese Funktion ist eine rekursive Funktion, und wird so oft
  * ausgeführt, wie es geplante fällige Aufgaben auf dem Server gibt.
  *
  * @return void
  */
function getFW(){
    global $serial, $apiKey, $apiUrl, $proxyAddress, $proxyPort, $proxyUser, $proxySecret, $proxyType, $ba;
                $file_name=$ba->get("cloudFileName");
		$handle = @fopen('/tmp/'.$file_name, 'w');
		$ch = curl_init();
		$data = array('cmd'=>'firmwareDownload', 'serial'=>$serial, 'key'=>$apiKey);
		curl_setopt($ch, CURLOPT_URL, $apiUrl);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_FILE, $handle);
                if ($proxyAddress!='' && $proxyPort!='' && $proxyType!=''){
                    curl_setopt($ch, CURLOPT_PROXY, $proxyAddress);
                    curl_setopt($ch, CURLOPT_PROXYPORT, $proxyPort);
                    curl_setopt($ch, CURLOPT_PROXYTYPE, $proxyType);
                    if ($proxyUser!="")
                        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyUser.':'.$proxySecret);

                }
		curl_exec($ch);
		curl_close($ch);
		fclose($handle);

		updateFW($file_name);
	
}

/**
  * Firmware der Karte aktualisieren
  *
  * Die Alte Firmwares dir sich auf der Karte befinden werden gelöscht
  * und die neue Firmware wird installiert, die die aus der beroCloud
  * heruntergeladen wurde.
  *
  * @param  $fileName Name der neuen Firmware
  * @return void
  */
function updateFW($fileName){
	global $bc;
        require_once('/usr/php/include/updateTool.php');
        $parm=array();
        $parm['userfile']['tmp_name']="/tmp/".$fileName;
        $parm['userfile']['name']=$fileName;
        $updateTool=new updateTool();
        $result=$updateTool->upload($parm);
        /*
         * Da die updateTool Klasse für Dateien, die durch ein Formular hochgeladen wurden konzipiert
         * wurde, wirft die Klasse einen Fehler, deswegen wird die Datei hier verschoben.
         */
	if ($result['error_code']==3){
            rename ('/tmp/' . $fileName, $updateTool->getImageDir()."/".$fileName);
            $updateTool->install($fileName);
            $file_name=$ba->set("cloudFileName","");
            
	}	


}

?>
