#!/bin/bash
#
#VERSION=3
#CHANGES="Unset Variables before sourcing VERSION-File"

# global variables #
export PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/fallback"

# functions #
function log {
	prefix="[pkginst_rootfs]"

	if [ -z "${2}" ]; then
		echo "${prefix} $(date) ${1}"
	else
		echo "${prefix} $(date) ${1}" | tee -a /usr/conf/permlog/pkginst-rootfs-${2}.log
	fi
}

# main #
if [ "${1}" != "ON_BOOT" ] && [ "${1}" != "ON_UPDATE" ]; then
	echo "Usage: ${0} {ON_BOOT|ON_UPDATE}" >&2
	exit 1
fi

if [ ! -d /usr/conf/permlog ]; then
	mkdir -p /usr/conf/permlog
fi

CREATE_REBOOT_FILE=0

for i in $(/bin/ls /usr/local/conf/rootfs/VERSION.*); do

	unset PKG_NAME
	unset PKG_VERSION
	unset INSTALL_MODE
	unset REMV_LIST
	unset SYML_LIST

	. ${i}

	# get old version of package
	if [ -f /pkginfo/VERSION.${PKG_NAME} ]; then
		PKG_VERSION_OLD="$(expr match "$(cat /pkginfo/VERSION.${PKG_NAME})" ".*PKG_VERSION=\([0-9]*\)")"
	else
		PKG_VERSION_OLD=0
	fi

	if [ ${PKG_VERSION} -le ${PKG_VERSION_OLD} ]; then
		continue
	fi

	# check if this is a ON_UPDATE or ON_BOOT-package.
	if [ "${1}" = "ON_UPDATE" ] && [ "${INSTALL_MODE}" = "ON_BOOT" ]; then
		CREATE_REBOOT_FILE=1
		continue
	elif [ "${1}" = "ON_BOOT" ] && [ "${INSTALL_MODE}" = "ON_UPDATE" ]; then
		continue
	fi

	# remove previous installation-logfile
	rm -f /usr/conf/permlog/pkginst-rootfs-${PKG_NAME}.log

	log "Installing Package '${PKG_NAME}' Version ${PKG_VERSION}." ${PKG_NAME}

	mount -oremount,rw /

	# run pre-install-script
	if [ -x /usr/local/conf/rootfs/pre-install/${PKG_NAME} ]; then
		log "Running pre-install-script for package '${PKG_NAME}'." ${PKG_NAME}
		/usr/local/conf/rootfs/pre-install/${PKG_NAME} ${PKG_VERSION} ${PKG_VERSION_OLD}
	fi

	# remove obsolete files
	for j in ${REMV_LIST}; do
		if [ -d "${j}" ]; then
			log "Removing Directory '${j}'." ${PKG_NAME}
			rm -rf ${j}
		else
			log "Removing File '${j}'." ${PKG_NAME}
			rm -rf ${j}
		fi
	done

	# install new or changed files
	file_list=$(find /usr/local/conf/rootfs/pkg/${PKG_NAME}/)
	file_list=${file_list//\/usr\/local\/conf\/rootfs\/pkg\/${PKG_NAME}/}
	for j in ${file_list}; do

		if [ -d /usr/local/conf/rootfs/pkg/${PKG_NAME}/${j} ] && [ ! -d ${j} ]; then
			log "Creating Directory '${j}'." ${PKG_NAME}
			mkdir -p ${j}
		fi

		if [ -f  /usr/local/conf/rootfs/pkg/${PKG_NAME}/${j} ]; then
			log "Installing File '${j}'." ${PKG_NAME}
			cp /usr/local/conf/rootfs/pkg/${PKG_NAME}/${j} ${j}
		fi
	done

	# create symlinks
	for j in ${SYML_LIST}; do
		SYM_SRC=$(expr match "${j}" "\(.*\)=>")
		SYM_TGT=$(expr match "${j}" ".*=>\(.*\)")

		if [ -e ${SYM_TGT} ]; then
			rm -f ${SYM_TGT}
		fi
		log "Creating Symlink '${SYM_TGT}' to '${SYM_SRC}'." ${PKG_NAME}
		ln -s ${SYM_SRC} ${SYM_TGT}
	done

	# run post-install-script
	if [ -x /usr/local/conf/rootfs/post-install/${PKG_NAME} ]; then
		log "Running post-install-script for package '${PKG_NAME}'." ${PKG_NAME}
		/usr/local/conf/rootfs/post-install/${PKG_NAME} ${PKG_VERSION} ${PKG_VERSION_OLD}
	fi

	if [ ! -d /pkginfo ]; then
		mkdir -p /pkginfo
	fi
	cp ${i} /pkginfo

	log "Package '${PKG_NAME}' installed." ${PKG_NAME}
	sync; sleep 1; sync
	mount -oremount,ro /
done

if [ "${CREATE_REBOOT_FILE}" = "1" ]; then
	echo "1" > /tmp/reboot_after_update
fi

