<?php
# VERSION=11
# CHANGES="New GUI-Design."

include('/usr/fallback/beroConf.php');
include('/usr/www/include/berogui_small.class.php');

function get_app_master ($app_root) {

	if (!is_dir($app_root) || !($dh = opendir($app_root))) {
		return(NULL);
	}

	while (($app_name = readdir($dh)) !== false) {
		if (($app_name == '.') || ($app_name == '..')) {
			continue;
		}

		$app_version = $app_root . '/' . $app_name . '/VERSION';

		if (!($fp = fopen($app_version, 'r'))) {
			continue;
		}

		$fcont = fread($fp, filesize($app_version));
		fclose($fp);

		if (strstr($fcont, 'CLASS=master')) {
			closedir($dh);
			return($app_name);
		}

	}

	closedir($dh);

	return(NULL);
}

$userapp_root		= '/apps';
$userapp_master_dir	= get_app_master($userapp_root);
$userapp_master_www	= file_exists($userapp_root . '/' . $userapp_master_dir . '/www/index.php');

$bc = new beroConf('root');
require_once('/usr/www/include/redirect.php');

$gui = new berogui_small('beroNet VoIP Gateway: Recovery-Utility');

echo	$gui->header() .
	'<div style="text-align: center;">' . "\n" .
	'<h3>Welcome to the beroNet VoIP Gateway Recovery-Utility!</h3>' . "\n" .
	'These pages are only displayed to you if you either want to update the firmware of your beroNet VoIP Gateway<br />' . "\n" .
	'or something has gone terribly wrong.<br /><br />' . "\n" .
	'In both cases the best idea is probably to download a new firmware from the ' .
	'<a href="http://www.beronet.com/support/downloads/" target="_blank">beroNet Support Site</a><br />' . "\n" .
	'and to use the menu-point \'Firmware-Update\' to install it.<br /><br />' . "\n" .
	'Good luck!<br /><br />Your beroNet Development Team' . "\n" .
	'</div>' . "\n" .
	$gui->footer();
?>
