<?php
# VERSION=1
# CHANGES='Set settings page on recovery mode'

/* [LOAD CLASS] */
include('/usr/fallback/beroConf.php');
$bc = new beroConf('root');

include('/usr/www/include/berogui_small.class.php');
$gui = new berogui_small('beroNet VoIP Gateway: Recovery-Management');

/* [VARIABLES] */
// please respect the array order (the ordering task is logical since you do a backup before to reset the configuration)
$actions = array(
	'resetGuiPwd' => array('fct' => 'resetGuiPassword', 'header' => 'Reset GUI-Password'),
	'resetConffs' => array('fct' => 'resetConffs', 'header' => 'Reset Configuration'),
	'resetAppfs'	=> array('fct' => 'resetAppfs', 'header' => 'Reset Firmware space'),
	'resetUserapp'=> array('fct' => 'resetUserapp', 'header' => 'Reset UserApps space'),
	'resetRootfs' => array('fct' => 'resetRootfs', 'header' => 'Reset Root space'),
);

/* [INTERN FUNCTIONS] */
// html
function htmlBody($actions, $warning) {
	$str = '';
	if (!empty($warning)) {
		$str .= "\t<div style='text-align:center;margin-bottom:15px;color:red;'>\n"
					.	"\t\t<div style='margin:1px;'><b>". implode("</b></div><br/>\n\t\t<div style='margin:1px;'><b>", $warning) ."</b></div>\n"
					. "\t</div>\n"
					. "\t</br>\n";
	}
	$str .=	"\t<div style='text-align:center;'>\n"
				. "\t\t<form name='managementform' method='POST' action='management.php'>\n"
				. "\t\t\t<table style='text-align:center;'>\n"
				. "\t\t\t\t<tr><th colspan='2'>Recovery-Actions</th></tr>\n";
	foreach ($actions as $action => $what) {
		$str .= "\t\t\t\t<tr><td>{$what['header']}</td><td><input type='checkbox' name='actions[$action]' value='0'></td></tr>\n";
	}
	$str .= "\t\t\t\t<tr><td colspan='2'><input type='submit' name='Apply'></td></tr>\n"
				.	"\t\t\t</table>\n"
				. "\t\t</form>\n"
				. "\t\t<br>\n"
				. "\t\t<b>Please note:</b><br/>\n"
				. "\t\tRestoring a backup directly will not be possible anymore if the firmware space is reset.<br/>\n"
				. "\t\tHowever, it will be still possible to download it and restore it in Normal-Mode.\n"
				. "\t</div>\n";
	if (file_exists('/tmp/beroNetVoIPGateway_recoverymode.config.xml')) {
		$str .= "\t<div style='text-align:center;margin-top:15px;'>\n"
					.	"\t\t<h3>Backup</h3>\n"
					. "\t\t<div style='display:inline-flex;'>\n"
					.	"\t\t\t<form name='dl-backupform' method='GET' action='backup.php'>\n"
					. "\t\t\t\t<input type='hidden' name='action' value='download'>\n"
					. "\t\t\t\t<input type='hidden' name='filename' value='beroNetVoIPGateway_recoverymode.config.xml'>\n"
					. "\t\t\t\t<input type='submit' value='Download'>\n"
					. "\t\t\t</form>\n";
		if (file_exists('/usr/local/VERSION')) {
			$str .= "\t\t\t<form name='rstr-backupform' method='POST' action='reboot.php'>\n"
						.	"\t\t\t\t<input type='hidden' name='action' value='restore'>\n"
						. "\t\t\t\t<input type='submit' value='Restore & Reboot'>\n"
						. "\t\t\t</form>\n";
		}
		$str .=	"\t\t</div>\n"
					.	"\t</div>\n";
	}
	return($str);
}

// actions
function resetAppfs($bc) {
	exec('/bin/mount -o remount,rw /usr/local');
	exec('/bin/rm -rf /usr/local/*');
	exec('/bin/mount -o remount,ro /usr/local > /dev/null 2>&1 &'); ## taking time to exec out. must be tested in this configuration
	$bc->set('root', 'appfs-reset', '1');
	return('Appfs space successfully removed. Please install a new firmware before you reboot the device');
}

function resetConffs(&$bc) {
	exec('/usr/bin/crontab -l > /tmp/crontab.cron');
	exec('/bin/rm -rf /usr/conf/*');
	$bc = new beroConf('root');
	$bc->set('root', 'boot_recoverymode', '1');
	if (!file_exists('/pkginfo')) {
		$bc->set('root', 'rootfs-reset', '1');
	}
	if (!file_exists('/usr/local/VERSION')) {
		$bc->set('root', 'appfs-reset', '1');
	}
	if (!file_exists('/home/admin/conf')) {
		$bc->set('root', 'userappfs-reset', '1');
	}
	foreach (array('cron', 'ssh') as $dir) {
		mkdir("/usr/conf/$dir", '0777');
	}
	exec('/usr/bin/crontab /tmp/crontab.cron');
	return('Conffs space successfully removed<br/>Please note your Network-Settings has been updated and will be effective on the next reboot<br>You still can update it on the <a href="/cgi-bin/network-tool.php">Network-Configuration</a> page');
}

function resetGuiPassword($bc, $berogui = '/usr/local/www/berogui') {
	$reason = 'encrypt functions missing'; 
	if (file_exists("$berogui/includes/password_func.php")) {
		if (file_exists("$berogui/misc/database.php")) {
			include("$berogui/includes/password_func.php");
			require("$berogui/misc/database.php");
			$ba = new beroAri();
			$ba->update("UPDATE users SET password='". tep_encrypt_password('admin') ."' WHERE user='admin'");
			return('GUI-Password successfully reset');
		}
		$reason = 'database functions missing';
	}
	return("Resetting GUI-Password failed ($reason). Please install a new firmware and boot in recovery-mode.");
}

function resetRootfs($bc) {
	exec('/bin/mount -o remount,rw /');
	exec('/bin/rm -rf /pkginfo');
	exec('/bin/mount -o remount,ro /');
	$bc->set('root', 'rootfs-reset', '1');
	return('Rootfs space successfully removed. Please install a new firmware before you reboot the device');
}

function resetUserapp($bc) {
	exec('/bin/mount -o remount,rw /home/admin');
	// we do not remove openssl libraries and php-cgi
	foreach (array_diff(glob('/home/admin/*'), array('/home/admin/lib', '/home/admin/bin')) as $toRemove) {
		exec("/bin/rm -rf $toRemove");
	}
	foreach (array_diff(glob('/home/admin/lib/*'), glob('/home/admin/lib/lib*so*')) as $toRemove) {
		exec("/bin/rm -rf $toRemove");
	}
	foreach (array_diff(glob('/home/admin/bin/*'), array('/home/admin/bin/php-cgi')) as $toRemove) {
		exec("/bin/rm -rf $toRemove");
	}
	exec('/bin/mount -o remount,ro /home/admin');
	$bc->set('root', 'userappfs-reset', '1');
	return('UserApps space successfully removed');
}

/* [POST ACTION] */
$warning = array();
if (isset($_POST['actions'])) {
	foreach ($actions as $action => $what) {
		if (isset($_POST['actions'][$action])) {
			$function = $what['fct'];
			$warning[] = $function($bc);
		}
	}
}

/* [HTML OUTPUT] */
print	$gui->header()
		.	htmlBody($actions, $warning)
		. $gui->footer('recovery-management');
?>
