<?php

# VERSION=6
# CHANGES="display error message if no one file has been be uploaded and set required flag into file upload code"

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('/usr/fallback/beroConf.php');
include('/usr/php/include/updateTool.php');
include('/usr/www/include/berogui_small.class.php');

$bc = new beroConf('root');
require_once('/usr/www/include/redirect_fwupdate.php');

function display_install ($pkgname) {
	// remove not necessary file from a last installation
	foreach (array('clean_home_admin', 'switch_network_configuration', 'restoring_phpcgi_rootfs', 'homeadmin_notenough_space') as $file) {
		if (file_exists("/tmp/$file")) {
			unlink("/tmp/$file");
		}
	}
	// check PHP VERSION for new roots with PHP 7
	if (defined('PHP_VERSION_ID')) {
		// new rootfs installed; forbid to downgrade to a firmware oldest than 15.06.2020
		if (preg_match('/^appfs-([0-9]{2})-([0-9]{2})-([0-9]{2})-[0-9_]{5}.tar.gz$/', $pkgname, $fw_matched)) {
			$year = $fw_matched[1];
			$month = $fw_matched[2];
			$day = $fw_matched[3];
			if (($year < 20) || ($year == 20 && $month < 6) || ($year == 20 && $month == 6 && $day < 15)) {
				return	"<font style='color: red;'>Impossible to downgrade to a firmware older than appfs-20.04.tar.gz</font>\n" 
					. "<form name='cancel_form' action='/cgi-bin/update-tool.php' method='POST'>\n" 
					. "\t<input type='hidden' name='action' value='upload'>\n" 
					. "\t<input type='submit' value='Return'>\n"
					. "</form>\n"; 
			}
		}
		// new rootfs installed; forbid to downgrade to a firmware oldest than appfs-20.04-rc03.tar.gz
		else if (preg_match('/^appfs-([0-9]{2}).([0-9]{2})(-rc([0-9]*))?.tar.gz$/', $pkgname, $fw_matched)) {
			$major_vers = $fw_matched[1];
			$minor_vers = $fw_matched[2];
			$rc_vers = isset($fw_matched[4]) ? $fw_matched[4] : 10; // set a value higher than 5 since a stable version is higher its rc version
			if (($major_vers < 20) || ($major_vers == 20 && $minor_vers < 4) || ($major_vers == 20 && $minor_vers == 4 && $rc_vers < 5)) {
				return	  "<font style='color: red;'>Impossible to downgrade to a firmware older than appfs-20.04.tar.gz</font>\n"
					. "<form name='cancel_form' action='/cgi-bin/update-tool.php' method='POST'>\n"
					. "\t<input type='hidden' name='action' value='upload'>\n"
					. "\t<input type='submit' value='Return'>\n"
					. "</form>\n";
			} 
		}
	}

	$warning_msg = '';
	// install new rootfs: from mtdblock5 to mtdblock7
	if (preg_match('/^rootfs.tar.gz$/', $pkgname)) {
		$warning_msg = '<div style="margin-bottom: 15px;"><font style="color: red;">Updating your beroNet VoIP Gateway to a newer rootfs version will remove all of your installed apps.<br/>Please backup your apps before you continue.</font></div>'."\n";
	}

	$ret =	'<h3>Install Update-Package</h3>' . "\n" .
		$warning_msg .
		'<table>' . "\n" .
		'<tr>' . "\n" .
		'<th colspan="2">' . $pkgname . '</th>' . "\n" .
		'</tr>' . "\n" .
		'<tr>' . "\n" .
		'<td>' . "\n" .
		'<form name="delete_form" action="/cgi-bin/update-tool.php" method="POST">' . "\n" .
		'<input type="hidden" name="action" value="delete" / >' . "\n" .
		'<input type="hidden" name="file" value="' . $pkgname . '" / >' . "\n" .
		'<input type="submit" value="Delete" onclick="return confirm_delete(\'' . $pkgname . '\');" />' . "\n" .
		'</form>' . "\n" .
		'</td>' . "\n" .
		'<td>' . "\n" .
		'<form name="install_form" action="/cgi-bin/update-tool.php" method="POST">' . "\n" .
		'<input type="hidden" name="action" value="install" / >' . "\n" .
		'<input type="hidden" name="file" value="' . $pkgname . '" / >' . "\n" .
		'<input type="submit" value="Install" onclick="return confirm_install(\'' . $pkgname . '\');" />' . "\n" .
		'</form>' . "\n" .
		'</td>' . "\n" .
		'</tr>' . "\n" .
		'</table>' . "\n";

	return($ret);
}

function displayRootfsTable($rootfs_list, $appfs_version) {
        // rootfs list empty
        if (!is_array($rootfs_list)) {
                return '';
        }
        // appfs builded locally
        else if (preg_match('/^appfs-[0-9]{2}-[0-9]{2}-[0-9]{2}-[0-9]{2}_[0-9]{2}$/', $appfs_version)) {
                return '';
        }

        $table =  "\n"
                . "<h3 style='color:red;'>Major Update: Download and Install new Rootfs</h3>\n"
                . "<table>\n"
		. "\t<tr><th>Name</th><th>Type</th><th>Release Notes</th><th>Action</th></tr>\n";

	foreach ($rootfs_list as $entry) {
		$table .=	  "\t<tr>\n"
				. "\t\t<td>{$entry['name']}</td>\n"
				. "\t\t<td>{$entry['type']}</td>\n"
				. "\t\t<td>". ((strlen($entry['notesurl']) != 0) ? "<a href='{$entry['notesurl']}' target='_blank'>open</a>" : 'none') . "</td>\n"
				. "\t\t<td>\n"
				. "\t\t\t<form action='/cgi-bin/update-tool.php' method='POST'>\n"
				. "\t\t\t\t<input type='hidden' name='action' value='download'/>\n"
				. "\t\t\t\t<input type='hidden' name='package_url' value='{$entry['url']}'/>\n"
				. "\t\t\t\t<input type='submit' value='Download'/>\n"
				. "\t\t\t</form>\n"
				. "\t\t</td>\n"
				. "\t</tr>\n";
	}

	return	  $table
		. "</table>\n";
}


function display_upload($bc, $upd) {
	$ret = '';

	// display warning message from the last installation failing
	if (file_exists('/tmp/clean_home_admin')) {
		$ret .= '<div style="text-align: center; font-weight: bold; color: red;">No enough space. Please remove some installed apps.</div>';                     
	}
	else if (file_exists('/tmp/switch_network_configuration')) {
		$ret .= "<div style='text-align:center;font-weight:bold;color:red;'>Inappropriate Network Settings to firmware downgrade<br/>Please switch your Network Settings "
					.	"in 'Single-Mode' with 'LAN-DHCP'</div>";
	}
	else if (file_exists('/tmp/restoring_phpcgi_rootfs')) {
		if ($bc->get('root', 'appfs-reset') == 1 || $bc->get('root', 'rootfs-reset') == 1 || $bc->get('root', 'userappfs-reset') == 1) {
			$ret .= "<div style='text-align:center;font-weight:bold;color:red;'>Inappropriate Rootfs Storage to firmware downgrade<br/>Please reinstall the current firmware. And once in Normal-mode, restore the"
						. " Old-Rootfs configuration from the 'Miscellaneous Settings' before to downgrade the firmware</div>";
		}
		else {
			$ret .= "<div style='text-align:center;font-weight:bold;color:red;'>Inappropriate RootFs Storage to firwmare downgrade<br/>Please reboot in Normal-mode and restore the Old-Rootfs configuration "
						.	"from the 'Miscellaneous Settings' before to downgrade the firmware</div>";
		}
	}
	else if (file_exists('/tmp/homeadmin_notenough_space')) {
		$ret .= "<div style='text-align:center;font-weight:bold;color:red;'>Not enough space to upgrade the Firmware<br/>Please reboot in Normal-mode and remove unused Apps<br/>If the problem persists, ".
						"please contact beroNet-support</div>";
	}

	$versionLine = ((file_exists('/usr/local/FILENAME')) ? str_replace('.fw', '', str_replace('.tar.gz', '', file_get_contents('/usr/local/FILENAME'))) : 'none');

	exec('/bin/grep nameserver /etc/resolv.conf', $output, $retval);
	$dns_on = (($retval == 0) ? 1 : 0);
	unset($output);
	unset($retval);

	exec('/bin/ping -c 1 beronet.com', $output, $retval);
	$dns_works = (($retval == 0) ? 1 : 0);
	unset($output);
	unset($retval);

	if ($dns_on && $dns_works) {
                // new rootfs firmware from beroNet server
		if (!defined('PHP_VERSION_ID')) {
                	$ret .= displayRootfsTable($upd->getdownloadlist('rootfs.list'), $versionLine);
		}

		// firmware list from beroNet server
		$file_list = $upd->getdownloadlist();
		if (($file_list != false) && (count($file_list) > 0)) {
			$ret .=	'<h3>Download Update-Package from beroNet</h3>' . "\n" .
				'<table style="font-size: 13px;">' . "\n" .
				'<tr><th>Name</th><th>Type</th><th>Release Notes</th><th>Action</th></tr>' . "\n";
			foreach ($file_list as $entry) {
				$ret .=	'<tr>' . "\n" .
					'<td>' . $entry['name'] . '</td>' . "\n" .
					'<td>' . $entry['type'] . '</td>' . "\n" .
					'<td>' . ((strlen($entry['notesurl']) != 0) ? '<a href="' . $entry['notesurl'] . '" target="_blank">open</a>' : 'none') . '</td>' . "\n" .
					'<td>' . "\n" .
					'<form action="/cgi-bin/update-tool.php" method="POST">' . "\n" .
					'<input type="hidden" name="action" value="download" />' . "\n" .
					'<input type="hidden" name="package_url" value="' . $entry['url'] . '" />' . "\n" .
					'<input type="submit" value="Download" />' . "\n" .
					'</form>' . "\n" .
					'</td>' . "\n" .
					'</tr>' . "\n";
			}
			$ret .=	'</table><br />' . "\n";
		}

		// download a firmware from an URL
		$ret .=	'<h3>Download Update-Package from Web</h3>' . "\n" .
			'<span style="font-size: 11px;">Downloading an Update-Package from a Webserver can take a few minutes.<br />' . "\n" .
			'Please do not abort the download-process!</span><br /><br />' . "\n" .
			'<form action="/cgi-bin/update-tool.php" method="POST">' . "\n" .
			'<input type="hidden" name="action" value="download" />' . "\n" .
			'<input type="input" name="package_url" style="font-size: 10px; font-family: monospace; width: 400px; margin-bottom: 5px;" /><br />' . "\n" .
			'<input type="submit" value="Download" />' . "\n" .
			'</form><br />';
	}

	// upload manually a firmware
	$ret .= '<h3>Upload Update-Package from your Computer</h3>' . "\n" .
		'<form enctype="multipart/form-data" action="/cgi-bin/update-tool.php" method="POST">' . "\n" .
		'<input type="hidden" name="action" value="upload" />' . "\n" .
		'<input type="hidden" name="MAX_FILE_SIZE" value="52428800" />' . "\n" .
		'<input type="file" name="userfile" required/>' . "\n" .
		'<input type="submit" value="Upload" />' . "\n" .
		'</form>' . "\n" .
		'<div style="font-size: 10px; text-align: right;">Currently installed: ' . $versionLine . '</div>' . "\n";

	return($ret);
}

function display_install_information ($pipe_file = '/tmp/install_pipe', $reboot_file = '/tmp/reboot_after_update') {

        echo    '<h3>Installation-Progress</h3>' . "\n" .
                '<div style="text-align: left;">' . "\n" .
                '<pre>' . "\n";

        system("/usr/bin/tail -f $pipe_file");

        echo    '</pre><br/><br/>' . "\n" .
		'<script type="text/javascript">window.setTimeout(\'setRequest()\', ' . (file_exists($reboot_file) ? '7000' : '1000') . ');</script>' . "\n" .
                'Please wait until you will be redirected to the login-page or click <a href="/">here</a> to login.<br />' . "\n" .
                '</div>' . "\n";
}


$gui = new berogui_small('beroNet VoIP Gateway: Firmware-Update');
$upd = new updateTool();

echo	$gui->header(($_POST['action'] == 'install') ? 0 : 1) .
	'<div style="text-align: center;">' . "\n";

$pid_file = '/var/run/install_daemon.pid';

if (file_exists($pid_file)) {
        echo display_install_information();
}
else {

        switch ($_POST['action']) {
                default:
                case 'upload':
                        if (!(isset($_FILES['userfile']['name']))) 
			{
                                echo display_upload($bc, $upd);
                                break;
                        }

                        if (strlen($_FILES['userfile']['name']) == 0 || strlen($_FILES['userfile']['tmp_name']) == 0 || $_FILES['userfile']['size'] == 0)                           
                        {                                                                                                                                                          
                                echo '<div style="text-align: center; font-weight: bold; color: red;">No File selected. Please select a file to upload.</div>';                     
                                echo display_upload($bc, $upd);
                                break;                                                                                                                                              
                        }  

                        $ret = $upd->upload($_FILES);
                        if ($ret['message'] != false) {
                                echo    '<h3>Messages</h3>' . "\n" .
                                (($ret['error'] == true) ? 'Error:' : 'Warning:') . ' ' . $ret['message'] . "\n";
                        }

                        echo (($ret['filename'] != false) ? display_install($ret['filename']) : display_upload($bc, $upd));
                        break;
                case 'download':
                        $ret = $upd->download($_POST['package_url']);
                        if ($ret['message'] != false) {
                                echo    '<h3>Messages</h3>' . "\n" .
                                        (($ret['error'] == true) ? 'Error:' : 'Warning:') . ' ' . $ret['message'] . "\n";
                        }
                        echo (($ret['filename'] != false) ? display_install($ret['filename']) : display_upload($bc, $upd));
                        break;
                case 'delete':
                        echo    '<h3>Messages</h3>' .
                                'Deleting Update-Package \'' . $_POST['file'] . '\' was ' . ($upd->pkgdelete($_POST['file']) ? '' : 'un') . 'successful.' .
                                display_upload($bc, $upd);
                        break;
                case 'install':
                        echo    '<h3>Installation-Progress</h3>' . "\n" .
                                '<div style="text-align: left;">' . "\n" .
                                '<pre>' . "\n";

                        $retval = $upd->install($_POST['file']);
                        if ($retval != 0) {
                                echo    '</pre>' . "\n" .
                                'Error: Could not install Update-Package \'' . $_POST['file'] . '\'! (returned ' . $retval . ')' . "\n" .
                                '</div>' . "\n";
                                break;
                        }


                        echo    '</pre><br /><br />' . "\n" .
                                '<script type="text/javascript">window.setTimeout(\'setRequest()\', ' . (file_exists('/tmp/reboot_after_update') ? '7000' : '1000') . ');</script>' . "\n" .
                                'Please wait until you will be redirected to the login-page or click <a href="/">here</a> to login.<br />' . "\n" .
                                '</div>' . "\n";
                        break;
        }
}

echo	'</div>' . "\n" .
	$gui->footer('update-tool');

if (file_exists('/tmp/reboot_after_update')) {
            exec('/sbin/reboot');
}

?>
