<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('/usr/fallback/beroConf.php');

if (!defined('_BEROGUI_SMALL_CLASS')) {
	define('_BEROGUI_SMALL_CLASS', true);

	class berogui_small {

		private $_title;
		private $_bc;

		function __construct ($title = 'beroNet VoIP Gateway: Recovery Utility') {

			$this->_title = $title;
			$this->_bc = new beroConf('root');
		}

		private function _draw_jumper () {

			$jumper_file = '/sys/class/beronet/gateway/resetjumper';

			if ((!file_exists($jumper_file)) || (($jumper_setting = trim(file_get_contents($jumper_file), "\n\r ")) == '0')) {
				return('');
			}

			$ret =	'<div style="text-align: center; font-weight: bold; color: red;">' . "\n" .
				'<span style="font-size: 18px;">Warning!</span><br />' . "\n" .
				'The Factory-Reset-Jumper is inserted. Please remove the Jumper to preserve changes you make.' . "\n" .
				'</div>' . "\n";

			return($ret);
		}

		private function _draw_menu () {

			$ret =	'<ul>' . "\n";

			if ($this->_bc->get('root', 'boot_fwupdate') != '1') {
				$ret .= '<li><a href="/">Main</a></li>' .
					'<li><a href="/cgi-bin/info.php">Information</a></li>' .
					'<li><a href="/cgi-bin/management.php">Management</a></li>' .
					'<li><a href="/cgi-bin/network-tool.php">Network-Configuration</a></li>';
			}

			$ret .= '<li><a href="/cgi-bin/update-tool.php">Firmware-Update</a></li>' .
				'<li><a href="/cgi-bin/reboot.php">Reboot</a></li>' . "\n" .
				'</ul>' . "\n";

			return($ret);
		}

		function header ($display_menu = 1) {

			$ret =	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 Transitional//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11-transitional.dtd">' . "\n" .
				'<html xmlns="http://www.w3.org/1999/xhtml">' . "\n" .
				'<head>' . "\n" .
				'<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>' . "\n" .
				'<title>' . $this->_title . '</title>' . "\n" .
				'<link rel="stylesheet" type="text/css" href="/css/berogui.css" />' . "\n" .
				'<link rel="icon" href="/img/favicon.ico" type="image/x-icon" />' . "\n" .
				'<script src="/js/functions.js"></script>' . "\n" .
				'</head>' . "\n" .
				'<body>' . "\n" .
				'<div id="container">' . "\n" .
				'<div id="header">' . "\n" .
				'<div id="logo"></div>' . "\n" .
				'<div id="navigation">' . "\n" .
				(($display_menu == 1) ? $this->_draw_menu() : '') .
				'</div>' . "\n" .
				'<div style="clear: both;"></div>' . "\n" .
				'</div>' . "\n" .
				'<div id="headline">' . $this->_title . '</div>' . "\n" .
				$this->_draw_jumper();

			return($ret);
		}

		function footer ($helpsection = 'default', $version_file = "/usr/local/VERSION") {

			// default value
			$year = "2019";			

			//update year 
			if (file_exists($version_file))
			{
				$import_year = file_get_contents($version_file);
				preg_match("/YEAR=([0-9]*)/", $import_year, $output_year);

				if (isset($output_year[1])) 
				{
        				$year = $output_year[1];
				}
			}
			else 
			{
				// get year from server
				exec("/bin/cat /usr/conf/misc.conf | /bin/grep ntphost | /usr/bin/cut -d '=' -f 2", $ntphost);
				if (isset($ntphost[0]) && strlen($ntphost[0]) > 0)  {
        				exec("/bin/ping -c 1 $ntphost[0]", $output, $retval);
	        			$dns_works = (($retval == 0) ? 1 : 0);

					if ($dns_works) {
						system("/usr/local/bin/rdate -ns $ntphost[0]");
						$year = date('Y');
					}
				}
			}

			// display footer
			$ret =	'<div id="footer">' . "\n" .
				'Copyright &copy; '.$year.' beroNet GmbH, Germany' . "\n" .
				'<div id="help-button">' . "\n" .
				'<a href="http://wiki.beronet.com/index.php/RecoveryGUI:' . $helpsection . '" target="_blank"><img src="/img/help_button.png" /></a>' . "\n" .
				'</div>' . "\n" .
				'</div>' . "\n" .
				'</div>' . "\n" .
				'</body>' . "\n" .
				'</html>';

			return($ret);
		}
	}
}

?>
