<?php
# VERSION=11
# CHANGES="New GUI-Design."

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('/usr/fallback/beroConf.php');
include('/usr/www/include/berogui_small.class.php');

function get_app_master ($app_root) {

	if (!is_dir($app_root) || !($dh = opendir($app_root))) {
		return(NULL);
	}

	while (($app_name = readdir($dh)) !== false) {
		if (($app_name == '.') || ($app_name == '..')) {
			continue;
		}

		$app_version = $app_root . '/' . $app_name . '/VERSION';

		if (!($fp = fopen($app_version, 'r'))) {
			continue;
		}

		$fcont = fread($fp, filesize($app_version));
		fclose($fp);

		if (strstr($fcont, 'CLASS=master')) {
			closedir($dh);
			return($app_name);
		}

	}

	closedir($dh);

	return(NULL);
}

function body() {
	$str =	"\t<div style='text-align:center;'>\n"
				.	"\t\t<h3>Welcome to the beroNet VoIP Gateway Recovery-Utility!</h3>\n"
				. "\t\tThese pages are only displayed to you if you either want to update the firmware of your beroNet SBC / beroNet VoIP Gateway,<br/>\n"
				.	"\t\tmade the choice of booting in recovery-mode, or something has gone terribly wrong.<br/><br/>\n"
				. "\t\tMultiple possibilities are offered:\n"
				. "\t\t<ol style='text-align:left; margin-left:15%;'>\n"
				. "\t\t\t<li>Reboot and restore the generated backup</li>\n"
				. "\t\t\t<li>Install a new <a href='/cgi-bin/update-tool.php'>Firmware</a></li>\n"
				. "\t\t\t<li>Manage/Recover your device under <a href='/cgi-bin/management.php'>Management</a></li>\n"
				. "\t\t</ol>\n"
				. "\t\t</br>"
				. "\t\tGood luck!<br/><br/>Your beroNet Development Team\n"
				. "\t</div>\n";
	if (file_exists('/tmp/beroNetVoIPGateway_recoverymode.config.xml')) {
 		$str .= "\t<div style='text-align:center;margin-top:15px;'>\n"
					. "\t\t<h3>Backup</h3>\n"
					. "\t\t<div style='display:inline-flex;'>\n"
					. "\t\t\t<form name='dl-backupform' method='GET' action='cgi-bin/backup.php'>\n"
					. "\t\t\t\t<input type='hidden' name='action' value='download'>\n"
					. "\t\t\t\t<input type='hidden' name='filename' value='beroNetVoIPGateway_recoverymode.config.xml'>\n"
					. "\t\t\t\t<input type='submit' value='Download'>\n"
					. "\t\t\t</form>\n";
		if (file_exists('/usr/local/VERSION')) {
			$str .= "\t\t\t<form name='rstr-backupform' method='POST' action='cgi-bin/reboot.php'>\n"
						. "\t\t\t\t<input type='hidden' name='action' value='restore'>\n"
						. "\t\t\t\t<input type='submit' value='Restore & Reboot'>\n"
						. "\t\t\t</form>\n";
		}
		$str .= "\t\t</div>\n"
					.	"\t</div>\n";
	}
	return($str);
}

## php script loaded -> has activity. We avoid cron task to reboot the device
file_put_contents('/tmp/has_activity', 1);

$userapp_root		= '/apps';
$userapp_master_dir	= get_app_master($userapp_root);
$userapp_master_www	= file_exists($userapp_root . '/' . $userapp_master_dir . '/www/index.php');

$bc = new beroConf('root');
require_once('/usr/www/include/redirect.php');

$gui = new berogui_small('beroNet VoIP Gateway: Recovery-Utility');

echo	$gui->header()
		.	body()
		.	$gui->footer();
?>
