#!/bin/bash
#
# VERSION=4
# CHANGES="rewritten for new naming-scheme"

MAJOR1=$(expr match "${1}" "\([0-9]\{1,10\}\)")
MINOR1=$(expr match "${1}" "[0-9]\{1,10\}.\([0-9]\{1,10\}\)")
SUBTYPE_A1=$(expr match "${1}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}\([a-z]\{1,32\}\)")
SUBVERS_A1=$(expr match "${1}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}\([0-9]\{1,10\}\)")
SUBTYPE_B1=$(expr match "${1}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}[0-9]\{1,10\}-\{0,1\}\([a-z]\{1,32\}\)")
SUBVERS_B1=$(expr match "${1}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}\([0-9]\{1,10\}\)")

MAJOR2=$(expr match "${2}" "\([0-9]\{1,10\}\)")
MINOR2=$(expr match "${2}" "[0-9]\{1,10\}.\([0-9]\{1,10\}\)")
SUBTYPE_A2=$(expr match "${2}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}\([a-z]\{1,32\}\)")
SUBVERS_A2=$(expr match "${2}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}\([0-9]\{1,10\}\)")
SUBTYPE_B2=$(expr match "${2}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}[0-9]\{1,10\}-\{0,1\}\([a-z]\{1,32\}\)")
SUBVERS_B2=$(expr match "${2}" "[0-9]\{1,10\}.[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}[0-9]\{1,10\}-\{0,1\}[a-z]\{1,32\}\([0-9]\{1,10\}\)")

# echo -e "MAJOR: ${MAJOR1}\t| ${MAJOR2}"
# echo -e "MINOR: ${MINOR1}\t| ${MINOR2}"
# echo -e "SUBTA: ${SUBTYPE_A1}\t| ${SUBTYPE_A2}"
# echo -e "SUBVA: ${SUBVERS_A1}\t| ${SUBVERS_A2}"
# echo -e "SUBTB: ${SUBTYPE_B1}\t| ${SUBTYPE_B2}"
# echo -e "SUBVA: ${SUBVERS_B1}\t| ${SUBVERS_B2}"

if [ ${MAJOR1} -lt ${MAJOR2} ]; then
	echo 1
	exit 1
elif [ ${MAJOR1} -gt ${MAJOR2} ]; then
	echo 0
	exit 0
fi

if [ ${MINOR1} -lt ${MINOR2} ]; then
	echo 1
	exit 1
elif [ ${MINOR1} -gt ${MINOR2} ]; then
	echo 0
	exit 0
fi

# ${MAJOR1} == ${MAJOR2} && ${MINOR1} == ${MINOR2}
#

if [ "${3}" != "deepcheck" ]; then
	echo 1
	exit 1
fi

# main-release installed
if [ -z "${SUBTYPE_A1}" ]; then
	if [ "${SUBTYPE_A2}" = "sp" ]; then
		echo 1
		exit 1
	fi
fi

case "${SUBTYPE_A1}" in
	# pre-release installed
	pre)
		case "${SUBTYPE_A2}" in
			pre)
				if [ ${SUBVERS_A1} -lt ${SUBVERS_A2} ]; then
					echo 1
					exit 1
				fi
				echo 0
				exit 0
				;;
			beta)
				echo 0
				exit 0
				;;
		esac
		echo 1
		exit 1
		;;
	# beta installed
	beta)
		if [ "${SUBTYPE_A2}" = "beta" ]; then

			# check for greater or lesser
			if [ ${SUBVERS_A1} -lt ${SUBVERS_A2} ]; then
				echo 1
				exit 1
			elif [ ${SUBVERS_A1} -gt ${SUBVERS_A2} ]; then
				echo 0
				exit 0
			fi

			# no further subtypes
			if [ -z "${SUBTYPE_B1}" ] && [ -z "${SUBTYPE_B2}" ]; then
				echo 0
				exit 0
			fi

			# beta release canditate installed
			if [ "${SUBTYPE_B1}" = "rc" ]; then
				if [ "${SUBTYPE_B2}" = "rc" ]; then
					if [ ${SUBVERS_B1} -lt ${SUBVERS_B2} ]; then
						echo 1
						exit 1
					elif [ ${SUBVERS_B1} -ge ${SUBVERS_B2} ]; then
						echo 0
						exit 0
					fi
				else
					echo 1
					exit 1
				fi
			fi
		fi
		echo 1
		exit 1
		;;
	# release-candidate installed
	rc)
		case "${SUBTYPE_A2}" in
			rc)
				if [ ${SUBVERS_A1} -lt ${SUBVERS_A2} ]; then
					echo 1
					exit 1
				fi
				echo 0
				exit 0
				;;
			pre|beta)
				echo 0
				exit 0
				;;
		esac
		echo 1
		exit 1
		;;
	# service pack installed
	sp)
		case "${SUBTYPE_A2}" in
			sp)
				# check for greater or lesser
				if [ ${SUBVERS_A1} -lt ${SUBVERS_A2} ]; then
					echo 1
					exit 1
				elif [ ${SUBVERS_A1} -gt ${SUBVERS_A2} ]; then
					echo 0
					exit 0
				fi

				# no further subtypes
				if [ -z "${SUBTYPE_B1}" ] && [ -z "${SUBTYPE_B2}" ]; then
					echo 0
					exit 0
				fi

				case "${SUBTYPE_B1}" in
					# new release-candidate to be installed
					rc)
						if [ "${SUBTYPE_B2}" = "rc" ]; then
							if [ ${SUBVERS_B1} -lt ${SUBVERS_B2} ]; then
								echo 1
								exit 1
							fi
							echo 0
							exit 0
						elif [ -z "${SUBTYPE_B2}" ]; then
							echo 1
							exit 1
						fi
						;;
					# customer-release to be installed
					*)
						if [ "${SUBTYPE_B1}" = "${SUBTYPE_B2}" ]; then
							if [ ${SUBVERS_B1} -lt ${SUBVERS_B2} ]; then
								echo 1
								exit 1
							fi
							echo 0
							exit 0
						fi
						;;
				esac
				;;
		esac
		;;
	# customer release installed
	*)
		if [ "${SUBTYPE_A1}" = "${SUBTYPE_A2}" ]; then
			if [ ${SUBVERS_A1} -lt ${SUBVERS_A2} ]; then
				echo 1
				exit 1
			fi
			echo 0
			exit 0
		fi
	;;
esac

echo 0
exit 0
