#!/bin/bash
#
# VERSION=26
# CHANGES="clean new libcrypto and libssl libraries path during downgrade"
#

# constants #
PIDFILE=/var/run/install_daemon.pid
PIPEFILE=/tmp/install_pipe

# functions #

function clean_openssl_library {
	library_type=$1
	library_name=$(cd /home/admin/lib && ls ${library_type}.so.*)
	if [ ! -z ${library_name} ];
	then
		mount -o remount,rw /home/admin
		rm -f /home/admin/lib/${library_type}.so*
		mount -o remount,ro /home/admin
		sync; sleep 1; sync

		mount -o remount,rw /
		rm -f /usr/bin/${library_name}
		mount -o remount,ro /
	fi
}

# main #
if [ -z "${1}" ]; then
	echo "ERROR: No Package specified, leaving."
	exit 1
fi

# check if there is a PIDFILE
if [ -f ${PIDFILE} ]; then
	echo "ERROR: An Installation-Process seems to be running already, leaving."
	exit 2
fi

#check the /mnt/images link
mntimages=`readlink /mnt/images|sed 's/\/$//'`
if [[ "$mntimages" != /tmp/images ]]; then
	rm -f /mnt/images
	ln -s /tmp/images /mnt/images
fi

#check if we need to make a downgrade
tar xzf /mnt/images/${1} VERSION -C /tmp
if [ ! -f /tmp/VERSION ];
then
	tar xzf /mnt/images/${1} usr/local/VERSION -C /tmp
	mv /tmp/usr/local/VERSION /tmp/
fi

source /tmp/VERSION
if [ "${APPFS}" -eq "3" ];
then
	if [ -f /usr/local/downgrade-builtin.tar.gz ];
	then
		#we allow installing FW 16.11 to 16.19
		echo $1 |grep 'appfs-16.1[1-9]' &> /dev/null
		if [ $? = 0 ]; then
			rm /tmp/VERSION
			echo Preparing downgrading to $1
			cp /usr/local/downgrade-builtin.tar.gz /mnt/images/
			/usr/fallback/install.sh downgrade-builtin.tar.gz
			touch /tmp/DOWNGRADED

			if [ ! -z ${OPENSSL} ];
			then
				## we clean the openssl libraries from /home/admin
				clean_openssl_library "libcrypto"
				clean_openssl_library "libssl"
			fi
		fi
	else
		echo Cannot downgrade to $1
	fi
fi

# create named pipe to catch output
rm -f ${PIPEFILE}
/bin/mknod ${PIPEFILE} p

if [ "${1}" == "rootfs.tar.gz" ]; then
	/sbin/start-stop-daemon -S -b -m -p ${PIDFILE} -x /usr/sbin/install_rootfs_daemon.sh -- ${1}
	sleep 2
else
	/sbin/start-stop-daemon -S -b -m -p ${PIDFILE} -x /usr/sbin/install_daemon.sh -- ${1}
	sleep 2
fi

while true; do
	if [ ! -f ${PIDFILE} ]; then
		killall -3 tail
		break
	fi
	sleep 2
done &

tail -f ${PIPEFILE}

sleep 1
rm -f ${PIPEFILE}

#delete the install package
if [ -f /mnt/images/"$1" ]; then
	rm /mnt/images/"$1"
fi

exit 0
