<?php

if (!defined('_CONFIGEXPORTIMPORTTOOL_CLASS')) {
	define('_CONFIGEXPORTIMPORTTOOL_CLASS', true);

	include('/usr/php/include/verySimpleXmlParser.php');
	include_once("/usr/www/include/SQLite2ToSQLite3.php");
	include_once("/usr/local/www/berogui/misc/database.php");
	include_once '/usr/fallback/beroConf.php';

	class configExportImportTool {

		private $_configPath;
		private $_fileList;
		private $_xmlData;

		private $_ba;
		private $_is_sbc_vm = false;
		
		function __construct ($fileName = null) {
		
			$this->_ba = new beroAri();
			$this->_is_sbc_vm = $this->_ba->get('is_sbc_vm');
			
			if ($this->_is_sbc_vm) {
				$this->_configPath = "/etc/beroNet/isgw/";
				$this->_fileList = array('isgw.conf', 'isgw.dialplan', 'isgw.sip', 'isgw.whitelist', 'misc.conf', 'network.acl');
			}
			else {
				$this->_configPath  = "/usr/conf/";
				$this->_fileList = array('hardware.conf', 'isgw.analog', 'isgw.cas', 'isgw.causes', 'isgw.conf', 'isgw.cpt', 'isgw.dialplan',
					'isgw.gsm', 'isgw.lte', 'isgw.isdn', 'isgw.sip', 'isgw.tdm', 'isgw.whitelist', 'misc.conf', 'network.acl');
			}

			$this->_xmlData = null;

			if ($fileName != null) {
				if (substr($fileName, -3) == '.gz') {
					exec("gzip -d $fileName");
					$fileName = substr($fileName, 0, -3);
				}
				if (($this->_xmlData = xmlParseData(file_get_contents($fileName))) === false) {
					exit(false);
				}
			}

		}

		private function _exportGatewayConfig () {

			unset($files);
			foreach ($this->_fileList as $confFile) {
				$files .=	"\t\t" . '<File>' . "\n" .
						"\t\t\t" . '<Name>' . $confFile . '</Name>' . "\n" .
						"\t\t\t" . '<Contents>' . "\n" .
						file_get_contents($this->_configPath . '/' . $confFile) . "\n" .
						"\t\t\t" . '</Contents>' . "\n" .
						"\t\t" . '</File>' . "\n";
			}

			$ret =	"\t" . '<Config>' . "\n" .
				"\t\t" . '<Update>yes</Update>' . "\n" .
				"\t\t" . '<Activate>3</Activate>' . "\n" .
				$files .
				"\t" . '</Config>' . "\n";

			return($ret);

		}

		private function _isBinary ($fileName, $maxLimit = 1024) {

			$size = filesize($fileName);
			$limit = ($size > $maxLimit) ? $maxLimit : $size;
			$data = file_get_contents($fileName, false, null, -1, $limit);

			// everything with char \0 is binary
			for ($i = 0; $i < $limit; $i++) {
				if ($data[$i] == "\0") {
					return(true);
				}
			}

			// XML-files are also handled as binary data
			if (strpos($data, '<?xml') !== false) {
				return(true);
			}

			return(false);
		}

		private function _getFileList ($dirName, &$dirArray) {

			$files = array_diff(scandir($dirName), array('.', '..'));
			if (empty($files)) {
				return;
			}

			foreach($files as $val) {
				$dirArray[$dirName][] = $val;
				if(is_dir($dirName . '/' . $val)) {
					$this->_getFileList($dirName . '/' . $val, $dirArray);
				}
			}
			@ksort($dirArray);
		}

		private function _getAppConfig () {

			$baseDir = '/usr/conf/userapp';

			if (!is_dir($baseDir)) {
				return(null);
			}

			$apps = array_diff(scandir($baseDir), array('.', '..'));

			$i = 0;
			foreach ($apps as $app) {

				// get config-files of app
				unset($appFiles);
				$this->_getFileList($baseDir . '/' . $app, $appFiles);
				if (empty($appFiles)) {
					continue;
				}

				// save all info in array
				$ret[$i]['name'] = $app;
				$j = 0;
				foreach ($appFiles as $key => $val) {

					foreach ($val as $item) {
						$filePath = $key . '/' . $item;
						$fileMode = $this->_isBinary($filePath);
						$ret[$i]['files'][$j]['name'] = strstr($filePath, $app);
						if (is_dir($filePath)) {
							$ret[$i]['files'][$j]['mode'] = 'directory';
							$j++;
							continue;
						}
						$ret[$i]['files'][$j]['mode'] = ($fileMode ? 'binary' : 'text');
						$contentRaw = file_get_contents($filePath);
						$ret[$i]['files'][$j]['content'] = ($fileMode ? base64_encode($contentRaw) : trim($contentRaw));
						unset($contentRaw);
						$j++;
					}
				}
				$i++;
			}

			return(empty($ret) ? null : $ret);
		}

		private function _exportAppConfig () {

			if (($apps = $this->_getAppConfig()) == null) {
				return('');
			}

			$ret =	"\t" . '<AppConfig>' . "\n";

			foreach ($apps as $app) {
				if (empty($app['files'])) {
					continue;
				}

				$ret .=	"\t\t" . '<App>' . "\n" .
					"\t\t\t" . '<Name>' . $app['name'] . '</Name>' . "\n";

				foreach ($app['files'] as $appFile) {
					$ret .= "\t\t\t" . '<File>' . "\n" .
						"\t\t\t\t" . '<Name>' . $appFile['name'] . '</Name>' . "\n" .
						"\t\t\t\t" . '<Mode>' . $appFile['mode'] . '</Mode>' . "\n" .
						(($appFile['mode'] == 'directory') ? '' :	"\t\t\t\t" . '<Content>' . "\n" .
												$appFile['content'] . "\n" .
												"\t\t\t\t" . '</Content>' . "\n") .
						"\t\t\t" . '</File>' . "\n";
				}
				$ret .= "\t\t" . '</App>' . "\n";
			}

			$ret .=	"\t" . '</AppConfig>' . "\n";

			return($ret);
		}

		public function exportConfig () {

			$ret = '<?xml version="1.0"?>' . "\n" .
				'<beroNetProvisioning>' . "\n" .
				"\t" . '<!-- Created on ' . date('c') . ' -->' . "\n" .
				$this->_exportGatewayConfig() .
				$this->_exportAppConfig() .
				'</beroNetProvisioning>' . "\n";

			return($ret);
		}

		private function _getSectionByName ($name) {

			if ($this->_xmlData == null) {
				return(false);
			}

			// check if this file is valid
			if ($this->_xmlData['name'] != 'beroNetProvisioning') {
				return(false);
			}

			// get the section with config-files
			foreach ($this->_xmlData['subsection'] as $section) {
				if ($section['name'] == $name) {
					return($section);
				}
			}

			return(false);
		}

		public function importConfigEnabled ($section) {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($config = $this->_getSectionByName($section)) === false) {
				return(false);
			}

			foreach ($config as $cfg_section) {
				if (!is_array($cfg_section)) {
					continue;
				}

				// get the subsections of File-section
				foreach ($cfg_section as $cfg_subsection) {
					if ($cfg_subsection['name'] == 'Update') {
						return(($cfg_subsection['data'] == 'yes') ? true : false);
					}
				}
			}

			return(false);
		}

		public function getConfigFiles () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($config = $this->_getSectionByName('Config')) === false) {
				return(false);
			}

			// get all File-sections
			foreach ($config as $cfg_section) {
				if (!is_array($cfg_section)) {
					continue;
				}

				// get the subsections of File-section
				$i = 0;
				foreach ($cfg_section as $cfg_file) {

					unset($cfg_file_attr_name);
					unset($cfg_file_attr_data);

					if ($cfg_file['name'] != 'File') {
						continue;
					}

					foreach ($cfg_file['subsection'] as $cfg_file_attr) {
						switch($cfg_file_attr['name']) {
						case 'Name':		$ret[$i]['name'] = $cfg_file_attr['data'];	break;
						case 'Contents':	$ret[$i]['data'] = $cfg_file_attr['data'];	break;
						}
					}
					$i++;
				}
			}

			return((count($ret) > 0) ? $ret : false);
		}

		public function getConfigActivate () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($config = $this->_getSectionByName('Config')) === false) {
				return(false);
			}

			foreach ($config as $cfg_section) {
				if (!is_array($cfg_section)) {
					continue;
				}

				foreach ($cfg_section as $cfg_subsec) {
					if ($cfg_subsec['name'] == 'Activate') {
						return($cfg_subsec['data']);
					}
				}
			}

			return(false);
		}

		public function getAppConfigFiles () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($apps = $this->_getSectionByName('AppConfig')) === false) {
				return(false);
			}

			foreach ($apps as $app) {
				if (!is_array($app)) {
					continue;
				}

				$i = 0;
				foreach ($app as $appConfig) {
					$j = 0;
					foreach ($appConfig['subsection'] as $appConfigSub) {
						if ($appConfigSub['name'] == 'Name') {
							$ret[$i]['name'] = $appConfigSub['data'];
						}

						if (!is_array($appConfigSub['subsection'])) {
							continue;
						}

						foreach ($appConfigSub['subsection'] as $confFileAttr) {
							switch ($confFileAttr['name']) {
							case 'Name':	$ret[$i]['files'][$j]['name'] = $confFileAttr['data'];		break;
							case 'Mode':	$ret[$i]['files'][$j]['mode'] = $confFileAttr['data'];		break;
							case 'Content':	$ret[$i]['files'][$j]['content'] = $confFileAttr['data'];	break;
							}
						}
						$j++;
					}

					$i++;
				}
			}

			return((count($ret) > 0) ? $ret : false);
		}

		public function getFirmwareInstallInfo () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($attributes = $this->_getSectionByName('Firmware')) === false) {
				return(false);
			}

			unset($ret);
			foreach ($attributes['subsection'] as $attribute) {
				switch ($attribute['name']) {
				case 'Install':		$ret['install'] = $attribute['data'];	break;
				case 'Filename':	$ret['package'] = $attribute['data'];	break;
				}
			}

			return(isset($ret) ? $ret : false);
		}

		public function getAppInstallInfo () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($apps = $this->_getSectionByName('Apps')) === false) {
				return(false);
			}

			unset($ret);
			$i = 0;
			foreach ($apps['subsection'] as $app) {
				if (!is_array($app)) {
					continue;
				}

				foreach ($app['subsection'] as $app_attr) {
					switch ($app_attr['name']) {
					case 'Install':		$ret[$i]['install'] = $app_attr['data'];	break;
					case 'Filename':	$ret[$i]['package'] = $app_attr['data'];	break;
					}
				}
				$i++;
			}

			return($ret);
		}

	}

} /* _CONFIGEXPORTIMPORTTOOL_CLASS */

?>
