<?php

if (!defined('_PROVISIONINGTOOL_CLASS')) {
	define('_PROVISIONINGTOOL_CLASS', true);

	include_once("/usr/www/include/SQLite2ToSQLite3.php");
	include('/usr/fallback/beroConf.php');
	include('/usr/php/include/updateTool.php');
	include('/usr/php/include/configExportImportTool.class.php');
	include_once ('/usr/local/php/include/restore.Class.php');
	require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
	require_once('/usr/local/www/berogui/includes/fileManagement.php');

	class provisioningTool {

		private $_beroConf;
		private $_restore;

		private $_provMode;
		private $_provUrl;
		private $_pollingInterval;
		private $_provPath;
		private $_provFile;
		private $_provOpts;

		private $_stdout = '';

		private $_tempPath;
		private $_confPath;

		private $_configFileMandantoryListOld;
		private $_configFileOtherListOld;
		private $_configFileListOld;

		function __construct () {

			$this->_confPath	= '/usr/conf/';
			$this->_tempPath	= '/tmp/provisioning';

			$this->_beroConf	= new beroConf('root');
			$this->_restore		= new restoreConfig(0);

			$this->_provMode	= $this->_beroConf->get('root', 'provisioning_mode');
			$this->_provUrl		= $this->_beroConf->get('root', 'provisioning_url');
			$this->_pollingInterval	= $this->_beroConf->get('root', 'polling_interval');

			if (!file_exists($this->_tempPath)) {
				mkdir($this->_tempPath);
			}

			if (($this->_logFile = fopen('/var/log/provisioning.log', 'w')) == null) {
				exit(false);;
			}

			if (!strstr($this->_provUrl, 'http://') && !strstr($this->_provUrl, 'https://') && !strstr($this->_provUrl, 'tftp://')) {
				$this->_add2LogFile('ProvisioningTool', 'error', 'provisioning_url_malformed');
				exit(false);
			}

			$this->_parseUrl();

			$this->_configFileMandatoryListOld = array('isgw.conf', 'isgw.dialplan', 'isgw.sip', 'hardware.conf');
			$this->_configFileOtherListOld = array('isgw.isdn', 'isgw.gsm', 'isgw.analog', 'misc.conf', 'filter.conf', 'isgw.tones', 'isgw.causes');
			$this->_configFileListOld = array_merge($this->_configFileMandatoryListOld, $this->_configFileOtherListOld);
		}

		function __destruct () {

			fclose($this->_logFile);
			$this->_logFile = null;

			if ($this->_provMode == 'once') {
				$this->_beroConf->set('root', 'provisioning_mode', 'off');
			}

			system('/bin/rm -rf ' . $this->_tempPath);
		}

		public function getStdout() {
			return($this->_stdout);
		}

		private function _parseUrl () {

			# replace {MAC} with MAC-address of card
			if (strstr($this->_provUrl, '{MAC}')) {
				exec('/sbin/ifconfig eth0 | grep HWaddr', $output);
				preg_match('/HWaddr ([0-9A-Fa-f\:]*)/', $output[0], $matches);
				$cardMac = str_replace(':', '', $matches[1]);
				unset($output);
				unset($matches);

				$this->_provUrl = str_replace('{MAC}', $cardMac, $this->_provUrl);
			}

			# replace {SERIAL} with serial of card
			if (strstr($this->_provUrl, '{SERIAL}')) {
				$cardSerial = Helper::getSerial();
				$this->_provUrl = str_replace('{SERIAL}', $cardSerial, $this->_provUrl);
			}

			# split parts of URL
			$pathArray		= pathinfo($this->_provUrl);
			$this->_provPath	= $pathArray['dirname'];
			if (strstr($pathArray['basename'], '?')) {
				$this->_provFile	= substr($pathArray['basename'], 0, strpos($pathArray['basename'], '?'));
				$this->_provOpts	= substr($pathArray['basename'], strpos($pathArray['basename'], '?'), strlen($pathArray['basename']));
			} else {
				if (substr($this->_provUrl, - 1) == '/') {
					$this->_provPath .= '/' . $pathArray['basename'];
					$this->_provFile = '';
				} else {
					$this->_provFile = $pathArray['basename'];
				}
				$this->_provOpts	= '';
			}
			unset($pathArray);

			if (strlen($this->_provFile) == 0) {
				$this->_provFile = 'conf-update.conf';
			}
		}

		private function _add2LogFile ($function, $level, $message, $file = null, $stdout = 1) {

			if (($function == null) || ($level == null) || ($message == null)) {
				return;
			}

			$string = $function . ':' . $level . ':' . $message . (($file != null) ? ':' . $file : '') . "\n";

			if ($stdout == 1) {
				$this->_stdout .= "$string<br/>";
			}

			if ($this->_logFile != null) {
				fwrite($this->_logFile, $string);
			}
		}

		private function _firmwareDifferent ($provisionedFirmware) {

			if (!file_exists('/usr/local/FILENAME')) {
				return(true);
			}

			$installedFirmware = file_get_contents('/usr/local/FILENAME');

			preg_match('/^appfs-(?<version>[0-9\.a-z-]*).tar.gz$/', $installedFirmware, $res['installed']);
			preg_match('/^appfs-(?<version>[0-9\.a-z-]*).tar.gz$/', $provisionedFirmware, $res['provisioned']);

			# always true, if we cannot determine the provisioned version
			if (!isset($res['provisioned']['version'])) {
				return(true);
			}

			# always install if firmware are different
			return($res['installed']['version'] != $res['provisioned']['version']);
		}

		private function _rootfsDifferent () {
			## check if the PKG_VERSION from VERSION.rootfs differs between the old and installed one
			## if differ, we reboot the sbc
			if (!file_exists('/pkginfo/VERSION.rootfs')) {
				return(true);
			}
			$oldRootfs = parse_ini_file('/pkginfo/VERSION.rootfs');

			$newRootfs = null;
			if (file_exists('/usr/local/conf/rootfs/VERSION.rootfs')) {
				$newRootfs = parse_ini_file('/usr/local/conf/rootfs/VERSION.rootfs');
			}
			else if (file_exists('/home/admin/conf/rootfs/VERSION.rootfs')) {
				$newRootfs = parse_ini_file('/home/admin/conf/rootfs/VERSION.rootfs');
			}
			return($oldRootfs['PKG_VERSION'] != $newRootfs['PKG_VERSION']);
		}

		private function _getFile ($fileName, $tlsClient = '/usr/conf/tls/client.pem') {

			// init
			$installedFirmware = file_get_contents('/usr/local/FILENAME');
			preg_match('/appfs-(?<version>[0-9\.]*)-*(?<subtype>[a-z]*)(?<subversion>[0-9]*).tar.gz/', $installedFirmware, $matches);
			$ua_fw = $matches[1];

			for ($i = 0; $i < 3; $i++) {
				if (file_exists('/proc/li' . $i)) {
					preg_match('/type: ([0-9a-zA-Z\-]*)/', file_get_contents('/proc/li' . $i), $matches);
					$ua_modules .= Helper::getLiName(trim($matches[1])) . '/';
				}
			}
			$ua_modules = trim($ua_modules, "/");

			$ch = curl_init();

			// set curl options
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_URL, $this->_provPath . '/' . $fileName . (!strstr('tftp://', $this->_provPath) ? $this->_provOpts : ''));
			curl_setopt($ch, CURLOPT_USERAGENT, "beroNet Gateway v$ua_fw ($ua_modules)");

			if (file_exists($tlsClient)) {
				curl_setopt($ch, CURLOPT_CAINFO, $tlsClient);
				curl_setopt($ch, CURLOPT_CAPATH, $tlsClient);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $tlsClient);
			}

			if (substr('gzip', $fileName)) {
				curl_setopt($ch, CURL_HTTPHEADER, array('AcceptEncoding: gzip'));
			}

			$fileCont = curl_exec($ch);
			$res = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);

			switch ($res) {
			case '403':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:forbidden');
				return(false);
			case '404':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:not_found');
				return(false);
			case '500':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:configuration_error');
				return(false);
			default:
				break;
			}

			if (($res < 200) || ($res >= 400)) {
				$this->_add2LogFile(__FUNCTION__, 'error', "HTTP:status:$res");
				return(false);
			}

			return((file_put_contents($this->_tempPath . '/' . $fileName, $fileCont) === false) ? false : true);
		}

		/* BEGIN: Functions for backwards-compatibility */
		private function _isNewConfigFormat () {

			$data = file_get_contents($this->_tempPath . '/' . $this->_provFile);
			return((strpos($data, '<?xml version="1.0"?>') !== false) ? true : false);
		}


		private function _parseConfigOld ($config) {

			if (count($config) == 0) {
				return(false);
			}

			foreach ($config as $line) {
				if (($line[0] == '#') || (strlen($line) == 0)) {
					continue;
				}
				$key_val = explode('=', trim($line));
				$ret[$key_val[0]] = $key_val[1];
			}

			return($ret);

		}

		private function _updateConfigOld () {

			$config = $this->_parseConfigOld(file($this->_tempPath . '/' . $this->_provFile));

			if (!in_array($config['CONF_DOWNLOAD'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'config_download_disabled_by_server');
				return(true);
			}

			# get mandatory files
			foreach ($this->_configFileMandatoryListOld as $file) {
				if ($this->_getFile($file) == false) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $file);
					return(false);
				}
				$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded', $file);
			}

			# get other files
			foreach ($this->_configFileOtherListOld as $file) {
				$ret = $this->_getFile($file);
				$this->_add2LogFile(__FUNCTION__, (($ret == false) ? 'warning' : 'info'), (($ret == false) ? 'could_not_download' : 'downloaded'), $file);
			}

			# save old conf-files, move new config to /usr/conf
			@mkdir($this->_confPath . '/backup');

			foreach ($this->_configFileListOld as $file) {
				# create Backup
				if (file_exists($this->_confPath . '/' . $file)) {
					copy($this->_confPath . '/' . $file, $this->_confPath . '/backup/' . $file);
					unlink($this->_confPath . '/' . $file);
				}

				# install provisioned files
				if (file_exists($this->_tempPath . '/' . $file)) {
					$this->_add2LogFile(__FUNCTION__, 'info', 'installed', $file);
					copy($this->_tempPath . '/' . $file, $this->_confPath . '/' . $file);
				}

				# files that are not provisioned, will be copied back from backup
				if (!file_exists($this->_confPath . '/' . $file)) {
					copy($this->_confPath . '/backup/' . $file, $this->_confPath . '/' . $file);
				}
			}

			if ($this->_restore->restoreConfig() == true) {
				$this->_add2LogFile(__FUNCTION__, 'success', 'configuration_updated');
				return(true);
			}

			# Provisioning failed, restore Backup.
			$this->restoreBackup();
			$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_update_configuration');
			return(false);
		}

		private function _updateFirmwareOld () {

			if ($this->_getFile('firmware-update.conf') == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', 'firmware-update.conf');
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', 'firmware-update.conf');

			$config = $this->_parseConfigOld(file($this->_tempPath . '/firmware-update.conf'));

			if (!isset($config['FIRMWARE_FILE']) || !isset($config['FIRMWARE_DOWNLOAD']) || !isset($config['FIRMWARE_INSTALL'])) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'malformed_config_file', 'firmware-update.conf');
				return(false);
			}

			// now, allow also downgrade
			if ($this->_firmwareDifferent($config['FIRMWARE_FILE']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_provisioned_same_version');
				return(false);
			}

			if (!in_array($config['FIRMWARE_DOWNLOAD'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_download_disabled_by_server');
				return(true);
			}

			if ($this->_getFile($config['FIRMWARE_FILE']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $config['FIRMWARE_FILE']);
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $config['FIRMWARE_FILE']);

			if (!file_exists('/tmp/images')) {
				mkdir('/tmp/images');
			}
			system('/bin/mv ' . $this->_tempPath . '/' . $config['FIRMWARE_FILE'] . ' /tmp/images/' . $config['FIRMWARE_FILE']);

			if (!in_array($config['FIRMWARE_INSTALL'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_install_disabled_by_server');
				return(true);
			}

			$upd = new updateTool();

			if (($ret = $upd->install($config['FIRMWARE_FILE'], false)) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_update_failed', $config['FIRMWARE_FILE']);
				return(false);
			}

			$this->_add2LogFile(__FUNCTION__, 'success', 'firmware_updated', $config['FIRMWARE_FILE']);
			if ($this->_rootfsDifferent()) {
				exec('/sbin/reboot >/dev/null 2>&1 &');
			}

			return(true);
		}

		/* END: Functions for backwards-compatibility */

		public function updateConfig () {

			if ($this->_provMode == 'off') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'provisioning_disabled_by_gateway');
				return(true);
			}

			if ($this->_getFile($this->_provFile) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $this->_provFile);
				return(false);
			}

			if ($this->_isNewConfigFormat() == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'old_config_style_detected', $this->_provFile);
				return($this->_updateConfigOld());
			}

			$configMd5Old = $this->_beroConf->get('root', 'provisioning_config_md5');
			$configMd5New = md5(file_get_contents($this->_tempPath . '/' . $this->_provFile));
			if (strcmp($configMd5New, $configMd5Old) == 0) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'configuration_on_server_not_updated', $this->_provFile);
				return(true);
			}

			$imp = new configExportImportTool($this->_tempPath . '/' . $this->_provFile);

			// import provisioned configuration
			if ($imp->importConfigEnabled('Config') == false) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'config_provisioning_disabled_by_server');
				return(true);
			}

			$this->_add2LogFile(__FUNCTION__, 'info', 'config_provisioning_enabled_by_server');
			if (($configFiles = $imp->getConfigFiles()) === false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_update_config', $this->_provFile);
				return(false);
			}

			// create backup-directory
			if (!is_dir($this->_confPath . '/backup')) {
				mkdir($this->_confPath . '/backup');
			}

			foreach ($configFiles as $configFile) {
				// create backup of file
				@copy($this->_confPath . '/' . $configFile['name'], $this->_confPath . '/backup/' . $configFile['name']);
				@unlink($this->_confPath . '/' . $configFile['name']);

				// write file
				if (!($FP = fopen($this->_confPath . '/' . $configFile['name'], 'w'))) {
					$this->_add2LogFile(__FUNCTION__, 'warning', 'could_not_write', $configFile['name']);
					@copy($this->_confPath . '/backup/' . $configFile['name'], $this->_confPath . '/' . $configFile['name']);
					continue;
				}

				fwrite($FP, $configFile['data'], strlen($configFile['data']));
				fclose($FP);
				$FP = null;

				$this->_add2LogFile(__FUNCTION__, 'info', 'updated', $configFile['name']);
			}

			$this->_restore->restoreConfig();
			$this->_add2LogFile(__FUNCTION__, 'success', 'config_provisioning', $this->_provFile);

			$this->_beroConf->set('root', 'provisioning_config_md5', $configMd5New);

			if (($activateLevel = $imp->getConfigActivate()) !== false) {
				switch ($activateLevel) {
				case 1:
				case 2:
				case 3:
					$this->_add2LogFile(__FUNCTION__, 'success', 'activation_level_' . $activateLevel . '_by_provisioning', $this->_provFile);
					Helper::activateApi($activateLevel);
					$fm = new fileManagement();
					$fm->activate(false);
					break;
				default:
					$this->_add2LogFile(__FUNCTION__, 'warning', 'invalid_activation_level_' . $activateLevel, $this->_provFile);
					break;
				}
			}

			return(true);
		}

		public function showConfig () {

			$display =	'provisioning_mode=' . $this->_provMode . "\n" .
					'provisioning_url=' . $this->_provUrl . "\n" .
					'polling_interval=' . $this->_pollingInterval . "\n" .
					'provisioning_config_md5=' . $this->_beroConf->get('root', 'provisioning_config_md5') . "\n";

			echo $display;

			return(true);
		}

		public function restoreBackup () {

			if (!is_dir($this->_confPath . '/backup')) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'directory_does_not_exist', $this->_confPath . '/backup');
				return(false);
			}

			system('/bin/cp ' . $this->_confPath . '/backup/* ' . $this->_confPath);
			$this->_restore->restoreConfig();
			system('/bin/rm -rf ' . $this->_confPath . '/backup');

			return(true);
		}

		public function updateFirmware () {

			if ($this->_provMode == 'off') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'provisioning_disabled_by_gateway');
				return(true);
			}

			if ($this->_getFile($this->_provFile) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $this->_provFile);
				return(false);
			}

			if ($this->_isNewConfigFormat() == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'old_config_style_detected', $this->_provFile);
				return($this->_updateFirmwareOld());
			}

			$imp = new configExportImportTool($this->_tempPath . '/' . $this->_provFile);

			if (($fw = $imp->getFirmwareInstallInfo()) === false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'no_firmware_provisioned');
				return(true);
			}

			if($fw['install'] == 'no') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_provisioning_disabled_by_server');
				return(true);
			}

			// now, allow downgrade too
			if ($this->_firmwareDifferent($fw['package']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_provisioned_same_version', $fw['package']);
				return(false);
			}

			if ($this->_getFile($fw['package']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $fw['package']);
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $fw['package']);

			if (!file_exists('/tmp/images')) {
				mkdir('/tmp/images');
			}
			system('/bin/mv ' . $this->_tempPath . '/' . $fw['package'] . ' /tmp/images/' . $fw['package']);

			$upd = new updateTool();

			if ($upd->install($fw['package'], false) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_update_failed', $fw['package']);
				return(false);
			}

			$this->_add2LogFile(__FUNCTION__, 'success', 'firmware_updated', $fw['package']);
			if ($this->_rootfsDifferent()) {
				exec('/sbin/reboot >/dev/null 2>&1 &');
			}

			return(true);
		}


		public function updateAppConfig () {

			if ($this->_provMode == 'off') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'provisioning_disabled_by_gateway');
				return(true);
			}

			if ($this->_getFile($this->_provFile) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $this->_provFile);
				return(false);
			}

			if ($this->_isNewConfigFormat() == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'old_config_style_detected', $this->_provFile);
				return(false);
			}

			$imp = new configExportImportTool($this->_tempPath . '/' . $this->_provFile);

			// go over appConfigFiles
			if (($appConfigFiles = $imp->getAppConfigFiles()) !== false) {
				foreach ($appConfigFiles as $app) {
					$this->_add2LogFile(__FUNCTION__, 'info', 'found_configuration_for_app', $app['name']);

					@mkdir('/usr/conf/userapp/' . $app['name']);

					if (empty($app['files'])) {
						continue;
					}

					foreach ($app['files'] as $appFile) {
						switch ($appFile['mode']) {
						case 'directory':	system('/bin/mkdir -p /usr/conf/userapp/' . $appFile['name']);	break;
						case 'binary':		$fileData = base64_decode($appFile['content']);			break;
						default:		$fileData = $appFile['content'];				break;
						}

						if ($appFile['mode'] != 'directory') {
							@unlink('/usr/conf/userapp/' . $appFile['name']);
							$FP = fopen('/usr/conf/userapp/' . $appFile['name'], 'w');
							fwrite($FP, $fileData, strlen($fileData));
							fclose($FP);
							$FP = null;
							unset($fileData);
						}

						system('/bin/chown admin:admin /usr/conf/userapp/' . $appFile['name']);
						$this->_add2LogFile(__FUNCTION__, 'info', 'installed_file', $appFile['name']);
					}
				}
			}

			return(true);
		}

		public function updateApps () {

			if ($this->_provMode == 'off') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'provisioning_disabled_by_gateway');
				return(true);
			}

			if ($this->_getFile($this->_provFile) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $this->_provFile);
				return(false);
			}

			if ($this->_isNewConfigFormat() == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'old_config_style_detected', $this->_provFile);
				return(false);
			}

			$imp = new configExportImportTool($this->_tempPath . '/' . $this->_provFile);

			if (($apps = $imp->getAppInstallInfo()) == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'no_app_provisioned');
				return(true);
			}

			foreach ($apps as $app) {
				if ($app['install'] != 'yes') {
					$this->_add2LogFile(__FUNCTION__, 'info', 'app_install_disabled', $app['package']);
					continue;
				}

				if ($this->_getFile($app['package']) == false) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $app['package']);
					return(false);
				}
				$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $app['package']);

				if (!is_dir('/tmp/images')) {
					exec('/bin/mkdir -p /tmp/images');
				}

				exec('/bin/mv ' . $this->_tempPath . '/' . $app['package'] . ' /tmp/images/' . $app['package'], $out, $ret);
				if ($ret != 0) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_copy', $app['package']);
					continue;
				}
				unset($ret);
				unset($out);

				$last_line = exec('/usr/sbin/userapp_pkg_install.sh ' . $app['package'] . ' 1', $out, $ret);
				if ($ret != 0) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_install', $app['package']);
					$this->_add2LogFile(__FUNCTION__, 'error', 'last_output', $last_line);
					continue;
				}
				unset($ret);
				unset($out);
				unset($last_line);

				$this->_add2LogFile(__FUNCTION__, 'info', 'installed', $app['package']);
			}

			return(true);
		}
	}
} /* _PROVISIONINGTOOL_CLASS */

?>
