<?php
# VERSION=3
# CHANGES="All HTTP-Codes between 200 and 299 are okay."

if (!defined('_UPDATETOOL_CLASS')) {
	define('_UPDATETOOL_CLASS', true);

	include_once("/usr/www/include/SQLite2ToSQLite3.php");
	include('/usr/fallback/beroConf.php');

	class updateTool {

		private $_bc;
		private $_image_dir;
		private	$_url_path	= 'ftp://appliance.beronet.com/beronet_gateway/';

		public function __construct ($image_dir = '/tmp/images') {

			$this->_bc = new beroConf('root');
			$this->_image_dir = $image_dir;

			# creating the image-directory on construction
			if (!is_dir($this->_image_dir)) {
				exec('/bin/rm -rf ' . $this->_image_dir);
			}

			if (!file_exists($this->_image_dir)) {
				exec('/bin/mkdir -p ' . $this->_image_dir);
			}
		}

		public function reboot () {
			$this->_bc->set('root', 'boot_fwupdate', '1');
		}

		public function getdownloadlist ($filename = 'firmware_3LI.list') {
			$url = $this->_url_path.$filename; 
			if (!($lines = @file($url))) {
				return(false);
			}
			foreach ($lines as $line) {
				if (($line == "\n") || ($line[0] == '#')) {
					continue;
				}
				$tmp = explode(';', trim($line, "\n\t"));
				$ret[] = array('name' => $tmp[0], 'type' => $tmp[1], 'url' => $tmp[2], 'size' => $tmp[3], 'notesurl' => $tmp[4]);
			}
			return($ret);
		}

		public function download ($url) {

			$ret = array('error' => false, 'error_code' => 0, 'message' => false, 'filename' => false);

			if (strlen($url) < 16) {
				$ret['error'] = true;
				$ret['message'] = 'URL \'' . $url . '\' to short!';
				return($ret);
			}

			if ((substr($url, 0, 7) != 'http://') && (substr($url, 0, 8) != 'https://') && (substr($url, 0, 6) != 'ftp://')) {
				$ret['error'] = true;
				$ret['error_code'] = 1;
				$ret['message'] = 'Invalid formatted URL.';
				return($ret);
			}

			if ((substr_compare($url, '.fw', -3, 3) != 0) && (substr_compare($url, '.tar.gz', -7, 7) != 0)) {
				$ret['error'] = true;
				$ret['error_code'] = 2;
				$ret['message'] = 'File-Type is wrong.';
				return($ret);
			}

			# download file and save it to /tmp/images/
			set_time_limit(0);

			$pkgfile = $this->_image_dir . '/' . basename($url);
			if (($fp = fopen($pkgfile, 'w')) == null) {
				curl_close($ch);
				$ret['error'] = true;
				$ret['error_code'] = 3;
				$ret['message'] = 'Could not open file \'' . $pkgfile . '\' for writing.';
				return($ret);
			}

			if (($ch = curl_init(str_replace(' ', '%20', $url))) == null) {
				$ret['error'] = true;
				$ret['error_code'] = 4;
				$ret['message'] = 'Could not initiate cURL to download file.';
				return($ret);
			}

			curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_exec($ch);
			$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);
			fclose($fp);

			if (!($retcode >= 200) && !($retcode < 300)) {
				unlink($pkgfile);
				$ret['error'] = true;
				$ret['error_code'] = 5;
				$ret['message'] = 'File could not be downloaded (Remote Server responded with Error ' . $retcode . ').';
				return($ret);
			}

			$ret['filename'] = basename($pkgfile);

			return($ret);
		}

		public function upload ($parm) {

			$ret = array('error' => false, 'error_code' => 0, 'message' => false, 'filename' => false);

			if (empty($parm)) {
				$ret['error'] = true;
				$ret['message'] = 'Missing Firmware. No file uploaded';
				return($ret);
			}

			if (($dh = opendir($this->_image_dir)) == NULL) {
				$ret['error'] = true;
				$ret['message'] = 'Could not open directory \'' . $this->_image_dir . '\' for reading.';
				return($ret);
			}

			while (($file = readdir($dh)) != false) {
				if (($file == '.') || ($file == '..')) {
					continue;
				}

				if (($file == 'content.txt') || ((substr_compare($file, '.tar.gz', -7, 7) != 0) && (substr_compare($file, '.fw', -3, 3) != 0))) {
					$filePath = $this->_image_dir . '/' . $file;
					if ((strlen($file) != 0) && file_exists($filePath)) {
						unlink($filePath);
					}
					unset($filePath);
				}
			}
			closedir($dh);

			if ((substr_compare($parm['userfile']['name'], '.fw', -3, 3) != 0) && (substr_compare($parm['userfile']['name'], '.tar.gz', -7, 7) != 0)) {
				$ret['error'] = true;
				$ret['error_code'] = 1;
				$ret['message'] = 'File-Type is wrong.';
				return($ret);
			}

			if ((filesize($parm['userfile']['tmp_name']) / 1024) / 1024 > 15) {
				$ret['error'] = true;
				$ret['error_code'] = 2;
				$ret['message'] = 'File-Size ist too high.';
				return($ret);
			}

			$upload_file = $this->_image_dir . '/' . basename($parm['userfile']['name']);
			if (!move_uploaded_file($parm['userfile']['tmp_name'], $upload_file)) {
				$ret['error'] = true;
				$ret['error_code'] = 3;
				$ret['message'] = 'Could not move temporary File to \'' . $upload_file . '\'.';
				return($ret);
			}

			$ret['filename'] = basename($parm['userfile']['name']);

			return($ret);
		}

		public function install ($pkgname, $system=true) {

			# check if all is right with file
			if ((strlen($pkgname) == 0) || !file_exists($this->_image_dir . '/' . $pkgname)) {
				return(false);
			}

			# check if another install-process is running
			system('/bin/ps | /bin/grep -v grep | /bin/grep install.sh > /dev/null', $retval);
			if ($retval == 0) {
				return(false);
			}
			unset($retval);

			# install update-package
			$cmd = '/usr/fallback/install.sh ' . addcslashes($pkgname, '()');
			($system == true) ? system($cmd, $retval) : exec($cmd, $retval);

			return($retval);
		}

		public function pkgdelete ($pkgname) {
			$file = $this->_image_dir . '/' . $pkgname;
			return((strlen($pkgname) != 0) && file_exists($file) && unlink($file));
		}

                public function getImageDir(){
                    return $this->_image_dir;
                }
	}
}
