#!/usr/bin/php -q
<?php

/*
 * Einbindung der nötigen externen Klassen
 */
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/fallback/beroConf.php');

/*
 * Datenbank Klassen instanziieren
 */
$bc = new beroConf('root');
$ba = new beroAri('/usr/conf/ari.db');


/*
 * Seriennummer der Karte herausfinden
 */
$pstn_to_sip_arr = array();
$sip_to_pstn_arr = array();

$sleep_interval = $bc->get('root', 'cloud_interval');
if (!$sleep_interval) {
	$sleep_interval=60;
}
$cloud_enable = $bc->get('root', 'cloud_enable');
if ($cloud_enable != 1) {
	exit(1);
}

try {
	if ($ba->get("cloudFileName") != "") {
		getFW();
	}
}
catch(Exception $e) {
	file_put_contents('/var/log/api-error.log' , $e->getMessage(). ' ' .$e->getFile(). ' ' .$e->getLine() . "\n" , FILE_APPEND);
}


/**
  * Geplante Aufgaben aus dem Server lesen
  *
  * Diese Funktion ist eine rekursive Funktion, und wird so oft
  * ausgeführt, wie es geplante fällige Aufgaben auf dem Server gibt.
  *
  * @return void
  */
function getFW() {
	global $ba, $bc;
	require_once('/usr/local/php/include/berocloud/SbcApi.php');
	$cloud = new SbcApi($bc, $ba);
	updateFW($cloud->send('firmwareDownload'));
}

/**
  * Firmware der Karte aktualisieren
  *
  * Die Alte Firmwares dir sich auf der Karte befinden werden gelöscht
  * und die neue Firmware wird installiert, die die aus der beroCloud
  * heruntergeladen wurde.
  *
  * @param  $fileName Name der neuen Firmware
  * @return void
  */
function updateFW($fileName){
	global $ba,$bc;
	require_once('/usr/php/include/updateTool.php');
	$parm = array();
	$parm['userfile']['tmp_name'] ="/tmp/$fileName";
	$parm['userfile']['name'] = $fileName;
	$updateTool = new updateTool();
	$result = $updateTool->upload($parm);
	/*
	 * Da die updateTool Klasse für Dateien, die durch ein Formular hochgeladen wurden konzipiert
	 * wurde, wirft die Klasse einen Fehler, deswegen wird die Datei hier verschoben.
	 */
	if ($result['error_code'] == 3 ) {
		rename("/tmp/$fileName", $updateTool->getImageDir()."/$fileName");
		$updateTool->install($fileName);
		$file_name = $ba->set("cloudFileName","");
	}
}
?>
