<?php
class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		$fileName = '/usr/conf/apiusers.conf';
		$apiUsers = file_get_contents($fileName);

		if (strstr($apiUsers, '# provisioning:')) {		// user is disabled
			if ($this->_parameters['Set'] == 'enabled') {
				$this->_execResult = (file_put_contents($fileName, str_replace('# provisioning', 'provisioning', $apiUsers)) === false) ? false : true;
				$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;
			}

			return($this->_execResult);
		} else if (strstr($apiUsers, 'provisioning:')) {	// user is enabled
			if ($this->_parameters['Set'] == 'disabled') {
				$this->_execResult = (file_put_contents($fileName, str_replace('provisioning', '# provisioning', $apiUsers)) === false) ? false : true;
				$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;
			}

			return($this->_execResult);
		}

		// user does not exist
		$apiUsers .= "\n" . (($this->_parameters['Set'] == 'enabled') ? '' : '# ') . 'provisioning:YWG41BPzVAkN6';
		$this->_execResult = (file_put_contents('/usr/conf/apiusers.conf', $apiUsers) === false) ? false : true;
		$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? 'success' : 'error'));
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
