<?php
class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		$apiUsers = file_get_contents('/usr/conf/apiusers.conf');

		if (strstr($apiUsers, '# provisioning:')) {		// disabled
			$this->_execResultString .= ':disabled;';
			$this->_execResponseCode = 403;
		} else if (strstr($apiUsers, 'provisioning:')) {	// enabled
			$this->_execResultString .= ':enabled;';
			$this->_execResponseCode = 200;
		} else {						// not configured
			$this->_execResultString .= ':not_configured;';
			$this->_execResponseCode = 404;
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
