<?php

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		$apiUsers = file_get_contents('/usr/conf/apiusers.conf');

		// check if user proviosioning exists
		if (!strstr($apiUsers, 'provisioning:')) {
			$this->_execResultString = 'error:user_does_not_exist;';
			$this->_execResult = false;
			$this->_execResponseCode = 404;
			return($this->_execResult);
		}

		// check if user proviosioning is enabled
		if (strstr($apiUsers, '# provisioning:')) {
			$this->_execResultString = 'error:user_is_disabled;';
			$this->_execResult = false;
			$this->_execResponseCode = 403;
			return($this->_execResult);
		}

		// check if password is valid
		if (!isset($this->_parameters['NewPassword']) || empty($this->_parameters['NewPassword'])) {
			$this->_execResultString = 'error:invalid_or_no_password_supplied;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		// preserve line of user admin
		preg_match('/(admin:[0-9a-zA-Z]*)/', $apiUsers, $matches);
		$adminLine = $matches[1];
		unset($matches);

		// create new password for user provisioning
		$newPasswordEnc = crypt($this->_parameters['NewPassword'], base64_encode($this->_parameters['NewPassword']));

		// write new apiusers.conf
		$apiUsersNew = $adminLine . "\n" . 'provisioning:' . $newPasswordEnc . "\n";
		file_put_contents('/usr/conf/apiusers.conf', $apiUsersNew);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? 'success' : $this->_execResultString));
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
