<?php

require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!isset($this->_parameters['Port']) || !isset($this->_parameters['ServedUserNumber'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$cfquery_cmd = "cfquery:" . $this->_parameters['Port'] . ":" . $this->_parameters['ServedUserNumber'];
		
		$isgw = new isgwtelnet();
		if (!($result = $isgw->isgw_login())) {
		    $this->_execResultString = 'error:login_failed;';
		    $this->_execResult = false;
		    $this->_execResponseCode = 500;
		    return($this->_execResult);
		}
		
		$this->_execResultString .= "\n" . trim($isgw->Query($cfquery_cmd));
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
