<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		$isgw = new isgwtelnet();

		if (!($result = $isgw->isgw_login())) {
			$this->_execResult = false;
		}

		if (!($result = $isgw->isgw_dialplanreload())) {
			$this->_execResult = false;
		}

		if (!($result = $isgw->isgw_sipreload())) {
			$this->_execResult = false;
		}

		if (!($result = $isgw->isgw_rcpt())) {
			$this->_execResult = false;
		}

		if (!($result = $isgw->isgw_rgc())) {
			$this->_execResult = false;
		}

		exec('/usr/local/init/S60cloud stop');
		exec('/usr/local/init/S60cloud start');
		exec('/usr/local/init/S80snmpd restart');
		exec('/usr/local/init/S55SMGW restart');
		exec('/etc/init.d/S91userapp restart');

		if ($this->_execResult == false) {
			$this->_execResultString = 'error';
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$ba = new beroAri();
		if ($ba->get("activate")<=1) $ba->set('activate','0');

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
