<?php
class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!file_exists('/usr/local/FILENAME')) {
			$this->_execResult = false;
			$this->_execResponseCode = 404;
			return($this->_execResult);
		}

		$contents = file_get_contents('/usr/local/FILENAME');

		preg_match('/appfs-(.*).tar.gz/', $contents, $matches);

                if (isset($matches[1]) && strlen($matches[1]) > 0) {
                        $this->_execResultString .= ':' . $matches[1] . ';';
                } else {
                        $this->_execResult = false;
                }

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? $this->_execResultString : 'error'));
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
