<?php

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!file_exists('/pkginfo/VERSION.rootfs')) {
			$this->_execResult = false;
			$this->_execResponseCode = 404;
			return($this->_execResult);
		}


		$contents = file_get_contents('/pkginfo/VERSION.rootfs');

		preg_match('/PKG_VERSION=([0-9]*)/', $contents, $matches);
		$this->_execResultString .= ':' . $matches[1] . ';';

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? $this->_execResultString : 'error'));
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
