<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/php/include/fulltrace.Class.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!isset($this->_parameters['performAction']) || empty($this->_parameters['performAction'])) {
			$this->_execResultString = 'error:missing_parameter_performAction;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$db = new beroAri();
		$ft = new fulltrace();

		switch ($this->_parameters['performAction']) {
		case 'start':
			if ($db->get('trace') == 'yes') {
				$this->_execResultString = 'error:trace_alread_in_progress;';
				$this->_execResult = false;
				$this->_execResponseCode = 405;
				return($this->_execResult);
			}

			$enable = array('isdn' => 1, 'analog' => 1, 'gsm' => 1);
			$enable['sip_sign'] =	(($this->_parameters['sipsig'] == 'yes')	? 1 : 0);
			$enable['sip_audio'] =	(($this->_parameters['sipaudio'] == 'yes')	? 1 : 0);
			$enable['rtp_udptl'] =	(($this->_parameters['rtp_udptl'] == 'yes')	? 1 : 0);
			$enable['any'] =	(($this->_parameters['any'] == 'yes')		? 1 : 0);
			$enable['lan'] =	(($this->_parameters['lan'] == 'yes')		? 1 : 0);
			$enable['lo'] =		(($this->_parameters['lo'] == 'yes')		? 1 : 0);
			$enable['syslog'] =	(($this->_parameters['syslog'] == 'yes')	? 1 : 0);

			$res = $db->select('SELECT port FROM isdn;');
			while ($entry = $db->fetch_array($res)) {
				$isdn_ports[] = $entry['port'];
			}
			unset($res);

			$ft->start($enable, $isdn_ports, null);
			break;
		case 'stop':
			$ft->stop(false);
			break;
		case 'download':
			$this->_execResponseCode = false;
			if (!file_exists('/var/log/DebugFiles.tar.gz')) {
				$this->_execResultString = 'error:no_fulltrace_found;';
				$this->_execResponseCode = 404;
				$this->_execResult = false;
			}
			break;
		default:
			$this->_execResultString = 'error:invalid_parameter_performAction;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			break;
		}

		return($this->_execResult);
	}

	function display () {
		if (($this->_parameters['performAction'] == 'download') && ($this->_execResult != false)) {
			$debugArchive = file_get_contents('/var/log/DebugFiles.tar.gz');
			header('Content-Type: application/force-download');
			header('Content-Disposition: attachment; filename=DebugFiles.tar.gz' . "\r\n\r\n");
			header('Content-Length: ' . strlen($debugArchive) . "\n\n");

			return($debugArchive);
		}

		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
