<?php

require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!isset($this->_parameters['Enable']) || !isset($this->_parameters['LogLevel'])  || !isset($this->_parameters['LogServer'])  || !isset($this->_parameters['LogPort'])) {
			$this->_execResultString = 'error';
			$this->_execResult = false;
			$this->_execResponseCode = 400;
			return($this->_execResult);
		}

		$isgw = new isgwtelnet();

		$isgw->isgw_login();
		usleep(500);

		$isgw->logserver($this->_parameters['LogServer'], $this->_parameters['LogPort']);
		usleep(500);

		$isgw->loglevel_message($this->_parameters['LogLevel']);
		usleep(500);

		$isgw->logactive_message($this->_parameters['Enable']);
		usleep(500);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
