<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!isset($this->_parameters['Mode']) || !in_array($this->_parameters['Mode'], array('enabled', 'disabled', 'detection-only'))) {
			$this->_execResultString = 'error:invalid_parameters';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$bc = new beroConf('root');

		switch ($this->_parameters['Mode']) {
		case 'enabled':
			$bc->set('root', 'ncs_mode', 'on');
			@exec('/etc/init.d/S41ncs restart');
			break;
		case 'detection-only':
			$bc->set('root', 'ncs_mode', 'detectonly');
			@exec('/etc/init.d/S41ncs restart');
			break;
		case 'disabled':
			$bc->set('root', 'ncs_mode', 'off');
			@exec('/etc/init.d/S41ncs restart');
			break;
		}


		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
