<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (($this->_parameters['Dhcp'] == 'off') && (!isset($this->_parameters['IpAddress']) || !isset($this->_parameters['NetMask']) || !isset($this->_parameters['GateWay']))) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$bc = new beroConf('root');

		foreach (array('lan-dhcp', 'lan-ipaddr', 'lan-netmask', 'lan-gateway', 'lan-mtu', 'lan-nameserver', 'gateway-mode', 'gateway-manual', 'nameserver-mode') as $lanSetting) {
			$bc->delete('root', $lanSetting);
		}

		// dhcp will be set to on
		if ($this->_parameters['Dhcp'] == 'on') {
			$bc->set('root', 'lan-dhcp', '1');
			$bc->set('root', 'gateway-mode', 'eth0.10');
			$bc->set('root', 'nameserver-mode', 'eth0.10');
			return($this->_execResult);
		}

		// configure network manually
		$bc->set('root', 'lan-dhcp', '0');
		$bc->set('root', 'lan-ipaddr', sqlite_escape_string($this->_parameters['IpAddress']));
		$bc->set('root', 'lan-netmask', sqlite_escape_string($this->_parameters['NetMask']));
		$bc->set('root', 'lan-gateway', sqlite_escape_string($this->_parameters['GateWay']));
		$bc->set('root', 'gateway-mode', 'manual');
		$bc->set('root', 'nameserver-mode', 'manual');

		// configure optional parameter NameServer
		if (isset($this->_parameters['NameServer'])) {
			$bc->set('root', 'lan-nameserver', sqlite_escape_string($this->_parameters['NameServer']));
		}

		// configure optional parameter MtuSize
		if (isset($this->_parameters['MtuSize'])) {
			$bc->set('root', 'lan-mtu', sqlite_escape_string($this->_parameters['MtuSize']));
		}

		return($this->_execResult);
	}

	function display () {

		// reboot to apply changes
		if ($this->_execResult == true) {
			exec('/sbin/reboot');
		}

		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
