<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!isset($this->_parameters['Mode']) || !isset($this->_parameters['Url'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		if (!in_array($this->_parameters['Mode'], array('off', 'once', 'always'))) {
			$this->_execResultString = 'error:parameter_mode_invalid;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$bc = new beroConf('root');
		$bc->set('root', 'provisioning_manual', '1');
		$bc->set('root', 'provisioning_mode', sqlite_escape_string($this->_parameters['Mode']));
		$bc->set('root', 'provisioning_url', sqlite_escape_string($this->_parameters['Url']));
		if (isset($_GET['PollingInterval']) && ($_GET['PollingInterval'] != 0)) {
			$bc->set('root', 'polling_interval', sqlite_escape_string($this->_parameters['PollingInterval']));
		} else {
			$bc->delete('root', 'polling_interval');
		}


		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
