<?php

require_once('/usr/local/php/include/shortMessageService.Class.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode, $_sms;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
		$this->_sms = new ShortMessageService();
	}

	function execute () {
		$format = "tab";
		$reset = 0;
		
		if (isset($this->_parameters['Format'])) {
			if (strcasecmp ($this->_parameters['Format'], "tab") == 0) {
				$format="tab";
			}
		}
		
		if (isset($this->_parameters['Reset'])) {
			$reset = 1;
		}
		
		if (($deliveryReport = $this->_sms->getDeliveryReport($format, $reset)) === false) {
			$this->_execResultString = 'error:no_delivery_report_found;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$this->_execResultString .= "\n\n" . $deliveryReport;

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
