<?php

require_once('/usr/local/php/include/shortMessageService.Class.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode, $_sms;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
		$this->_sms = new ShortMessageService();
	}

	function execute () {
		if (!isset($this->_parameters['SmsQueue']) || !isset($this->_parameters['SmsIdentifier'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		if (($sms = $this->_sms->getMessage($this->_parameters['SmsQueue'], $this->_parameters['SmsIdentifier'])) == null) {
			$this->_execResultString = 'error:invalid_queue;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		switch($this->_parameters['SmsQueue']) {
		case 'in':
			$this->_execResultString .= "\n" . $sms['message'];
			break;
		case 'out':
		case 'failout':
			$this->_execResultString .= "\n" . $sms['message'];
			$this->_execResultString .= "\n" . $sms['log'];
			break;
		}

		if (isset($this->_parameters['Delete'])) {
			$this->_sms->deleteMessage($this->_parameters['SmsQueue'], $this->_parameters['SmsIdentifier']);
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
