<?php

require_once('/usr/local/php/include/shortMessageService.Class.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode, $_sms;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
		$this->_sms = new ShortMessageService();
	}

	function execute () {

		if (!isset($this->_parameters['GsmPort']) || !isset($this->_parameters['PhoneNumber']) || !isset($this->_parameters['Message'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		// the old way: sms is written into folder and identifier is returned
		if (!isset($this->_parameters['ConfirmationWait'])) {
			if (($smsId = $this->_sms->sendMessage($this->_parameters['PhoneNumber'], $this->_parameters['Message'], $this->_parameters['GsmPort'])) == false) {
				$this->_execResultString = 'error:' . str_replace(' ', '_', strtolower($this->_sms->getErrorText()));
				$this->_execResult = false;
				$this->_execResponseCode = 500;
				return($this->_execResult);
			}


			$this->_execResultString .= ':identifier:' . $smsId . ';';
			return($this->_execResult);
		}

		// the new way: waiting for an ok/error from isgw
		if (($smsAnswer = $this->_sms->sendMessage($this->_parameters['PhoneNumber'], $this->_parameters['Message'], $this->_parameters['GsmPort'], $this->_parameters['ConfirmationWait'])) == false) {
			$this->_execResultString = 'error:' . str_replace(' ', '_', strtolower($this->_sms->getErrorText()));
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$this->_execResultString .= ':identifier:' . $smsAnswer['smsId'] . ';status:' . $smsAnswer['status'] .
						(($smsAnswer['status'] == 'ERROR') ? (';message:' . $smsAnswer['message']) : '') . ';';
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}

?>
