<?php

require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		if (!in_array($this->_parameters['CloudEnable'], array('0', '1'))) {
			$this->_execResultString = 'error';
			$this->_execResult = false;
			$this->_execResponseCode = 400;
			return($this->_execResult);
		}

		$bc = new beroConf('root');
		$bc->set('root', 'cloud_enable', sqlite_escape_string($this->_parameters['CloudEnable']));

		if (isset($this->_parameters['CloudKey'])) {
			$bc->set('root', 'cloud_key', sqlite_escape_string($this->_parameters['CloudKey']));
		}

		if (isset($this->_parameters['CloudServer'])) {
			$ba = new beroAri();
			$ba->set('cloudAddress', sqlite_escape_string(trim($this->_parameters['CloudServer'])));
		}

		Helper::activate(1);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
