<?php

require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {
		// open databases
		$bc = new beroConf('root');
		$ba = new beroAri();

		// compile data
		require_once('/usr/local/php/include/berocloud/SbcApi.php');
		$cloud = new SbcApi($bc, $ba);
		$res = $cloud->send('deregister');

		// evaluate result
		if (trim($res) != 'Device was deregistered') {
			$this->_execResultString = 'error:' . trim($res) . ';';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$bc->set('root', 'cloud_enable', 0);
		$bc->delete('root', 'cloud_key');
		Helper::activate(1);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
