<?php

require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class apiCall {

	private $_name, $_parameters, $_files, $_execResult, $_execResultString, $_execResponseCode;

	function __construct ($get = null, $post = null, $files = null) {
		$this->_name = basename(dirname(__FILE__));
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
		$this->_execResult = true;
		$this->_execResponseCode = 200;
		$this->_execResultString = 'success';
	}

	function execute () {

		$bc = new beroConf('root');

		if ($bc->get('root', 'cloud_enable') != 1) {
			$this->_execResultString .= ':disabled;';
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$ba = new beroAri();

		if (strlen(($baError = $ba->get('error'))) != 0) {
			$this->_execResultString = 'error:' . trim($baError) . ';';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$this->_execResultString .= ':connected;';

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

	function responsecode () {
		return($this->_execResponseCode);
	}
}
?>
