<?php

class apiusers {

    private $_password;

    function __construct($password) {
	$this->_password = $password;
    }

    // create apiusers.conf
    public function createFile() {
	// read apiusers.conf
	$apiUsers = @file_get_contents('/usr/conf/apiusers.conf');

	// preserve line of user provisioning
	preg_match('/(.*provisioning:[0-9a-zA-Z]*)/', $apiUsers, $matches);
	$provisioningLine = $matches[0];
	unset($matches);

	// create new password for user provisioning
	$newPasswordEnc = crypt($this->_password, base64_encode($this->_password));

	// write new apiusers.conf
	$apiUsersNew = 'admin:' . $newPasswordEnc . "\n" . $provisioningLine . "\n";
	file_put_contents('/usr/conf/apiusers.conf', $apiUsersNew);
	return true;
    }

}

// END APIUSERS CLASS
?>
