<?php
	/*
	 * beroCloudAPI Class to exchange with beroCloud
	 * Must be extended by SbcApi or CloudSbcApi
	 */
include_once('/usr/local/www/berogui/includes/Helper/Helper.php');
class beroCloudAPI {

	public	$has_error		= false,
					$is_init			= false,
					$socket				= null,
					$socket_error	= null;

	public	$key				= '',
					$proxy_data	= '',
					$url				= '',
					$version 		= '';

	public	$log_file	= '',
					$serial		= '';

	/* [CONSTRUCTOR] */
	function __construct() {
		$this->version = '3.0';
	}

	/* [PUBLIC METHODS] */
	public function hasError() {
		return($this->has_error);
	}

	public function getError() {
		return($this->socket_error);
	}

	public function getSerial() {
		return($this->serial);
	}

	public function log($error) {
		file_put_contents($this->log_file, Helper::getDate() ." $error". PHP_EOL, FILE_APPEND);
		$file = file($this->log_file);
		if (count($file) > 25000) {
			array_pop($file);
			file_put_contents($this->log_file, $file);
		}
	}

	public function sendRequest($method, $uri, $data = null, $options = array(), &$info = array()) {
		if ($this->has_error) {
			return false;
		}
		$default_options = array(
			'asJSON'					=> 0,
			'connecttimeout'	=> 100,
			'debug'						=> 0,
			'handle'					=> null,
			'returntransfer'	=> 1,
			'ssl-cipher-list'	=> 'TLSv1.2',
			'ssl-verifypeer'	=> 0,
			'to-berocloud'		=> true,
			'timeout'					=> 100,
		);
		$options = array_merge($default_options, $options);
		try {
			if (!$this->is_init) {
				throw new Exception('URL information missing');
			}

			$ch = curl_init();
			if ($ch === false) {
				throw new Exception('Failed to initialize cURL');
			}

			curl_setopt($ch, CURLOPT_URL, $options['to-berocloud'] ? "{$this->url}?r=$uri" : "{$this->url}$uri");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, (int) $options['returntransfer']);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, (int) $options['ssl-verifypeer']);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, (int) $options['connecttimeout']);
			curl_setopt($ch, CURLOPT_TIMEOUT, (int) $options['timeout']);

			if (strlen($options['ssl-cipher-list']) > 0) {
				curl_setopt($ch, CURLOPT_SSL_CIPHER_LIST, $options['ssl-cipher-list']);
			}

			if (!is_null($options['handle'])) {
				curl_setopt($ch, CURLOPT_FILE, $options['handle']);
			}

			if ($options['to-berocloud']) {
				$data = array_merge(array('key' => $this->key, 'serial' => $this->serial), $data);
			}

			switch ($method) {
			case 'delete':
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
				break;
			case 'get':
				break;
			case 'post':
				curl_setopt($ch, CURLOPT_POST, 1);
				break;
			case 'put':
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
				break;
			default:
				throw new Exception("Unknown method=$method. Only 'delete', 'get', 'post' and 'put' accepted");
			}

			if ((strlen($this->proxy_data['address']) != 0) && (strlen($this->proxy_data['port']) != 0) && (strlen($this->proxy_data['type']) != 0)) {
				curl_setopt($ch, CURLOPT_PROXY, $this->proxy_data['address']);
				curl_setopt($ch, CURLOPT_PROXYPORT, $this->proxy_data['port']);
				curl_setopt($ch, CURLOPT_PROXYTYPE, $this->proxy_data['type']);
				if (strlen($this->proxy_data['user']) != 0 && strlen($this->proxy_data['secret']) != 0) {
					curl_setopt($ch, CURLOPT_PROXYUSERPWD, "{$this->proxy_data['user']}:{$this->proxy_data['secret']}");
				}
			}

			if (!empty($data)) {
				if ($options['asJSON']) {
					curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
					curl_setopt($ch, CURLOPT_POSTFIELDS, Helper::jsonEncode($data));
				}
				else {
					curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				}
			}

			$response = curl_exec($ch);
			$info = curl_getinfo($ch);

			if ($options['debug']) {
				$this->log("###### DEBUG #####\nmethod=$method|uri=$uri|". print_r($data, true).print_r($options, true).print_r($info, true) ."\n###########");
			}

			if ($response === false) {
				$this->log('cURL error: [errno='. curl_errno($ch) .'|error='. curl_error($ch) .']');
				throw new Exception(curl_error($ch), curl_errno($ch));
			}
			else if (!in_array($info['http_code'], array('200', '201'))) {
				$this->log("HTTP error: [code={$info['http_code']}]");
				throw new Exception('HTTP error', $info['http_code']);
			}
			curl_close($ch);

			if ($response == false) {
				return true;
			}
			return($options['asJSON'] ? Helper::jsonDecode($response, true) : $response);
		}
		catch (Exception $e) {
			$this->has_error = true;
			$this->socket_error = $this->_setError($e);
			return false;
		}
	}

	/* [PRIVATE METHODS] */
	private function _setError($exception) {
		return array(
			'code'	=> $exception->getCode(),
			'file'	=> $exception->getFile(),
			'line'	=> $exception->getLine(),
			'msg'		=> $exception->getMessage(),
		);
	}
}
?>
