<?php
if (!defined('_CONFBACKUP_CLASS')) {
	define('_CONFBACKUP_CLASS', true);

	include_once('/usr/local/php/include/restore.Class.php');
	require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

	Class confBackup {

		private $_cardSerial;
		private $_ba;
		private $_restore;
		private $_confPath = '/usr/conf';
		private $_extractPath = '/tmp/restore';
		private $_confFiles = array(	array('name' => 'isgw.conf',		'restore' => 'isgwconf'),
						array('name' => 'isgw.sip',		'restore' => 'isgwsip'),
						array('name' => 'isgw.isdn',		'restore' => 'isgwisdn'),
						array('name' => 'isgw.analog',		'restore' => 'isgwanalog'),
						array('name' => 'isgw.cas',		'restore' => 'isgwcas'),
						array('name' => 'isgw.gsm',		'restore' => 'isgwgsm'),
						array('name' => 'isgw.lte',		'restore' => 'isgwlte'),
						array('name' => 'isgw.causes',		'restore' => 'isgwcauses'),
						array('name' => 'isgw.tones',		'restore' => null),
						array('name' => 'isgw.cpt',		'restore' => 'isgwcpt'),
						array('name' => 'isgw.dialplan',	'restore' => 'isgwdialplan'),
						array('name' => 'isgw.whitelist',	'restore' => 'isgwwhitelist'),
						array('name' => 'misc.conf',		'restore' => 'miscconf'),
						array('name' => 'hardware.conf',	'restore' => 'hardwareconf'),
						array('name' => 'network.acl',		'restore' => 'networkacl')
					);

		function __construct () {
			$this->_cardSerial = Helper::getSerial();
			$this->_ba = new beroAri($this->_confPath . '/ari.db');

			if (!is_dir($this->_extractPath)) {
				mkdir($this->_extractPath);
			}
			$this->_restore=new restoreConfig(1);
		}

		private function _installUserAppConf () {

			if (!is_dir($this->_confPath . '/userapp')) {
				mkdir($this->_confPath . '/userapp');
				@exec('/bin/chown admin:admin ' . $this->_confPath . '/userapp/');
			}

			if (!is_dir($this->_extractPath . '/userapp/')) {
				return;
			}

			if (($userAppConfDir = scandir($this->_extractPath . '/userapp/')) != null) {
				foreach ($userAppConfDir as $userAppConfSub) {
					if (($userAppConfSub == '.') || ($userAppConfSub == '..')) {
						continue;
					}

					@exec('/bin/rm -rf ' . $this->_confPath . '/userapp/' . $userAppConfSub);
					@exec('/bin/cp -a ' . $this->_extractPath . '/userapp/' . $userAppConfSub . ' ' . $this->_confPath . '/userapp/' . $userAppConfSub);
					@exec('/bin/chown -R admin:admin ' . $this->_confPath . '/userapp/' . $userAppConfSub);
				}
			}
		}

		function createFullBackup () {

			$archiveName = 'beroNetGW-' . $this->_cardSerial . '-backup.tar.gz';

			foreach ($this->_confFiles as $confFile) {
				if (file_exists($this->_confPath . '/' . $confFile['name'])) {
					$confFiles .= ' ' . $confFile['name'];
				}
			}

			$confFiles .= ' userapp';

			if (file_exists('/tmp/' . $archiveName)) {
				unlink('/tmp/' . $archiveName);
			}

			exec('/bin/tar -czf /tmp/' . $archiveName . ' -C ' . $this->_confPath . ' ' . $confFiles);
			$archiveFile = implode('', file('/tmp/' . $archiveName));

			return(array('name' => $archiveName, 'file' => $archiveFile));
		}

		private function _installConfFile ($confFile, $runIniToDB = true) {

			if (!is_dir($this->_confPath . '/backup')) {
				 mkdir($this->_confPath . '/backup');
			}

			@copy($this->_confPath . '/' . $confFile['name'], $this->_confPath . '/backup/' . $confFile['name']);
			@unlink($this->_confPath . '/' . $confFile['name']);

			if (is_file($this->_extractPath . '/' . $confFile['name'])) {
				copy($this->_extractPath . '/' . $confFile['name'], $this->_confPath . '/' . $confFile['name']);
			}

			if ($runIniToDB == true) {
				if ($confFile['restore'] == null) {
					return(true);
				}

				if (!$this->_restore->$confFile['restore']()) {
					copy($this->_confPath . '/backup/' . $confFile['name'], $this->_confPath . '/' . $confFile['name']);
					return(false);
				}
			}

			return(true);
		}

		function installConfFile ($fileName, $tmpFile = null) {

			foreach ($this->_confFiles as $file) {
				if ($file['name'] == $fileName) {
					$confFile = $file;
					break;
				}
			}

			if (!isset($confFile)) {
				return(false);
			}

			if ($tmpFile != null) {
				copy($tmpFile, $this->_extractPath . '/' . $confFile['name']);
			}

			return($this->_installConfFile($confFile));
		}

		function installFullBackup ($archiveName, $tmpFile) {

			copy($tmpFile, '/tmp/' . $archiveName);
			exec('/bin/tar -xzf /tmp/' . addcslashes($archiveName , ' ()') .' -C ' . $this->_extractPath);

			foreach ($this->_confFiles as $confFile) {
				$this->_installConfFile($confFile, false);
			}

			$this->_installUserAppConf();

			if (!$this->_restore->restoreConfig()) {
				foreach ($this->_confFiles as $confFile) {
					copy($this->_confPath . '/backup/' . $confFile['name'], $this->_confPath . '/' . $confFile['name']);
				}
				return(false);
			}

			return(true);
		}

		function installCleanup() {
			exec('/bin/rm -rf ' . $this->_extractPath);
		}

		function verifyFileName ($fileName) {

			$ext = explode('.', $fileName, 2);
			if (($ext[1] == 'tar.gz') || ($ext[1] == 'tgz')) {
				return((strcmp($fileName, 'beroNetGW-' . $this->_cardSerial . '-backup.tar.gz') == 0) ? 3 : 2);
			}
			unset($ext);

			$valid = false;
			foreach ($this->_confFiles as $confFile) {
				if ($fileName == $confFile['name']) {
					$valid = true;
					break;
				}
			}

			return(($valid == true) ? 1 : 0);
		}
	}
}
?>
