<?php

if (defined('_FULLTRACE_CLASS')) {
	return;
}

define('_FULLTRACE_CLASS', true);

include('/usr/fallback/beroConf.php');
include_once ('/usr/local/php/include/restore.Class.php');
include('/usr/local/www/berogui/includes/isgwtelnet.php');
include_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class fulltrace {

	private $_ba;
	private $_bc;
	private $_isgw;

	private $_isSbcVm = false;

	private $_isgwRetrieve = array(
						0 => array('isgw_sipstate', 'isgw_sipstateInbound', 'isgw_isdnstate', 'isgw_actualcalls', 'isgw_bchannels', 'isgw_callcompact', 'isgw_rtpstate', 'isgw_listallcallshidden', 'isgw_gsmstate', 'isgw_adv_gsmstate', 'isgw_gsmoperators', 'isgw_version', 'isgw_dnscache'),
						1 => array('isgw_sipstate', 'isgw_sipstateInbound', 'isgw_actualcalls', 'isgw_callcompact', 'isgw_rtpstate', 'isgw_listallcallshidden', 'isgw_version', 'isgw_dnscache'),
					);

	private $_paths = array(
						'apache2'	=> array(
							'dir' => '/var/log/apache2',
							'rm'	=> false,
						),
						'apache2-cf' => array(
							'dir' => '/etc/apache2',
							'rm'	=> false,
						),
						'beronode' => array(
							'dir' => '/var/log/sbc-api',
							'rm'	=> false,
						),
						'cloud-sbc' => array(
							'dir' => '/var/log/cloud-sbc',
							'rm'	=> true,
						),
						'ifaces' 	=> array(
							'dir'	=> '/var/log/captures',
							'rm'	=> true,
						),
						'isgw'		=> array(
							'dir'	=> '/var/log/isgw',
							'rm'	=> false,
						),
						'isgw-cf' => array(
							'dir'	=> '/etc/beroNet/isgw',
							'rm'	=> false,
						),
						'openvpn' => array(
							'dir'	=> '/var/log/openvpn',
							'rm'	=> false,
						),
					);

	function __construct($bc = null) {
		$this->_ba = new beroAri();
		$this->_bc = is_null($bc) ? new beroConf('root') : $bc;
		$this->_isgw = new isgwtelnet();
		$this->_isgw->isgw_login();

		$this->_isSbcVm = ($this->_bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0);
	}

	/* [PUBLIC METHODS] */
	public static function getDate($is_sbc_vm, $formatString = null) {
		$path = array(
			0 => '/bin/date',
			1 => '/usr/bin/data',
		);
		Helper::exec($is_sbc_vm, "{$path[$is_sbc_vm]} " . (($formatString != null) ? $formatString : '-R'), $output);
		return(trim($output[0]));
	}

	// get runtime files
	public function get_runtime_files () {
		if ($this->_ba->get('trace') != 1) {
			return(null);
		}
		$files = array(
			0 => array_merge(glob('/var/log/ISDNdebug*'), glob('/var/log/isgw.*log*'), glob('/var/log/tcpdump*')),
			1 => array_merge(glob("{$this->_paths['isgw']['dir']}/isgw.*log*"), glob("{$this->_paths['ifaces']['dir']}/*.pcap")),
		);
		return $files[$this->_isSbcVm];
	}

	public function start($advanced, $options = array()) {
		$fctToUse = array(
			0 => '_sbcStart',
			1 => '_sbcvmStart',
		);
		$fctToUse = $fctToUse[$this->_isSbcVm];
		return $this->$fctToUse($advanced, $options);
	}

	public function stop($set_date = false, $cancel = 0) {
		return $this->_stop($set_date, $cancel == 1 ? 1 : 0);
	}

	/* [PRIVATE METHODS - GENERIC FUNCTIONS] */
	private function _getListFiles() {
		$var = '/var/log';
		$files = array('toClean' => array(), 'toTar' => array());
	 	// Cloud SBC
		if ($this->_isSbcVm) {
			// gather files to be archived
			$files['toTar'] = array(
				'/etc/beroNet/sbc.conf',
				"$var/fulltrace-starttime.txt",
				"$var/fulltrace-info.txt",
			);
			$files['toTar'] = array_merge($files['toTar'], $this->_getFolders(true));
			// gather files to be cleaned
			$files['toClean'] = array_merge($this->_getFolders(), array(
				"{$this->_paths['ifaces']['dir']}/fulltrace-pcap.txt",
				"$var/fulltrace-starttime.txt",
				"$var/fulltrace-info.txt",
			));
		}
		// Standard SBC
		else {
			// gather files to be archived
			if (file_exists('/tmp/ftrace.sms') && file_exists('/var/log/sms/')) {
				$files['toTar'][] = "$var/sms";
			}
			if (file_exists('/var/log/analog-ports')) {
				$files['toTar'][] = "$var/analog-ports";
			}
			if (file_exists('/usr/local/repo_info.txt')) {
				$files['toTar'][] = '/usr/local/repo_info.txt';
			}

			$files['toTar'] = array_unique(array_merge($files['toTar'], glob("$var/ISDNdebug-*"), glob("$var/*log*"), glob("$var/*cdr*"), glob("$var/*.txt"), glob("$var/*.pcap"),
				array_diff(glob("$var/isgw.*"), glob("$var/isgw.sys*")), array(
				"$var/l1_stats",
				"$var/l2_stats",
				"$var/info",
				"$var/smgw.err",
				'/usr/conf',
			)));

			// gather files to be cleaned
			if (file_exists("$var/analog-ports")) {
				$files['toClean'][] = "$var/analog-ports";
			}
			$files['toClean'] = array_unique(array_merge($files['toClean'], glob("$var/ISDNdebug-*.pcap"), glob("$var/tcpdump*.pcap"), glob("$var/isgw.info*"), array(
				"$var/fulltrace-starttime.txt",
				"$var/fulltrace-info.txt",
				"$var/analog_debug.log",
				"$var/analog_debug.log.1",
			)));
		}

		$files['toTar'] = array_map(array('Helper', 'truncateString'), $files['toTar'], array_fill(0, count($files['toTar']), "$var/"));

		return $files;
	}

	// get SIP UDP-Port
	private function _getSipPort($iface) {
		return $this->_ba->get("sip_bindport_$iface");
	}

	private function _parseOptions(&$advanced, $options = array()) {
		if ($advanced == 1) {
			$optionsToParse = array();
			foreach (explode(',', $options) as $option) {
				$dummy = explode('=', $option);
				$optionsToParse[$dummy[0]] = $dummy[1];
			}
			if (isset($optionsToParse['mode']) && $optionsToParse['mode'] == 'basic') {
				$advanced = 0;
				return null;
			}
			return $optionsToParse;
		}
		return null;
	}

	private function _setIfaces($advanced, $options) {
		$ifaces = array();
		// Cloud SBC
		if ($this->_isSbcVm) {
			$port = $this->_getSipPort('wan');
			$ifaces['wan'] = array(
				'filter'=> $this->_setFilter($advanced, $options['filter_wan'], 'port 53 or icmp'. (strlen($port) ? " or port $port or port ". ($port + 1) : '')),
				'limit' => $this->_setLimit($options['limit_wan'], 5),
				'name' 	=> 'ens4',
				'pcap'	=> "{$this->_paths['ifaces']['dir']}/tcpdump.wan.pcap",
			);
			if ($this->_bc->get('root', 'is-vpn-running') == 1) {
				$port = $this->_getSipPort('lan');
				$ifaces['lan'] = array(
					'filter'=> $this->_setFilter($advanced, $options['filter_lan'], 'port 53 or icmp'. (strlen($port) ? " or port $port or port ". ($port + 1) : '')),
					'limit' => $this->_setLimit($options['limit_lan'], 5),
					'name'	=> 'tun0',
					'pcap'	=> "{$this->_paths['ifaces']['dir']}/tcpdump.lan.pcap",
				);
			}
		}
		// SBC
		else {
			$ifaces['msp'] = array(
				'filter'=> $this->_setFilter($advanced, $options['filter_msp'], 'port 53 or icmp'),
				'limit' => $this->_setLimit($options['limit_msp'], 0),
				'name'	=> 'eth1',	
				'pcap'	=> '/var/log/tcpdump.msp.pcap',
			);
			$ifaces['lo'] = array(
				'filter'=> $this->_setFilter($advanced, $options['filter_lo'], 'port 53 or icmp or port 5060 or port 5061'),
				'limit'	=> $this->_setLimit($options['limit_lo'], 1),
				'name'	=> 'lo',
				'pcap'	=> '/var/log/tcpdump.lo.pcap',
			);
			$port = $this->_getSipPort('lan');
			$ifaces['lan'] = array(
				'filter'=> $this->_setFilter($advanced, $options['filter_lan'], 'port 53 or icmp'. (strlen($port) ? " or port $port or port ". ($port + 1) : '')),
				'limit'	=> $this->_setLimit($options['limit_lan'], 3),
				'name'	=> 'eth0'. ($this->_bc->get('root', 'vlan-enable') == 1 ? ".". $this->_bc->get('root', 'vlan-id') : ''),
				'pcap'	=> '/var/log/tcpdump.lan.pcap',
			);
			if ($this->_bc->get('root', 'lan-ports') == 2 && $this->_bc->get('root', 'lan-ports') != 'bonding') {
				$ifaces['lan']['limit'] = $this->_setLimit($options['limit_lan'], 2);
				$ifaces['lan']['name'] = 'eth0.10';

				$port = $this->_getSipPort('wan');
				$ifaces['wan'] = array(
					'filter'=> $this->_setFilter($advanced, $options['filter_wan'], 'port 53 or icmp'. (strlen($port) ? " or port $port or port ". ($port + 1) : '')),
					'limit'	=> $this->_setLimit($options['limit_wan'], 2),
					'name'	=> 'eth0.11',
					'pcap'	=> '/var/log/tcpdump.wan.pcap',
				);
			}
		}
		return $ifaces;
	}

	private function _setFilter($advanced, $value, $basic) {
		if ($advanced) {
			return(is_null($value) ? '' : preg_replace('/[^][\/ +=?0-9.a-zA-Z{}():_-]+/', '', $value));
		}
		return $basic;
	}

	private function _setLimit($value, $default) {
		return(is_null($value) ? $default : $value);
	}

	// stop a fulltrace
	private function _stop($set_date = false, $cancel = 0) {
		// init
		$this->_ba->set('trace', 0);
		if ($cancel) {
			$this->_bc->delete('root', 'trace-state');
		}
		else {
			$this->_bc->set('root', 'trace-state', 'STOPPING');
		}

		//create info file
		$info_path = array(
			0 => '/var/log/info',
			1 => "{$this->_paths['cloud-sbc']['dir']}/info",
		);
		file_put_contents($info_path[$this->_isSbcVm], Helper::jsonEncode(Helper::getInfo($this->_bc, $this->_ba, $this->_isgw, $this->_isSbcVm), JSON_PRETTY_PRINT));

		// stop isgw
		$this->_isgwStop($cancel);

		// load files
		$files = $this->_getListFiles();

		// execute background task
		Helper::system($this->_isSbcVm, "/usr/local/sbin/fulltrace.sh 'stop' '$cancel' '". implode(' ', $files['toTar']) ."' '". implode(' ', $files['toClean']) ."' >/dev/null 2>&1 &");
	}

	/* [PRIVATE METHODS - ISGW FUNCTIONS] */
	private function _isgwStart($loglevel = null) {
		$log = array(
			'active'=> array('d' => 1, 'm' => 1, 'n' => 1),
			'level' => array('d' => 8, 'm' => 2),
		);
		if (!is_null($loglevel)) {
			if ($loglevel == 'none') {
				$log['active'] = array_fill_keys(array_keys($log['active']), 0);
			}
			else {
				foreach (explode(':', $loglevel) as $level) {
					if ($level[1] == '-') {
						$log['active'][$level[0]] = 0;
					}
					else if (isset($log['level'][$level[0]])) {
						$lvl = substr($level, 1);
						$log['level'][$level[0]] = is_numeric($lvl) ? $lvl : $log['level'][$level[0]];
					}
				}
			}
		}

		// raise ISGW-LogLevel to set value
		if ($log['active']['d']) {
			$this->_isgw->logactive(1);
			$this->_isgw->loglevel($log['level']['d']);
		}
		else {
			$this->_isgw->logactive(0);
		}
		
		if ($log['active']['m']) {
			$this->_isgw->logactive_message(1);
			$this->_isgw->loglevel_message($log['level']['m']);
		}
		else {
			$this->_isgw->logactive_message(0);
		}
		
		$this->_isgw->logactive_nmessage($log['active']['n']);

		$this->_isgw->Query('nlog0::Fulltrace started');

		// retrieve data from ISGW
		$isgw_ret = '';
		foreach ($this->_isgwRetrieve[$this->_isSbcVm] as $method) {
			$isgw_ret .= $this->_isgw->$method(1);
		}

		// append ISGW-data to file
		$path = array(
			0 => '/var/log/',
			1 => $this->_paths['isgw']['dir'],
		);
		if ($this->_isSbcVm) {
			Helper::system(1, "chown -R www-data:www-data {$path[1]}");
		}
		file_put_contents("{$path[$this->_isSbcVm]}/isgw.info2", $isgw_ret);
	}

	private function _isgwStop($cancel = 0) {
		if ($cancel != 1) {
			// retrieve data from ISGW
			$retrieve = $this->_isgwRetrieve[$this->_isSbcVm];
			$retrieve[] = 'isgw_dmalloc_write';

			foreach ($retrieve as $method) {
				$isgw_ret .= $this->_isgw->$method(1);
			}

			// append ISGW-data to file
			$path = array(
				0 => '/var/log/',
				1 => $this->_paths['isgw']['dir'],
			);
			file_put_contents("{$path[$this->_isSbcVm]}/isgw.info1", $isgw_ret);
			if ($this->_isSbcVm) {
				Helper::system(1, "chown -R root:root {$path[1]}");
			}
		}

		$this->_isgw->Query('nlog0::Fulltrace stopped');
		
		// reset ISGW-logging-settings to initial values
		$this->_isgw->logactive($this->_ba->get('logging_debug'));
		$this->_isgw->loglevel($this->_ba->get('loglevel_debug'));
		
		$this->_isgw->logactive_message($this->_ba->get('logging_message'));
		$this->_isgw->loglevel_message($this->_ba->get('loglevel_message'));
		
		$this->_isgw->logactive_nmessage($this->_ba->get('loglevel_nmessage'));
		
		//stop CAS log
		$this->_isgw->caslog(0);
	}

	/* [PRIVATE METHODS - SBC FUNCTIONS] */
	private function _sbcStart($advanced, $options = array()) {
		// init
		$this->_ba->set('trace', 1);
		$parsed = $this->_parseOptions($advanced, $options['advanced']);
		$files = $this->_getListFiles();
		Helper::system(0, "/usr/local/sbin/fulltrace.sh 'start' '0' '0' '". implode(' ', $files['toClean']) ."' &");

		// fulltrace header
		file_put_contents('/var/log/fulltrace-starttime.txt', self::getDate(0, "+%Y-%m-%d\ %H:%M:%S"));
		file_put_contents("/var/log/fulltrace-info.txt", "fulltrace_type=$advanced\nfulltrace_options={$options['advanced']}\n");
		
		// start fulltrace
		$this->_isgwStart($parsed['loglevel']);
		
		$pcap_info_file = "/var/log/fulltrace-pcap.txt";
		file_put_contents($pcap_info_file, "\n##### PCAP traces started:\n");
		
		// trace of ISDN-Ports
		if (!isset($parsed['noisdn']) || $parsed['noisdn'] == 0) {
			$qu = $this->_ba->select('SELECT * FROM isdn');
			while ($entry = $this->_ba->fetch_array($qu)) {
				$ports .=  "{$entry['port']},";
			}
			$ports = rtrim($ports, ",");
			if (strlen($ports)) {
				$limit_mISDN = 5000;
				Helper::system(0 , '/sbin/insmod /usr/local/modules/mISDN_debugtool.ko');
				$tcpdumpcmd = "/usr/local/bin/mISDNdebugtool -d -s $limit_mISDN -f /var/log/ISDNdebug -p $ports";
				Helper::exec(0, $tcpdumpcmd);
				file_put_contents($pcap_info_file, "$tcpdumpcmd\n", FILE_APPEND);
			}
		}

		// trace of Analog-Ports
		if ((!isset($parsed['noanalog']) || $parsed['noanalog'] == 0) && $options['analog']['isset'] && !empty($options['analog']['ports'])) {
			if (!file_exists('/var/log/analog-ports/')) {
				Helper::exec(0, '/bin/mkdir -p /var/log/analog-ports/ && /bin/chmod 0644 /var/log/analog-ports/');
			}
			$analog_ports = implode(" ", $options['analog']['ports']);
				Helper::exec(0, "/usr/local/sbin/analog-debugtool $analog_ports > /dev/null &");
		}

		// trace of GSM-Ports
		if (!isset($parsed['nogsm']) || $parsed['nogsm'] == 0) {
			$qu = $this->_ba->select('SELECT * FROM gsm');
			$record_count_gsm = sqlite_num_rows($qu);
		
			$qu = $this->_ba->select('SELECT * FROM lte');
			$record_count_lte = sqlite_num_rows($qu);
		
			if ($record_count_gsm > 0 || $record_count_lte > 0) {
				Helper::exec(0, '/usr/local/sbin/gsm-debugtool > /dev/null &');
				Helper::exec(0, 'touch /tmp/ftrace.sms > /dev/null');
			}
		}

		// trace of CAS-Ports
		if (!isset($parsed['nocas']) || $parsed['nocas'] == 0) {
			$qu = $this->_ba->select('SELECT * FROM cas');
			$record_count_cas = sqlite_num_rows($qu);
			if ($record_count_cas > 0) {
				$this->_isgw->caslog(1);
			}
		}

		// capture interfaces 
		foreach ($this->_setIfaces($advanced, $parsed) as $iface) {	
			if ($iface['limit'] > 0) {
				$cmd = "/usr/local/sbin/tcpdump.sh {$iface['pcap']} {$iface['limit']} -i {$iface['name']} -s0 -U {$iface['filter']} > /dev/null &";
				Helper::exec(0, $cmd);
				file_put_contents($pcap_info_file, "$cmd\n", FILE_APPEND);
			}
		}
	}

	/* [PRIVATE METHODS - CLOUD SBC FUNCTIONS] */
	private function _getFolders($toLog = false) {
		foreach ($this->_paths as $path) {
			if ($toLog) {
				$dirs[] = $path['dir'];
			}
			else if ($path['rm']) {
				$dirs[] = $path['dir'];
			}
		}
		return $dirs;
	}

	private function _sbcvmStart($advanced, $options = array()) {
		// init
		$this->_ba->set('trace', 1);	
		$files = $this->_getListFiles();
		$parsed = $this->_parseOptions($advanced, $options['advanced']);
		Helper::system(1, "/usr/local/sbin/fulltrace.sh 'start' '0' '". implode(' ', $this->_getFolders()) ."' '". implode(' ', $files['toClean']) ."'");

		file_put_contents("{$this->_paths['cloud-sbc']['dir']}/fulltrace-starttime.txt", self::getDate(1, "+%Y-%m-%d\ %H:%M:%S"));
		file_put_contents("{$this->_paths['cloud-sbc']['dir']}/fulltrace-info.txt", "fulltrace_type=$advanced\nfulltrace_options={$options['advanced']}\n");

		// start ISGW fulltrace
		$this->_isgwStart($parsed['loglevel']);

		// capture interfaces 
		foreach ($this->_setIfaces($advanced, $parsed) as $iface) {	
			if ($iface['limit'] > 0) {
				$cmd = "/usr/local/sbin/tcpdump.sh {$iface['pcap']} {$iface['limit']} -i {$iface['name']} -s0 -U {$iface['filter']} >/dev/null 2>&1 &";
				Helper::exec(1, $cmd);
				file_put_contents("{$this->_paths['ifaces']['dir']}/fulltrace-pcap.txt", "$cmd\n", FILE_APPEND);
			}
		}
	}
} // END DEFINE _FULLTRACE_CLASS
?>
