<?php

require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class ShortMessageService {

	private		$_isgw,
			$_error,
			$_errorMessage;

	function __construct ()  {

		$this->_error = false;
		$this->_errorMessage = '';

		$this->_isgw = new isgwtelnet();
		if ($this->_isgw->isgw_login() == false) {
			$this->_error = true;
			$this->_errorMessage = 'Connection refused by ISGW';
		}

		foreach (array('in', 'out', 'failout') as $folder) {
			if (!file_exists('/tmp/sms/' . $folder)) {
				@exec('/bin/mkdir -p /tmp/sms/' . $folder);
			}
		}
	}

	public function getErrorText () {
		return(($this->_error = true) ? $this->_errorMessage : false);
	}

	private function _evaluateSmsStatus ($status) {
		switch ($status['status']) {
		case 'OK':
			return(array('smsId' => $status['smsId'], 'status' => $status['status']));
		case 'ERROR':
			return(array('smsId' => $status['smsId'], 'status' => $status['status'], 'message' => $status['message']));
		}

		return(array('smsId' => $status['smsId'], 'status' => 'UNKNOWN'));
	}

	public function sendMessage ($phoneNumber, $shortMessage, $gsmPort = 1, $confirmationWait = false) {

		if ($this->_error == true) {
			return(false);
		}

		if (empty($phoneNumber) || empty($shortMessage)) {
			$this->_error = true;
			$this->_errorMessage = 'Phone-Number or Message missing';
			return(false);
		}

		if (strlen($shortMessage) > 670) {
			$this->_error = true;
			$this->_errorMessage = 'Message too long';
			return(false);
		}

		// create sms-file
		$smsId = uniqid();
		$smsFile = '/tmp/sms/out/' . $smsId . '.sms';
		$smsContent = 'num=' . $phoneNumber . "\n" . 'port='. $gsmPort . "\n" . 'msg=' . stripslashes($shortMessage);

		// write sms and send it
		@file_put_contents($smsFile, $smsContent);
		$this->_isgw->ssms();

		if ($confirmationWait == false) {
			return($smsId);
		}

		for ($i = 0; $i < $confirmationWait; $i++) {
			sleep(1);
			$sendReport = @file('/tmp/sms/send_report');
			if (($sendReport == false) || (count($sendReport) == 0)) {
				continue;
			}

			foreach ($sendReport as $line) {
				unset($matchesStatus);

				preg_match('/(?<smsId>[0-9a-f]*)[\t].*[\t](?<message>.*)/', $line, $matchesStatus);
				if ($matchesStatus['smsId'] != $smsId) {
					continue;
				}
				
				$elements = explode ( ":" , $matchesStatus['message'], 2);
				$statuscode = "";
				$statustext = "";
				
				$statuscode=$elements[0];
				if (sizeof ($elements) == 2) {
					$statustext = $elements[1];
				}
				return($this->_evaluateSmsStatus(array('smsId' => $matchesStatus['smsId'], 'status' => $statuscode, 'message' => $statustext)));
			}
		}

		// if we get here, we had a timeout
		return(array('smsId' => $smsId, 'status' => 'TIMEOUT'));
	}

	public function listMessages ($queueName) {

		if (!in_array($queueName, array('in', 'out', 'failout'))) {
			return(null);
		}

		if (($dp = @opendir('/tmp/sms/' . $queueName)) == null) {
			return(null);
		}

		$ret = array();
		while (($file = readdir($dp)) !== false) {
			if (($file == '.') || ($file == '..')) {
				continue;
			}

			if ($queueName == 'failout') {
				$ret[] = $file;
				continue;
			}

			if (preg_match('/.*\.sms$/', $file)) {
				$ret[] = basename($file, '.sms');
			}
		}

		return($ret);
	}

	public function getMessage ($queueName, $smsId) {

		if (!in_array($queueName, array('in', 'out', 'failout'))) {
			return(null);
		}

		switch ($queueName) {
		case 'in':
			$smsFile = '/tmp/sms/' . $queueName . '/' . $smsId . '.sms';
			$ret['message'] = (!file_exists($smsFile)) ? 'Message not found' : @file_get_contents($smsFile);
			break;
		case 'out':
			$smsFile = '/tmp/sms/' . $queueName . '/' . $smsId . '.sms';
			$ret['message'] = (!file_exists($smsFile)) ? 'Message not found' : @file_get_contents($smsFile);
			$ret['log'] = (!file_exists($smsFile . '.log')) ? '' : @file_get_contents($smsFile . '.log');
			break;
		case 'failout':
			$smsFile = '/tmp/sms/' . $queueName . '/' . $smsId . '/message';
			$ret['message'] = (!file_exists($smsFile)) ? 'Message not found' : @file_get_contents($smsFile);
			$ret['log'] = (!file_exists($smsFile . '.log')) ? '' : @file_get_contents($smsFile . '.log');
			break;
		}

		return($ret);
	}

	public function deleteMessage ($queueName, $smsId) {

		if (!in_array($queueName, array('in', 'out', 'failout'))) {
			return;
		}

		switch ($queueName) {
		case 'in':
			@unlink('/tmp/sms/' . $queueName . '/' . $smsId . '.sms');
			break;
		case 'out':
			@unlink('/tmp/sms/' . $queueName . '/' . $smsId . '.sms');
			@unlink('/tmp/sms/' . $queueName . '/' . $smsId . '.sms.log');
			break;
		case 'failout':
			@unlink('/tmp/sms/' . $queueName . '/' . $smsId . '/message');
			@unlink('/tmp/sms/' . $queueName . '/' . $smsId . '/message.log');
			@rmdir('/tmp/sms/' . $queueName . '/' . $smsId);
			break;
		}
	}

	public function truncate_file ($filename) {
		$f = @fopen ($filename, "r+");
		if ($f !== false) {
			ftruncate ($f, 0);
			fclose ($f);
		}
	}

	public function getSendReport ($format, $reset) {

		$report_file = '/tmp/sms/send_report';
		if (!file_exists ($report_file )) {
			return(false);
		}
		
		if (strcasecmp ($format, "tab") == 0) {
			$contents = file_get_contents ($report_file);
			if ($reset) {
				$this->truncate_file ($report_file);
			}
			return $contents;
		}
		
		//we need to support the old format
		$contents = "";
		$sendReport = @file ($report_file);
	
		if ($reset) {
			$this->truncate_file ($report_file);
		}
		
		foreach ($sendReport as $line) {
			$elements = explode ("\t", $line);
			$contents .= $elements[0] . ":" . $elements[5];
		}
		return ($contents);
	}


	public function getDeliveryReport ($format, $reset) {
	
		$report_file = '/tmp/sms/delivery_report';
	    if (!file_exists ($report_file)) {
	        return(false);
	    }
	    $contents = file_get_contents ($report_file);
		if ($reset) {
			$this->truncate_file ($report_file);
		}
		return $contents;
	}
	
	public function purgeSendReport () {
		@unlink('/tmp/sms/send_report');
	}

	public function getMessageError ($smsId) {

		if (!file_exists('/tmp/sms/send_report')) {
			return(false);
		}

		$lines = @file('/tmp/sms/send_report');
		foreach ($lines as $line) {
			unset($matches);
			preg_match('/(?<smsId>[0-9a-f]*):(?<status>[A-Z]*):(?<message>.*)/', $line, $matches);
			if ($matches['smsId'] == $smsId) {
				break;
			}
		}

		return($matches['message']);
	}
}
?>
