#!/usr/bin/php -q
<?php
/* moduleConfigure.php: Script to configure module-parameters according to hardware.conf
 *
 * Author: Florian Kraatz <fk@beronet.com>
 *
 * Copyright (C) 2016 beroNet GmbH <support@beronet.com>
 *
 */

require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

/* functions */
function appendLog ($logLine, $logAppend = true) {

	if ($logAppend == false) {
		file_put_contents('/var/log/modules-bootup.log', '# modules-bootup.log created on ' . Helper::getDate() . "\n\n");
	}

	file_put_contents('/var/log/modules-bootup.log', $logLine . "\n", FILE_APPEND);
}

function parseE1 ($section, $Parameter, $twoChips = false) {

	$pr = explode(',', $section['ntteSW']);
	$pr = str_replace('te', '2', $pr);
	$pr = str_replace('nt', '18', $pr);

	$lm = explode(',', $section['ntteSW']);
	$lm = str_replace('te', '0xf', $lm);
	$lm = str_replace('nt', '0x3', $lm);

	$crc = explode(',', $section['crc']);
	$crc = str_replace('0', '8388608', $crc);
	$crc = str_replace('1', '0', $crc);

	$Parameter['tmp_lm'] = (!empty($Parameter['tmp_lm']) ? array_merge($Parameter['tmp_lm'], $lm) : $lm);
	$Parameter['tmp_pr'] = (!empty($Parameter['tmp_pr']) ? array_merge($Parameter['tmp_pr'], $pr) : $pr);
	$Parameter['tmp_crc'] = (!empty($Parameter['tmp_crc']) ? array_merge($Parameter['tmp_crc'], $crc) : $crc);

	$slave = ($section['master'] == 1) ? 0 : 1;

	$tmpCalc = array((65537 + str_replace('1', '2048', $slave)));
	if ($twoChips == true) {
		$tmpCalc[] = 65537 + 2048;
	}
	$Parameter['tmp_master'] = (!empty($Parameter['tmp_master']) ? array_merge($Parameter['tmp_master'], ($tmpCalc)) : $tmpCalc);

	$i = 0;
	foreach ($Parameter['tmp_pr'] as $item) {
		$Parameter['tmp_protocol'][$i] = '0x' . dechex($Parameter['tmp_pr'][$i] + $Parameter['tmp_crc'][$i]);
		$i++;
	}

	$i = 0;
	foreach ($Parameter['tmp_master'] as $item) {
		$tmp = $item;
		if ($section['crystal_clock'] == 1) {
			$tmp += 262144;
		}
		$Parameter['tmp_type'][$i] = '0x' . dechex($tmp);
		$i++;
	}

	$Parameter['loadMisdn'] = true;
	$Parameter['layermask'] = implode(',', $Parameter['tmp_lm']);
	$Parameter['protocol'] = implode(',', $Parameter['tmp_protocol']);
	$Parameter['type'] = implode(',', $Parameter['tmp_type']);

	if (!isset($Parameter['debug']) || ($Parameter['debug'] == '0x00')) {
		$Parameter['debug'] =  isset($section['debug']) ? $section['debug'] : '0x00';
	}

	return($Parameter);
}

function parseS0 ($section, $Parameter) {

	$lm = explode(',', $section['ntteSW']);
	$lm = str_replace('te', '0xf', $lm);
	$lm = str_replace('nt', '0x3', $lm);

	$pr = explode(',', $section['ntteSW']);
	$pr = str_replace('te', '2', $pr);
	$pr = str_replace('nt', '18', $pr);

	$hw = explode(',', $section['ntteHW']);
	$hw = str_replace('te', '0', $hw);
	$hw = str_replace('nt', '2048', $hw);

	$pp = explode(',', $section['ptp']);
	$pp = str_replace('1', '8192', $pp);

	$lt = explode(',', $section['termination']);
	$lt = str_replace('0', '1024', $lt);
	$lt = str_replace('1', '0', $lt);
	$lt = str_replace('1', '1024', $lt);

	$aa = explode(',', $section['permanentl1']);
	$aa = str_replace('1', '16384', $aa);

	$cidlen = explode(',', $section['cidlen']);
	$cidlen = str_replace('1', '0', $cidlen );
	$cidlen = str_replace('2', '0x8000', $cidlen );

	$crlen = explode(',', $section['crlen']);
	$crlen = str_replace('1', '0', $crlen );
	$crlen = str_replace('2', '0x10000', $crlen );


	$slave = ($section['master'] == 1) ? 0 : 1;
	$master = array(str_replace('1', '262144', $slave));
	$clock = array($section['clock'] * 1048576);
	$portswitch = array(($section['portswitch'] == 0) ? 0 : 1);

	$Parameter['tmp_lm'] = (!empty($Parameter['tmp_lm']) ? array_merge($Parameter['tmp_lm'], $lm) : $lm);
	$Parameter['tmp_pr'] = (!empty($Parameter['tmp_pr']) ? array_merge($Parameter['tmp_pr'], $pr) : $pr);
	$Parameter['tmp_lt'] = (!empty($Parameter['tmp_lt']) ? array_merge($Parameter['tmp_lt'], $lt) : $lt);
	$Parameter['tmp_pp'] = (!empty($Parameter['tmp_pp']) ? array_merge($Parameter['tmp_pp'], $pp) : $pp);
	$Parameter['tmp_hw'] = (!empty($Parameter['tmp_hw']) ? array_merge($Parameter['tmp_hw'], $hw) : $hw);
	$Parameter['tmp_aa'] = (!empty($Parameter['tmp_aa']) ? array_merge($Parameter['tmp_aa'], $aa) : $aa);
	$Parameter['tmp_clock'] = (!empty($Parameter['tmp_clock']) ? array_merge($Parameter['tmp_clock'], $clock) : $clock);
	$Parameter['tmp_master'] = (!empty($Parameter['tmp_master']) ? array_merge($Parameter['tmp_master'], $master) : $master);
	$Parameter['tmp_ps'] = (!empty($Parameter['tmp_ps']) ? array_merge($Parameter['tmp_ps'], $portswitch) : $portswitch);
	$Parameter['tmp_cidlen'] = (!empty($Parameter['tmp_cidlen']) ? array_merge($Parameter['tmp_cidlen'], $cidlen) : $cidlen);
	$Parameter['tmp_crlen'] = (!empty($Parameter['tmp_crlen']) ? array_merge($Parameter['tmp_crlen'], $crlen) : $crlen);


	$i = 0;
	foreach ($Parameter['tmp_pr'] as $item) {
		if ($lm[$i] == '0xf') {//only use crlen/cidlen parameter on te
			$xhfc_protocol[$i] = '0x' . dechex($Parameter['tmp_pr'][$i] + $Parameter['tmp_lt'][$i] + $Parameter['tmp_hw'][$i] + $Parameter['tmp_pp'][$i] + $Parameter['tmp_aa'][$i] + $Parameter['tmp_cidlen'][$i]  + $Parameter['tmp_crlen'][$i]);
		}
		else {
			$xhfc_protocol[$i] = '0x' . dechex($Parameter['tmp_pr'][$i] + $Parameter['tmp_lt'][$i] + $Parameter['tmp_hw'][$i] + $Parameter['tmp_pp'][$i] + $Parameter['tmp_aa'][$i]);
		}
		$i++;
	}

	$i = 0;
	foreach ($Parameter['tmp_clock'] as $item) {
		$xhfc_pcmconfig[$i] = '0x' . dechex($Parameter['tmp_clock'][$i] + $Parameter['tmp_master'][$i] + 589825);
		$i++;
	}

	$Parameter['loadMisdn'] = true;
	$Parameter['pcm'] = '0x00';
	$Parameter['protocol'] = implode(',', $xhfc_protocol);
	$Parameter['pcm_config'] = implode(',', $xhfc_pcmconfig);
	$Parameter['layermask'] = implode(',', $Parameter['tmp_lm']);
	$Parameter['portswitch'] = in_array('1', $Parameter['tmp_ps']) ? '1' : '0';

	if (!isset($Parameter['debug']) || ($Parameter['debug'] == '0x00')) {
		$Parameter['debug'] =  isset($section['debug']) ? $section['debug'] : '0x00';
	}

	return($Parameter);
}

function _parseFXx ($section, $Parameter) {

	$Parameter['portswitch'] = !empty($section['portswitch']) ? $section['portswitch'] : '0';
	$Parameter['boostringer'] = !empty($section['boostringer']) ? $section['boostringer'] : '0';
	$Parameter['fastringer'] = !empty($section['fastringer']) ? $section['fastringer'] : '0';
	$Parameter['country'] =  !empty($section['country']) ? $section['country'] : 'FCC';
	$Parameter['debug'] =  !empty($section['debug']) ? $section['debug'] : '0';

	return($Parameter);
}

function parseFXS ($section, $Parameter) {
	$Parameter = _parseFXx($section, $Parameter);
	
	$fxs_config_ring_oscillator_on = isset($section['ring_oscillator_on']) ? $section['ring_oscillator_on'] : '1000';
	if (is_numeric ($fxs_config_ring_oscillator_on)) {
		$Parameter['fxs_config_ring_oscillator_on'] = $fxs_config_ring_oscillator_on;
	}
	
	$fxs_config_ring_oscillator_off = isset($section['ring_oscillator_off']) ? $section['ring_oscillator_off'] : '4000';
	if (is_numeric ($fxs_config_ring_oscillator_off)) {
		$Parameter['fxs_config_ring_oscillator_off'] = $fxs_config_ring_oscillator_off;
	}
	return($Parameter);
}

function parseFXO ($section, $Parameter) {

	$Parameter = _parseFXx($section, $Parameter);

	if ($Parameter['country'] == 'USER') {
		$Parameter['fxo_config_ohs'] = isset($section['ohs']) ? $section['ohs'] : '0';
		$Parameter['fxo_config_ohs2'] = isset($section['ohs2']) ? $section['ohs2'] : '0';
		$Parameter['fxo_config_rz'] = isset($section['rz']) ? $section['rz'] : '0';
		$Parameter['fxo_config_rt'] = isset($section['rt']) ? $section['rt'] : '0';
		$Parameter['fxo_config_rt2'] = isset($section['rt2']) ? $section['rt2'] : '0';
		$Parameter['fxo_config_dcv'] = isset($section['dcv']) ? $section['dcv'] : '0';
		$Parameter['fxo_config_mini'] = isset($section['mini']) ? $section['mini'] : '0';
		$Parameter['fxo_config_ilim'] = isset($section['ilim']) ? $section['ilim'] : '0';
		$Parameter['fxo_config_acim'] = isset($section['acim']) ? $section['acim'] : '0';
	}
	
	$fxo_config_wait4idle = isset($section['wait4idle']) ? $section['wait4idle'] : '1000';
	if (is_numeric ($fxo_config_wait4idle)) {
		$Parameter['fxo_config_wait4idle'] = $fxo_config_wait4idle;
	}
	return($Parameter);
}

function parseGSM ($section, $Parameter) {
	$Parameter['tmp_isinstalled'] = 1;
	return($Parameter);
}

function parseT1E1 ($section, $Parameter) {

	$protocol = explode(',', $section['protocol']);
	$termination = explode(',', $section['termination']);
	$coding = explode(',', $section['coding']);
	$sigchan = explode(',', $section['sigchan']);
	$country = explode(',', $section['country']);

	$i = 0;
	foreach (explode(',', $section['interface_type']) as $interfaceType) {
		switch($interfaceType) {
		case 'cas':
			$Parameter['p_trunk_mode'][] = '0';
			switch ($protocol[$i]) {
			case 't1':
				$Parameter['p_mode'][] = (($coding == 'AMI') ? 6 : 1);
				break;
			case 'e1':
				$Parameter['p_mode'][] = 5;
				break;
			}
			break;
		case 'hdlc':
			$Parameter['loadMisdn'] = true;
			$Parameter['p_trunk_mode'][] = (($termination[$i] == 'nt') ? '1' : '0');
			switch ($protocol[$i]) {
			case 't1':
				$Parameter['p_mode'][] = 2;
				break;
			case 'e1':
				$Parameter['p_mode'][] = 4;
				break;
			}
			break;
		}

		$Parameter['tmp_sigchan'][] = $sigchan[$i];
		$Parameter['tmp_country'][] = $country[$i];

		$i++;
	}

	$Parameter['p_clock_cfg'][] = $section['clock'] - 1;
	$Parameter['loadMisdn'] = true;

	return($Parameter);
}

function cleanupParameter ($Parameter) {

	if (empty($Parameter)) {
		return($Parameter);
	}

	foreach ($Parameter as $name => $section) {
		if (empty($section)) {
			continue;
		}
		foreach ($section as $key => $value) {
			if (strstr($key, 'tmp_')) {
				unset($Parameter[$name][$key]);
			}
		}
	}

	return($Parameter);
}

function loadMisdnModules() {
	foreach(array('mISDN_core', 'mISDN_l1', 'mISDN_l2', 'l3udss1') as $module) {
		$cmdLine = '/sbin/insmod /usr/local/modules/' . $module . '.ko';
		exec($cmdLine, $output, $result);
		appendLog('Executed: \'' . $cmdLine . '\', result: ' . $result);
	}
}

function loadModules ($Parameter) {

	if (empty($Parameter)) {
		return(0);
	}

	$mISDNloaded = false;
	$moduleFile = array('E1' => 'hfcmulti', 'S0' => 'xhfc', 'FXx' => 'bnxanalog', 'GSM' => 'bnxgsm', 'T1E1' => 'bfxt1e1');

	foreach ($Parameter as $moduleName => $moduleParameter) {
		unset($parameterLine);
		foreach ($moduleParameter as $parameterName => $parameterValue) {
			if ($parameterName == 'loadMisdn') {
				if ($mISDNloaded == false) {
					loadMisdnModules();
					$mISDNloaded = true;
				}
				continue;
			}

			unset($commaParameter);
			if (is_array($parameterValue)) {
				foreach($parameterValue as $value) {
					$commaParameter .= ((strlen($commaParameter) == 0) ? '' : ',') . $value;
				}
			} else {
				$commaParameter = $parameterValue;
			}

			$parameterLine .= ' ' . $parameterName . '=' . $commaParameter;
		}

		$cmdLine = '/sbin/insmod /usr/local/modules/' . $moduleFile[$moduleName] . '.ko' . $parameterLine;
		
		exec($cmdLine, $output, $result);
		appendLog('Executed: \'' . $cmdLine . '\', result: ' . $result);
	}

	return(0);
}

/* main-program */
if (!file_exists('/usr/conf/hardware.conf')) {
	exit(1);
}

// get contents of hardware.conf
$hardwareConf = parse_ini_file('/usr/conf/hardware.conf', true);

foreach ($hardwareConf as $sectionName => $section) {

	if (($sectionName == 'pcm') || ($section['type'] == 'none')) {
		continue;
	}

	switch($section['type']) {
		case 'bf1E1':
			$moduleParameter['E1'] = parseE1($section, $moduleParameter['E1']);
			break;
		case 'bf2E1':
			$moduleParameter['E1'] = parseE1($section, $moduleParameter['E1'], true);
			break;
		case 'bf1S0':
		case 'bf2S0':
		case 'bf4S0':
			$moduleParameter['S0'] = parseS0($section, $moduleParameter['S0']);
			break;
		case 'bf2S02FXS':
			$moduleParameter['S0'] = parseS0($section, $moduleParameter['S0']);
			$moduleParameter['FXx'] = parseFXS($section, $moduleParameter['FXx']);
			break;
		case 'bf1FXS':
		case 'bf2FXS':
		case 'bf4FXS':
		case 'bf8FXS':
			$moduleParameter['FXx'] = parseFXS($section, $moduleParameter['FXx']);
			break;
		case 'bf1FXO':
		case 'bf2FXO':
		case 'bf4FXO':
		case 'bf8FXO':
			$moduleParameter['FXx'] = parseFXO($section, $moduleParameter['FXx']);
			break;
		case 'bf1GSM':
		case 'bf2GSM':
		case 'bf2LTE':
			$moduleParameter['GSM'] = parseGSM($section, $moduleParameter['GSM']);
			break;
		case 'bf1t1e1':
		case 'bf2t1e1':
		case 'bf4t1e1':
			$moduleParameter['T1E1'] = parseT1E1($section, $moduleParameter['T1E1']);
			break;

	}
}

appendLog('Parsed file: /usr/conf/hardware.conf', false);

// done parsing file, now create the module-parameter-strings
$moduleParameter = cleanupParameter($moduleParameter);

loadModules($moduleParameter);

?>
