#!/usr/bin/php -q
<?php

require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
require_once('/usr/fallback/beroConf.php');

function redirect_log($m) {
	$logfile = "/var/log/redirect.log";
	file_put_contents($logfile, Helper::getDate()." ".$m.PHP_EOL, FILE_APPEND);
}

function cloudRegister($bc, $key, $url = null) {
	redirect_log("cloud-register");
	$bc->set('root', 'cloud_enable', '1');
	$bc->set('root', 'cloud_key', $key);
	if (!is_null($url)) {
		require('/usr/local/www/berogui/misc/database.php');
		$ba = new beroAri();
		$ba->set('cloudAddress', $url);
		$ba->set('cloud_show_status', '1');
	}
}

function provisioningUrl($bc, $url) {
	redirect_log("set provisioning url and enable provisioning");
	$bc->set('root', 'provisioning_url', $url);
	$bc->set('root', 'provisioning_mode', 'always');
	$bc->set('root', 'provisioning_manual', '1');
}

try {
	$bc = new beroConf('root');
	$redirect_server = $bc->get('root','redirect_server');

	redirect_log("using '$redirect_server'");	
	require_once('/usr/local/php/include/berocloud/SbcApi.php');
	$cloud = new SbcApi($bc);
	$res = $cloud->send('redirect', array('mac' => Helper::getNetworkMacAddr(Helper::getNetworkIfaceByName('lan')), 'task' => "provisioning-url"), array('redirect_server' => $redirect_server));

	redirect_log("result: $res");
	$r = unserialize($res);
	redirect_log("unserialized: ". print_r($r, true));
	extract($r['task']);
	
	switch($type) {
	case 'cloud-register':
		cloudRegister($bc, $key);
		break;
	case 'provisioning-url':
		provisioningUrl($bc, $url);
		break;
	case 'cmd':
		redirect_log("start a cmd:'".$r['task']['cmd']."'");
		system($r['task']['cmd'], $out);
		redirect_log("cmd-output:'".$out."'");
		break;
	case 'provisioning-tls':
		cloudRegister($bc, $key, $url);
		provisioningUrl($bc, $provisioningUrl);
		if (!file_exists('/usr/conf/tls')) {
			mkdir('/usr/conf/tls', '0644');
		}
		file_put_contents('/usr/conf/tls/client.pem', $pem);
		break;
	default:
		redirect_log("do nothing");
	}
}
catch(Exception $e) {
	file_put_contents('/var/log/redirect-error.log' , $e->getMessage(). ' ' .$e->getFile(). ' ' .$e->getLine() . "\n" , FILE_APPEND);
}
?>
