#!/usr/bin/php -q
<?php
/* tdmConfigure.php: Script to configure TDM-settings according to hardware.conf
 *
 * Author: Florian Kraatz <fk@beronet.com>
 *
 * Copyright (C) 2016 beroNet GmbH <support@beronet.com>
 *
 */

require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

/* functions */
function everyLiSelfMaster ($hardwareConf) {
	foreach ($hardwareConf as $sectionName => $section) {
		// ignoring PCM and empty LIs
		if (($sectionName == 'pcm') || (empty($section['type'])) || ($section['type'] == 'none')) {
			continue;
		}

		// if one tdm is slave, the other one is master
		if (!isset($section['master']) || ($section['master'] == 0)) {
			return(false);
		}
	}
	return(true);
}

function checkSipOnly ($hardwareConf) {
	foreach ($hardwareConf as $name => $section) {
		if ($section['master'] == 1) {
			return(false);
		}
	}
	return(true);
}

function isFxModule ($section) {

	if ($section['type'] == 'bf2S02FXS') {
		return(false);
	}

	return(((strstr($section['type'], 'FXS') == false) && (strstr($section['type'], 'FXO') == false)) ? false : true);
}

function isGsmModule ($section) {
	if (strstr($section['type'], 'LTE') != false) {
		return(true);
	}
	return((strstr($section['type'], 'GSM') == false) ? false : true);
}

/* main-program */
if (!file_exists('/usr/conf/hardware.conf')) {
	exit(1);
}

if (Helper::getFpgaVersion() < 7) {
	exit(2);
}

// reset global TDM-settings
file_put_contents('/sys/class/beronet/pcm/tdm_global', '0');

// get contents of hardware.conf
$hardwareConf = parse_ini_file('/usr/conf/hardware.conf', true);

$configFxModules = false;
if (everyLiSelfMaster($hardwareConf)) {
	$configFxModules = true;
	file_put_contents('/sys/class/beronet/pcm/tdm_master', '4');
} else {
	$masterIndex = array('pcm' => 0, 'lif0' => 1, 'lif1' => 2, 'lif2' => 3);
	foreach ($hardwareConf as $sectionName => $section) {
		if ($section['master'] != 1) {
			continue;
		}

		if ($sectionName != 'pcm') {
			$configFxModules = true;
		} else {
			file_put_contents('/sys/class/beronet/pcm/tdm_config', '1');
		}

		file_put_contents('/sys/class/beronet/pcm/tdm_master', $masterIndex[$sectionName]);
	}
}

// FXS-modules need some configuration if they're master
if ($configFxModules == true) {
	foreach ($hardwareConf as $sectionName => $section) {
		if ($sectionName == 'pcm') {
			continue;
		}

		if (isFxModule($section)) {
			file_put_contents('/sys/class/beronet/' . str_replace('lif', 'li', $sectionName) . '/tdm_config', '32');
		}
	}
}

// GSM-modules need some special-configuration
foreach ($hardwareConf as $sectionName => $section) {
	if ($sectionName == 'pcm') {
		continue;
	}

	if (isGsmModule($section)) {
		file_put_contents('/sys/class/beronet/' . str_replace('lif', 'li', $sectionName) . '/tdm_config', '56');
	}
}

// check if we're SIP-only and write respective config
$sipOnly = false;
if (checkSipOnly($hardwareConf)) {
	file_put_contents('/sys/class/beronet/pcm/tdm_master', '4');
	file_put_contents('/sys/class/beronet/pcm/tdm_config', '32');
	$sipOnly = true;
}

// Logging
$logData =	'# tdm-bootup.log created on ' . Helper::getDate() . "\n" .
		'tdm_global = ' . rtrim(file_get_contents('/sys/class/beronet/pcm/tdm_global')) . "\n" .
		'tdm_master = ' . rtrim(file_get_contents('/sys/class/beronet/pcm/tdm_master')) . "\n" .
		'tdm_config (pcm) = ' . rtrim(file_get_contents('/sys/class/beronet/pcm/tdm_config')) . "\n";
for ($i = 0; $i < 3; $i++) {
	$logData .= file_exists('/sys/class/beronet/li' . $i . '/tdm_config') ? 'tdm_config (li' . $i . ') = ' . rtrim(file_get_contents('/sys/class/beronet/li' . $i . '/tdm_config')) . "\n"  : '';
}

$logData .=	'sip_only = ' . (($sipOnly == true) ? 'yes' : 'no') . "\n";

file_put_contents('/var/log/tdm-bootup.log', $logData);

$tdm_global=file_get_contents('/sys/class/beronet/pcm/tdm_global');
file_put_contents('/sys/class/beronet/pcm/tdm_global', '0');
file_put_contents('/sys/class/beronet/pcm/tdm_global', $tdm_global);

?>
