#!/bin/bash

UNAME=$(/usr/bin/which uname)

if [ ! "$($UNAME -m)" = "x86_64" ]; then
	export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/bin/X11:/usr/local/bin:/usr/local/sbin:/usr/fallback
fi

file=$1

if [ -z "$file" ]; then
	file=/dev/null
fi

DMESG1=/var/log/dmesg.log
DMESG2=/var/log/dmesg.log.1
DMESGTMP=/var/log/dmesg.tmp
OOPS_REBOOT_MINIMUM_UPTIME=600
OOPS_FILE=/tmp/kernel_oops
OOPS_LOG=/usr/conf/oops.log
KERNEL_PATCHLEVEL_FILE=/tmp/kernel.patchlevel

function gather_dmesg {

	touch $DMESG1
	touch $DMESG2
	size=`ls -l $DMESG1 | awk  '{print $5}'`

#rotate it if it gets too big
	if [ $size -gt 50000 ]; then
		cp -f $DMESG1 $DMESG2
		echo "######  Rotating dmesg.log on " `date` > $DMESG1
	fi

	if [ "$file" = /tmp/fulltrace-info.txt ]; then
		echo -e "\n### dmesg fulltrace on " `date` >> $DMESG1
	fi

	dmesg -c |grep -v ^NWFPE > $DMESGTMP
	size=`ls -l $DMESGTMP | awk  '{print $5}'`

	if [ $size -gt 0 ]; then

		echo "###### new dmesg info on " `date` >> $DMESG1
		#check if we got a kernel oops, and if it is from isgw,  write it into oops log, if oops log set
		cat $DMESGTMP |grep "^Internal error: Oops:" &> /dev/null
		if [ $? = 0 ]; then
			cat $DMESGTMP |grep "^Process isgw" &> /dev/null
			if [ $? = 0 ]; then
				touch "$OOPS_FILE"
				if [ -n "$OOPS_LOG" ]; then
					echo OOPS OCCURRED: `date` > $OOPS_LOG
					cat $DMESGTMP >> "$OOPS_LOG"
				fi
			fi
		fi
		
		if [ ! -f $KERNEL_PATCHLEVEL_FILE ]; then
			patchlevel=`cat $DMESGTMP |grep "Kernel VED patch"|head -1` &> /dev/null
			if [[ -z $patchlevel ]]; then
				echo "No VED patch" > $KERNEL_PATCHLEVEL_FILE
			else
				echo "$patchlevel" > $KERNEL_PATCHLEVEL_FILE
			fi
		fi
		cat $DMESGTMP >> $DMESG1
	fi

	#reboot if minimum uptime has been reached, check if rebooting hasn't been disabled in isgw.conf experimental options
	if [ -f "$OOPS_FILE" ]; then
		UPTIME=`cat /proc/uptime|sed 's/\..*//'`
		OOPS_REBOOT_ALLOWED=1
		if [ $UPTIME -gt $OOPS_REBOOT_MINIMUM_UPTIME ]; then
			if [ -f /usr/conf/isgw.conf ]; then
				cat /usr/conf/isgw.conf|grep "experimental_options.*oops_reboot_disabled=1"
				if [ $? = 0 ]; then
					OOPS_REBOOT_ALLOWED=0
				fi
			fi

			if [ $OOPS_REBOOT_ALLOWED = 1 ]; then
				reboot
			fi
		fi
	fi

}

log_info()
{
	echo -e "\n#######" "$1:" >> $file
	eval $1 >> $file
}

#### // MAIN \\ ####

#### CLOUD SBC
if [ "$($UNAME -m)" = "x86_64" ]; then

	LIST_COMMANDS=("top -n 1" "date" "uptime" "free" "ps -aux" "df" "df -h" "uname -a" "cat /etc/lsb-release" "cat /proc/meminfo" "cat /proc/cmdline" "cat /proc/interrupts" "cat /etc/resolv.conf" "lsmod" "ifconfig" "ifconfig -a" "iptables -L -n -v" "iptables -L -t nat -n -v" "netstat -na" "route -n" "systemctl list-units --type=service --state=running" "dmesg")
	for cmd in "${LIST_COMMANDS[@]}"; do
		log_info "$cmd"
	done

	pid=$(ps aux|grep isgw|grep conf|grep -v time|awk '{print $1}'|head -1);
	[[ -n "$pid" ]] && log_info "ls -l /proc/$pid/fd/"

#### STANDARD SBC
else 

	gather_dmesg

	log_info "cat /usr/local/FILENAME"
	log_info "echo q | top"
	log_info "date"
	log_info "uptime"
	log_info "free"
	log_info "ps aux"
	log_info "df"
	log_info "df -h"
	# log_info "dmesg"
	log_info "cat /sys/class/beronet/li*/module"
	log_info "cat /sys/class/beronet/li*/connector"
	log_info "cat /proc/meminfo"
	log_info "cat /proc/cmdline"
	log_info "cat /sys/class/beronet/fpga/version"
	log_info "cat /proc/interrupts"
	log_info "cat /proc/l1_stats"
	log_info "cat /proc/l2_stats"
	log_info "cat /etc/resolv.conf"
	log_info "lsmod"
	log_info "ifconfig"
	log_info "ifconfig -a"
	log_info "iptables -L -n -v"
	log_info "iptables -L -t nat -n -v"
	log_info "netstat -na"
	log_info "route -n"
	log_info "cat $KERNEL_PATCHLEVEL_FILE"
	pid=$(ps aux|grep isgw|grep conf|grep -v time|awk '{print $1}'|head -1);
	[[ -n "$pid" ]] && log_info "ls -l /proc/$pid/fd/"

fi
