#!/bin/bash

## if permanent remote support has been enabled
## this script regularily checks if an active remote support session is active
## and if not tries to restart it


INTERVAL=120

while true; do
	n=`beroconf get ari:key_val permanent_remote_support_active`
	if [ $n == 1 ]; then
		# check if an ssh session is still running
		ps aux|grep ssh|grep "StrictHostKeyChecking=no" &> /dev/null
		if [ $? != 0 ]; then
			# we have to restart it
			beroconf get ari:key_val permanent_remote_support_key > /tmp/key
			cmd=`beroconf get ari:key_val permanent_remote_support_cmd`
			key=`cat /tmp/key`
			
			echo $key|grep failed &> /dev/null
			ret1=$?
			echo $cmd|grep failed &> /dev/null
			ret2=$?
			
			if [[ $ret1 != 0 && $ret2 != 0 ]]; then
				chmod 600 /tmp/key
				/sbin/$cmd
			fi
		fi
	fi
	sleep $INTERVAL
done
