#!/usr/bin/php
<?php

require_once ('/usr/local/www/berogui/includes/isgwtelnet.php');
include_once ("/usr/www/include/SQLite2ToSQLite3.php");
include "/usr/local/www/berogui/misc/database.php";

class isgw_isdn_port {
	public $m_port = 0;
	public $m_type;
	public $m_ptppmp;
	public $m_layer2_state;
	public $m_layer1_state;
	public $m_blocked;

	
	public $m_l1_crc = 0;
	public $m_l1_crc_last_sent = 0;
}

class sip_peer {
	public $m_index;
	public $m_name;
	public $m_do_register;
	public $m_registration_state;
	public $m_registration_sip_status_code;
	public $m_do_validate;
	public $m_validation_state;
	public $m_validation_sip_status_code;
}



class snmp_traps_tool {
	public $m_isgwtelnet;
	public $m_snmp_config;
	public $m_isdn_ports;
	public $m_sip_peers;
	public $m_handle_sip = 0;
	public $m_handle_isdn = 0;

	public $m_syscheck_counter = -1;

	public function __construct () {

		$this->m_snmp_config = new snmp_config ();
		$this->m_isgwtelnet = new isgwtelnet ();

		//for system watch
		$this->m_got_port_config_from_isgw = 0;
		$this->m_cpu_load_reached = 0;
		$this->m_memory_threshold_reached = 0;
		
		
		if ($this->m_snmp_config->m_sip_registration_check || $this->m_snmp_config->m_sip_validation_check) {
			$this->m_handle_sip = 1;
		}
		if ($this->m_snmp_config->m_isdn_layer1_check || $this->m_snmp_config->m_isdn_layer2_check) {
			$this->m_handle_isdn = 1;
		}
	}
	
	function send_layer_trap ($port, $layer, $state) {

		$command = $this->m_snmp_config->get_snmptrap_base_command ();
		
		if ($state == 1) {
			$up = 1;
			$down = 0;
		}
		else {
			$up = 0;
			$down = 1;
		}
		
		if ($layer == 1) {
			$command .= " berofixNotificationsGroupIsdnL1  ISDN-L1Port i " . $port . " ISDN-L1Up i " . $up . " ISDN-L1Down i " . $down;
		}
		else {
			$command .= " berofixNotificationsGroupIsdnL2  ISDN-L2Port i " . $port . " ISDN-L2Up i " . $up . " ISDN-L2Down i " . $down;
		}
		echo "Running isdn layer trap: " . $command . "\n";
		exec ($command);
	}

	function send_registration_validation_trap ($peer_index, $peer_name, $register_state, $register_sip_status, $validation_state, $validation_sip_status) {

		$command = $this->m_snmp_config->get_snmptrap_base_command ();
		$command .= "berofixNotificationsGroupSIP " . "SIP-Peer-Index c " . $peer_index . " SIP-Peer-Name s " . $peer_name . " SIP-Peer-Register-State s " . $register_state .  " SIP-Peer-Register-Sip-Status-Code i " . $register_sip_status
		. " SIP-Peer-Validation-State s " . $validation_state .  " SIP-Peer-Validation-Sip-Status-Code i " . $validation_sip_status;
		
		echo "Running sipreg trap: " . $command . "\n";
		exec ($command);
	}

	function handle_isgw_message ($line) {

// 		echo "HANDLEISGW: " . $line . "\n";
		
		if (strncmp ($line, "SNMP:", 5) == 0) {
			if (strcmp ($line, "SNMP:SIP_RELOAD") == 0) {
				//OPTIONAL: send a reload notification
				//$reload_state = explode (":", $line);
				//if (sizeof ($reload_state) == 3) {
				//maybe clear the sip array
				//}
				//$this->print_settings ();
				return;
			}
			if (strncmp ($line, "SNMP:ISDN_LAYER", 14) == 0) {
				if ($this->m_handle_isdn) {
					$isdn_infos = explode (":", $line);
					if (sizeof ($isdn_infos) == 5) {
						
						$isdn_port = $isdn_infos[3];
						$isdn_layer = $isdn_infos[2];
						$isdn_layer_state = $isdn_infos[4];
						
						if ($isdn_layer == 1) {
							if ($this->m_snmp_config->m_isdn_layer1_check) {
								if ($isdn_layer_state != $this->m_isdn_ports[$isdn_port]->m_layer1_state) {
									$this->send_layer_trap ($isdn_port, $isdn_layer, $isdn_layer_state);
								}
								$this->m_isdn_ports[$isdn_port]->m_layer1_state = $isdn_layer_state;
							}
						}
						
						if ($isdn_layer == 2) {
							if ($this->m_snmp_config->m_isdn_layer2_check) {
								if ($isdn_layer_state != $this->m_isdn_ports[$isdn_port]->m_layer2_state) {
									$this->send_layer_trap ($isdn_port, $isdn_layer, $isdn_layer_state);
								}
								$this->m_isdn_ports[$isdn_port]->m_layer2_state = $isdn_layer_state;
							}
						}
					}
				}
				return;
			}
			if (strncmp ($line, "SNMP:SIP_REGVAL", 15) == 0) {
				if ($this->m_handle_sip) {
					
					$register_status_changed = 0;
					$validation_status_changed = 0;
					
					$sip_infos = explode (":", $line);
					$index = $sip_infos[2];
					$name = $sip_infos[3];
					$do_register = $sip_infos[4];
					$registration_state = $sip_infos[5];
					$registration_status_code = $sip_infos[6];
					$do_validate = $sip_infos[7];
					$validation_state = $sip_infos[8];
					$validation_status_code = $sip_infos[9];
					
// 					echo "idx " . $index . " regstatenow " . $registration_state . " regold " . $this->m_sip_peers[$index]->m_registration_state . "\n";
					
					if ($do_register == 0) {
						if ($this->m_sip_peers[$index]->m_registration_state != "REGISTRATION_DISABLED") {
							$register_status_changed = 1;
						}
						$this->m_sip_peers[$index]->m_registration_state = "REGISTRATION_DISABLED";
						$this->m_sip_peers[$index]->m_registration_sip_status_code = 0;
					}
					else {
						if ($this->m_sip_peers[$index]->m_registration_state == "REGISTERED") {
							if ($registration_state == "SM_SIP_REGISTRATION_FAILED" || $registration_state == "SM_SIP_REGISTRATION_UNREGISTERED") {
								$this->m_sip_peers[$index]->m_registration_state = "UNREGISTERED";
								$register_status_changed = 1;
							}
							else if ($registration_state == "SM_UNKNOWN") {
								$this->m_sip_peers[$index]->m_registration_state == "INITIALIZING";
								$register_status_changed = 1;
							}
						}
						else if ($this->m_sip_peers[$index]->m_registration_state == "UNREGISTERED") {
							if ($registration_state == "SM_SIP_REGISTRATION_SUCCESSFUL") {
								$register_status_changed = 1;
								$this->m_sip_peers[$index]->m_registration_state = "REGISTERED";
							}
							else if ($registration_state == "SM_UNKNOWN") {
								$this->m_sip_peers[$index]->m_registration_state == "INITIALIZING";
								$register_status_changed = 1;
							}
							
						}
						else if ($this->m_sip_peers[$index]->m_registration_state == "INITIALIZING") {
							if ($registration_state == "SM_SIP_REGISTRATION_SUCCESSFUL") {
								$register_status_changed = 1;
								$this->m_sip_peers[$index]->m_registration_state = "REGISTERED";
							}
							else if ($registration_state == "SM_SIP_REGISTRATION_UNREGISTERED" || $registration_state == "SM_SIP_REGISTRATION_FAILED") {
								$this->m_sip_peers[$index]->m_registration_state = "UNREGISTERED";
								$register_status_changed = 1;
							}
						}
						else {
							if ($registration_state == "SM_SIP_REGISTRATION_FAILED" || $registration_state == "SM_SIP_REGISTRATION_UNREGISTERED") {
								$register_status_changed = 1;
								$this->m_sip_peers[$index]->m_registration_state = "UNREGISTERED";
							}
							else if ($registration_state == "SM_SIP_REGISTRATION_SUCCESSFUL") {
								$register_status_changed = 1;
								$this->m_sip_peers[$index]->m_registration_state = "REGISTERED";
							}
							else if ($registration_state == "SM_UNKNOWN") {
								$this->m_sip_peers[$index]->m_registration_state == "INITIALIZING";
								$register_status_changed = 1;
							}
							
						}
						$this->m_sip_peers[$index]->m_registration_sip_status_code = $registration_status_code;
					}
					
					if ($do_validate == 0) {
						if ($this->m_sip_peers[$index]->m_validation_state != "VALIDATION_DISABLED") {
							$validation_status_changed = 1;
						}
						$this->m_sip_peers[$index]->m_validation_state = "VALIDATION_DISABLED";
						$this->m_sip_peers[$index]->m_validation_sip_status_code = 0;
					}
					else {
						if ($validation_state != $this->m_sip_peers[$index]->m_validation_state) {
							$this->m_sip_peers[$index]->m_validation_state = $validation_state;
							$this->m_sip_peers[$index]->m_validation_sip_status_code = $validation_status_code;
							$validation_status_changed = 1;
						}
					}
					
					// update sip peer in list
					$this->m_sip_peers[$index]->m_index = $index;
					$this->m_sip_peers[$index]->m_name = $name;
					
					
					if ($register_status_changed && $this->m_snmp_config->m_sip_registration_check) {
						$this->send_registration_validation_trap ($index, $name, $this->m_sip_peers[$index]->m_registration_state, $this->m_sip_peers[$index]->m_registration_sip_status_code, $this->m_sip_peers[$index]->m_validation_state, $this->m_sip_peers[$index]->m_validation_sip_status_code);
					}
					else if ($validation_status_changed && $this->m_snmp_config->m_sip_validation_check) {
						$this->send_registration_validation_trap ($this->m_sip_peers[$index]->m_index, $this->m_sip_peers[$index]->m_name, $this->m_sip_peers[$index]->m_registration_state, $this->m_sip_peers[$index]->m_registration_sip_status_code, $this->m_sip_peers[$index]->m_validation_state, $this->m_sip_peers[$index]->m_validation_sip_status_code);
					}
				}
				return;
			}
		}
		// initial info of sip peers
		else if (strncmp ($line, "SIP_INFO:", 8) == 0) {
			if ($this->m_handle_sip) {
				// echo "HANDLE SIP\n";
				$sip_infos = explode (":", $line);
				
				$sip_peer = new sip_peer ();
				$sip_peer->m_index = $sip_infos[1];
				$sip_peer->m_name = $sip_infos[2];
				
				$sip_peer->m_do_register = $sip_infos[3];
				
				if ($sip_peer->m_do_register == 0) {
					$sip_peer->m_registration_state = "REGISTRATION_DISABLED";
					$sip_peer->m_registration_sip_status_code = 0;
				}
				else {
					if ($sip_infos[4] == "SM_SIP_REGISTRATION_SUCCESSFUL") {
						$sip_peer->m_registration_state = "REGISTERED";
					}
					else if ($sip_infos[4] == "SM_SIP_REGISTRATION_FAILED") {
						$sip_peer->m_registration_state = "UNREGISTERED";
					}
					else if ($sip_infos[4] == "SM_UNKNOWN") {
						$sip_peer->m_registration_state = "INITIALIZING";
					}
					else {
						$sip_peer->m_registration_state = "UNKNOWN";
					}
					$sip_peer->m_registration_sip_status_code = $sip_infos[5];
				}
				
				$sip_peer->m_do_validate = $sip_infos[6];
				if ($sip_peer->m_do_validate == 0) {
					$sip_peer->m_validation_state = "VALIDATION_DISABLED";
					$sip_peer->m_validation_sip_status_code = 0;
				}
				else {
					$sip_peer->m_validation_state = $sip_infos[7];
					$sip_peer->m_validation_sip_status_code = $sip_infos[8];
					$this->m_sip_peers[$sip_peer->m_index] = $sip_peer;
				}
				$this->send_registration_validation_trap ($sip_peer->m_index, $sip_peer->m_name, $sip_peer->m_registration_state, $sip_peer->m_registration_sip_status_code, $sip_peer->m_validation_state, $sip_peer->m_validation_sip_status_code);
			}
		}
		else if (strncmp ($line, "ISDNINFO:", 8) == 0) {
			$isdn_infos = explode (":", $line);
			// print_r ($isdn_infos);
			
			if (sizeof ($isdn_infos) == 7) {
				$isdn_port = new isgw_isdn_port ();
				
				$isdn_port->m_port = $isdn_infos[1];
				$isdn_port->m_type = $isdn_infos[2];
				$isdn_port->m_ptppmp = $isdn_infos[3];
				
				$isdn_port->m_layer2_state = $isdn_infos[4];
				$isdn_port->m_layer1_state = $isdn_infos[5];
				// shall we send a trap on startup?
				if (1) {
					$this->send_layer_trap ($isdn_port->m_port, 2, $isdn_port->m_layer2_state);
					$this->send_layer_trap ($isdn_port->m_port, 1, $isdn_port->m_layer1_state);
				}
				
				$isdn_port->m_blocked = $isdn_infos[6];
				
				$this->m_isdn_ports[$isdn_port->m_port] = $isdn_port;
				$this->m_got_port_config_from_isgw = 1;
				$this->m_syscheck_counter = -2;
			}
		}
	}


	function syscheck_sleep ($sleep_time) {
	
		for ($i = 0; $i < $sleep_time; $i++) {
			sleep (1);
			$this->check_system ();
		}
	}

	
	function watch_traps () {
		
		while (true) {
			$retry_interval = 10;
			
			echo "Connecting to isgw!\n";
			if (! ($this->m_isgwtelnet->isgw_login ())) {
				echo "Cannot connect to isgw!\n";
				
				$this->syscheck_sleep ($retry_interval - 1);
				
				continue;
			}
			
			//check system after connect
			$this->check_system ();
			
			// clear arrays on new connect
			$this->m_isdn_ports = array ();
			$this->m_sip_peers = array ();
			
			fputs ($this->m_isgwtelnet->mysocket, "rr;ii;snmplog;");
			stream_set_timeout ($this->m_isgwtelnet->mysocket, 1);
			
			do {
				$line = fgets ($this->m_isgwtelnet->mysocket, 4096);
				$info = stream_get_meta_data($this->m_isgwtelnet->mysocket);
				
				if (feof ($this->m_isgwtelnet->mysocket)) {
					echo "Lost connection to isgw!\n";
					break;
				}
				else {
					$line = trim ($line);
					if (strlen ($line) == 0) {
						
						if (!$info['timed_out']) {
							sleep (1);
						}
						else {
							$this->check_system ();
						}
						continue;
					}
					$this->handle_isgw_message ($line);
				}

			}
			while (true);
			
			$this->syscheck_sleep ($retry_interval);
		}
	}

	
	
	function check_system ($force = 0) {

		if (! ($force == 1 || $this->m_syscheck_counter % $this->m_snmp_config->m_interval == 0)) {
			$this->m_syscheck_counter++;
			return;
		}
		else {
			$this->m_syscheck_counter++;
			
		}
		
		// ISDN crc
		if ($this->m_snmp_config->m_isdn_crc_check && $this->m_got_port_config_from_isgw) {
			$isdn_proc_l1stats = array ();
			$l1_file = '/proc/l1_stats';
// 			$l1_file = '/tmp/l1_stats';
			if (file_exists ($l1_file)) {
				foreach (file ($l1_file) as $value) {
					foreach (explode (';', $value) as $fields) {
						
						$subfields = explode ('=', $fields);
// 							$crc = - 1;	
						switch ($subfields[0]) {
							case 'port' :
								$port = $subfields[1];
								break;
							case 'crc' :
// 									$crc = $subfields[1];
								$isdn_proc_l1stats[$port] = $subfields[1];
								break;
						}
					}
				}
			}
			foreach ($this->m_isdn_ports as &$isdn_port) {
				$port = $isdn_port->m_port;
				$current_crc = $isdn_proc_l1stats[$port];
				$last_crc = $isdn_port->m_l1_crc_last_sent;
				
				if ($current_crc >= $last_crc + $this->m_snmp_config->m_isdn_crc_value) {
					$this->send_isdn_crc_trap ($port, $current_crc);
					$isdn_port->m_l1_crc_last_sent = $current_crc;
				}
			}
		}

			// memory threshold
		if ($this->m_snmp_config->m_memory_threshold_check) {
			$meminfo = '/proc/meminfo';
			$total_free_mem = 0;
			$total_mem = 0;
			$isgw_mem = 0;
			
			foreach (file ($meminfo) as $line) {
				if (strncmp ($line, "MemTotal:", 8) == 0) {
					$line = preg_replace ('/  */', ' ', $line);
					$fields = explode (" ", $line);
					$total_mem += $fields[1];
				}
				else if (strncmp ($line, "MemFree:", 7) == 0) {
					$line = preg_replace ('/  */', ' ', $line);
					$fields = explode (" ", $line);
					$total_free_mem += $fields[1];
				}
				else if (strncmp ($line, "Cached:", 7) == 0) {
					$line = preg_replace ('/  */', ' ', $line);
					$fields = explode (" ", $line);
					$total_free_mem += $fields[1];
					break;
				}
			}
			if (file_exists ("/var/run/isgw.pid")) {
				
				$isgw_pid = @file_get_contents("/var/run/isgw.pid");
				$isgw_pid = trim ($isgw_pid);
				$status_file = "/proc/" . $isgw_pid .  "/status";
				if (file_exists ($status_file)) {
					foreach (file ($status_file) as $line) {
						
						if (strncmp ($line, "VmRSS:" , 5) == 0) {
							$line = preg_replace ('/  */', ' ', $line);
							$fields = explode (" ", $line);
							$isgw_mem = $fields[1];
							break;
						}
					}
				}
			}
			
			if ($total_free_mem < $this->m_snmp_config->m_memory_threshold_value && $this->m_memory_threshold_reached == 0) {
				$this->m_memory_threshold_reached = 1;
				$this->send_memory_threshold_trap ($total_mem, $total_free_mem, $isgw_mem);
			}
			else if ($total_free_mem > $this->m_snmp_config->m_memory_threshold_value && $this->m_memory_threshold_reached == 1) {
				$this->m_memory_threshold_reached = 0;
				$this->send_memory_threshold_trap ($total_mem, $total_free_mem, $isgw_mem);
			}
		}
		// cpu load, we check for 5 minute value
		if ($this->m_snmp_config->m_cpu_load_check) {
			$loadavg = '/proc/loadavg';
			$load1_in_percent = 1000;
			$load5_in_percent = 1000;
			$load15_in_percent = 1000;
			foreach (file ($loadavg) as $line) {
				if (strlen ($line)) {
					$fields = explode (" ", $line);
					if (sizeof ($fields) == 5) {
						$load1_in_percent = $fields[0] * 100;
						$load5_in_percent = $fields[1] * 100;
						$load15_in_percent = $fields[2] * 100;
						break;
					}
				}
			}
			if ($load5_in_percent > $this->m_snmp_config->m_cpu_load_value && $this->m_cpu_load_reached == 0) {
				$this->m_cpu_load_reached = 1;
				$this->send_cpu_load_trap ($load1_in_percent, $load5_in_percent, $load15_in_percent);
			}
			else if ($load5_in_percent <= $this->m_snmp_config->m_cpu_load_value && $this->m_cpu_load_reached == 1) {
				$this->m_cpu_load_reached = 0;
				$this->send_cpu_load_trap ($load1_in_percent, $load5_in_percent, $load15_in_percent);
			}
		}
	}
	
	function send_isdn_crc_trap ($port, $crc) {

		$command = $this->m_snmp_config->get_snmptrap_base_command ();
		$command .= "berofixNotificationsGroupStatISDN berofixL1Port.0 i " . $port . " berofixL1CRC.0 c " . $crc;

		echo "Running isdn crc trap: " . $command . "\n";
		exec ($command);
	}

	function send_cpu_load_trap ($load1_in_percent, $load5_in_percent, $load15_in_percent) {

		$command = $this->m_snmp_config->get_snmptrap_base_command ();
		$command .= "berofixNotificationsGroupCPU berofixCPUusage1.0 i " . $load1_in_percent . " berofixCPUusage5.0 i " . $load5_in_percent . " berofixCPUusage15.0 i " . $load15_in_percent;

		echo "Running cpu_load trap: " . $command . "\n";
		exec ($command);
	}

	function send_memory_threshold_trap ($total_memory, $free_memory, $isgw_memory) {

		$command = $this->m_snmp_config->get_snmptrap_base_command ();
		$command .= "berofixNotificationsGroupRAM berofixRAMtotal.0 c " . $total_memory . " berofixRAMfree.0 c " . $free_memory . " berofixRAMisgw.0 c " . $isgw_memory;

		echo "Running memory threshold trap: " . $command . "\n";
		exec ($command);
	}
	
	
	function print_settings () {

		echo "SNMP Settings " . "\n";
		$this->m_snmp_config->snmp_print_settings ();
		$this->m_snmp_config->snmp_print_isgw_traps ();
		$this->m_snmp_config->snmp_print_system_traps ();
		echo "ISDN: " . "\n";
		foreach ($this->m_isdn_ports as &$portinfo) {
			echo "ISDN Port: " . $portinfo->m_port . " L2State: " . $portinfo->m_layer2_state . " L1State: " . $portinfo->m_layer1_state . " type " . $portinfo->m_type . " ptpmp " . $portinfo->m_ptppmp . "\n";
		}
		echo "SIP: " . "\n";
		foreach ($this->m_sip_peers as &$sip_peer) {
			echo $sip_peer->m_name . " " . $sip_peer->m_do_register . " " . $sip_peer->m_do_validate . "\n";
		}
	}
}

class snmp_config {
	public $m_snmp_version;
	public $m_trap_server;
	
	// v2
	public $m_snmptraps_community;
	
	// v3 usm
	
	// trap settings
	public $m_interval;
	// isgw traps
	public $m_sip_validation_check = 0;
	public $m_sip_registration_check = 0;
	public $m_isdn_layer1_check = 0;
	public $m_isdn_layer2_check = 0;
	
	// system traps
	public $m_isdn_crc_check = 0;
	public $m_isdn_crc_value = 201;
	public $m_memory_threshold_check = 0;
	public $m_memory_threshold_value = 1001;
	public $m_cpu_load_check = 0;
	public $m_cpu_load_value = 151;

	public function __construct () {

		$bc = new beroConf ('root');
		$this->m_snmp_version = $bc->get ('root', 'snmp-version');
		$this->m_trap_server = $bc->get ('root', 'snmptraps_server');
		
		$this->m_sip_validation_check = 0;
		$this->m_sip_registration_check = 0;
		$this->m_isdn_layer1_check = 0;
		$this->m_isdn_layer2_check = 0;
		
		$this->m_interval = $bc->get ('root', 'snmptraps_interval');
		if ($this->m_interval < 10) {
			$this->m_interval = 10;
		}
		
		$this->m_isdn_crc_check = 0;
		$this->m_isdn_crc_value = 202;
		
		$this->m_cpu_load_check = 0;
		$this->m_cpu_load_value = 152;
		
		$this->m_memory_threshold_check = 0;
		$this->m_memory_threshold_value = 1002;
		
		if ($this->m_snmp_version == "SNMPv2") {
			
			$this->m_snmptraps_community = $bc->get ('root', 'snmptraps_community');
			if (strlen ($this->m_snmptraps_community) == 0) {
				$this->m_snmptraps_community = "public";
			}
		}
		else if ($this->m_snmp_version == "SNMPv3_usm") {
			
			$this->m_snmptraps_user = $bc->get ('root', 'snmptraps_user');
			$this->m_snmptraps_auth_method = $bc->get ('root', 'snmptraps_auth_method');
			$this->m_snmptraps_auth_password = $bc->get ('root', 'snmptraps_auth_password');
			
			$this->m_snmptraps_encrypt_method = $bc->get ('root', 'snmptraps_encrypt_method');
			$this->m_snmptraps_encrypt_password = $bc->get ('root', 'snmptraps_encrypt_password');
			$this->m_snmptraps_security_level = $bc->get ('root', 'snmptraps_security_level');
		}
		else if ($this->m_snmp_version == "SNMPv3_tsm") {
		}
		
		// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$traplist = $bc->get ('root', 'snmptraps_traplist');
		$traps = explode (",", $traplist);
		foreach ($traps as $active_trap) {
			if ($active_trap == "sip_validation") {
				$this->m_sip_validation_check = 1;
			}
			else if ($active_trap == "sip_registration") {
				$this->m_sip_registration_check = 1;
			}
			else if ($active_trap == "isdn_layer1") {
				$this->m_isdn_layer1_check = 1;
			}
			else if ($active_trap == "isdn_layer2") {
				$this->m_isdn_layer2_check = 1;
			}
			else if ($active_trap == "memory_threshold") {
				$this->m_memory_threshold_check = 1;
				$this->m_memory_threshold_value = $bc->get ('root', 'snmptraps_memory_threshold');
			}
			else if ($active_trap == "cpu_load") {
				$this->m_cpu_load_check = 1;
				$this->m_cpu_load_value = $bc->get ('root', 'snmptraps_cpu_load');
			}
			else if ($active_trap == "isdn_crc") {
				$this->m_isdn_crc_check = 1;
				$this->m_isdn_crc_value = $bc->get ('root', 'snmptraps_isdn_crc');
			}
		}
		unset ($bc);
		
			$this->m_engine_id = "0x8000000000000001";
			if (file_exists ("/sys/class/net/eth0/address")) {
				$this->m_engine_id = @file_get_contents ("/sys/class/net/eth0/address");
				$this->m_engine_id = trim ($this->m_engine_id);
				$this->m_engine_id = preg_replace ('/::*/', '', $this->m_engine_id);
				$this->m_engine_id = "0x8000" . $this->m_engine_id;
			}
		
// 		$this->snmp_print_settings();
	}

	function get_snmptrap_base_command () {

		if ($this->m_snmp_version == "SNMPv2") {
			
			$ret = "/usr/local/bin/snmptrap -M /usr/local/conf -m BEROFIX-MIB -v 2c -c " . $this->m_snmptraps_community . " " . $this->m_trap_server . " 0 ";
			return $ret;
		}
		else if ($this->m_snmp_version == "SNMPv3_usm") {
			
			// do we need to delete this file, sometimes every second command will fail
// 			if (file_exists ("/usr/conf/snmpapp.conf")) {
// 				unlink ("/usr/conf/snmpapp.conf");
// 			}
			
			$ret = "/usr/local/bin/snmptrap -M /usr/local/conf -m BEROFIX-MIB -v3 -e " . $this->m_engine_id . " -u " . $this->m_snmptraps_user . " ";
			if ($this->m_snmptraps_security_level == "NoAuthNoPriv") {
				$ret .= " -l NoAuthNoPriv ";
			}
			else if ($this->m_snmptraps_security_level == "AuthNoPriv") {
				$ret .= " -l AuthNoPriv ";
				$ret .= " -a  " . $this->m_snmptraps_auth_method;
				$ret .= " -A  " . $this->m_snmptraps_auth_password;
			}
			else {
				$ret .= " -l AuthPriv ";
				$ret .= " -a  " . $this->m_snmptraps_auth_method;
				$ret .= " -A  " . $this->m_snmptraps_auth_password;
				$ret .= " -x  " . $this->m_snmptraps_encrypt_method;
				$ret .= " -X  " . $this->m_snmptraps_encrypt_password;
			}
			$ret .= " " . $this->m_trap_server . " 0 ";
			return $ret;
		}
		else if ($this->m_snmp_version == "SNMPv3_usm") {
			// TODO: implement and test
			return "/bin/echo /usr/local/bin/snmptrap ";
		}
	}
	
	function snmp_print_settings () {

		echo "snmp-version: " . $this->m_snmp_version . "\n";
		echo "snmptraps_server: " . $this->m_trap_server . "\n";
		echo "snmptraps_interval: " . $this->m_interval . "\n";
		
		if ($this->snmp_version == "SNMPv2") {
			echo "snmptraps_community: " . $this->snmptraps_community . "\n";
		}
		if ($this->m_snmp_version == "SNMPv3_usm") {
			echo "snmptraps_user: " . $this->m_snmptraps_user . "\n";
			echo "snmptraps_auth_method: " . $this->m_snmptraps_auth_method . "\n";
			echo "snmptraps_auth_password: " . $this->m_snmptraps_auth_password . "\n";
			echo "snmptraps_encrypt_method: " . $this->m_snmptraps_encrypt_method . "\n";
			echo "snmptraps_encrypt_password: " . $this->m_snmptraps_encrypt_password . "\n";
			echo "snmptraps_security_level: " . $this->m_snmptraps_security_level . "\n";
		}
	}

	function snmp_print_isgw_traps () {

		echo "SIP_VALIDATION: " . $this->m_sip_validation_check . "\n";
		echo "SIP_REGISTRATION: " . $this->m_sip_registration_check . "\n";
		echo "ISDN_LAYER1: " . $this->m_isdn_layer1_check . "\n";
		echo "ISDN_LAYER2: " . $this->m_isdn_layer2_check . "\n";
	}

	function snmp_print_system_traps () {

		echo "ISDN CRC: " . $this->m_isdn_crc_check . "\n";
		echo "ISDN_CRC_VALUE: " . $this->m_isdn_crc_value . "\n";
		echo "MEMORY THRESHOLD: " . $this->m_memory_threshold_check . "\n";
		echo "MEMORY THRESHOLD VALUE: " . $this->m_memory_threshold_value . "\n";
		echo "CPU LOAD: " . $this->m_cpu_load_check . "\n";
		echo "CPU LOAD VALUE: " . $this->m_cpu_load_value . "\n";
	}
}

// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// / Start watcher

$traps_watcher = new snmp_traps_tool ();
if ($argv[1] == "list") {
	$traps_watcher->m_snmp_config->snmp_print_settings ();
	exit (0);
}
$traps_watcher->watch_traps ();


?>

