#!/bin/bash

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:/usr/fallback
BEROCONF=/usr/fallback/beroconf

### INTERN FUNCTIONS ###
function doClean () {
	FILE=${1}
	available=$(df | grep /dev/mtdblock5 | awk '{ print $4; }')
	if [ "${available}" -lt "250" ]; then
		echo "Cleaning RootFS"
		## cleaning unexpected files
		for file in $(find / -type f | grep -v /proc | grep -v /sys | grep -v /dev | grep -v /tmp | grep -v /usr/local | grep -v /usr/conf | grep -v /home/admin); do
			if cat $FILE | grep $file &>/dev/null ; then
				continue
			fi
			## avoid to remove /usr/bin/[
			if [ "$file" = "/usr/bin/[" ]; then
				continue
			fi
			mount -o remount,rw /
			rm $file
			mount -o remount,ro /
		done
		## update rootfs space size
		sleep 1; sync; sleep 1;
		mount -o remount,rw /
		mount -o remount,ro /
		sleep 1; sync; sleep 1;
		## check if enough space and cleaning worked
		available=$(df | grep /dev/mtdblock5 | awk '{ print $4; }')
		if [ "${available}" -lt "250" ]; then
			echo "Freeing RootFS space failed"
			exit 1
		else
			echo "Freeing RootFS space succeeded"
		fi
		## restoring libcrypto and libssl libraries
		echo "Restoring libcrypto and libssl libraries"
		if [[ ! -f /home/admin/lib/libcrypto.so ]] || [[ ! -f /home/admin/lib/libcrypto.so.1.0.0 ]]; then
			echo "libcrypto library missing. Does it a 21.X firmware ?"
			exit 1
		fi
		if [[ ! -f /home/admin/lib/libssl.so ]] || [[ ! -f /home/admin/lib/libssl.so.1.0.0 ]]; then
			echo "libssl library missing. Does it a 21.X firmware ?"
			exit 1
		fi
		## force symlink for libcrypto and libssl
		mount -o remount,rw /
		ln -sf /home/admin/lib/libcrypto.so* /usr/lib
		mount -o remount,ro /
		mount -o remount,rw /
		ln -sf /home/admin/lib/libssl.so* /usr/lib
		mount -o remount,ro /
		sleep 1; sync; sleep 1;
		## decreasing the PGK_VERSION from the VERSION.* files
		echo "Decreasing the PKG_VERSIONs"
		for file in $(ls /pkginfo/VERSION.*); do
			mount -o remount,rw /
			sed -i 's/PKG_VERSION=.*/PKG_VERSION=1/g' $file
			mount -o remount,ro /
		done
		sleep 1; sync; sleep 1;
	else
		echo "other issue. contact Damien"
	fi
}

function mvPhpToMtd5 () {
	## check if file exists and not a symlink
	if [ ! -L /usr/bin/php-cgi ]; then
		echo "php-cgi binary already moved to / space"
		${BEROCONF} set root rootfs-phpcgi-failed ROOTFS_PHPCGI_FILE_EXISTS
		return
	fi
	## check if enough space
	required=2100
	available=$(df | grep mtdblock5 | awk '{ print $4; }')
	if [ "${available}" -lt "${required}" ]; then
		diff=$(expr ${required} - ${available})
		echo "not enough free space on /. moving php-cgi failed"
		${BEROCONF} set root rootfs-phpcgi-failed RESTORING_ROOTFS_FAILED:ROOTFS_NOTENOUGH_SPACE:${diff}
		return
	fi
	## move php-cgi to mtdblock5
	mount -o remount,rw /home/admin
	mount -o remount,rw /
	rm /usr/bin/php-cgi
	if cp /home/admin/bin/php-cgi /usr/bin ; then
		rm -r /home/admin/bin
		sleep 1; sync; sleep 1
		${BEROCONF} set root rootfs-phpcgi-success RESTORING_ROOTFS_SUCCEEDED
	else
		rm /usr/bin/php-cgi
		ln -sf /home/admin/bin/php-cgi /usr/bin
		echo "not enough free space on /. At least 2.8MB required. Please contact beroNet-support"
		df | grep mtdblock 5
		${BEROCONF} set root rootfs-phpcgi-failed RESTORING_ROOTFS_FAILED:ROOTFS_NOTENOUGH_SPACE
	fi
	mount -o remount,ro /
	mount -o remount,ro /home/admin
}

function mvPhpToMtd7 () {
	## check if file exits
	if [ -f /home/admin/bin/php-cgi ]; then
		echo "php-cgi binary already moved to /home/admin space"
		${BEROCONF} set root rootfs-phpcgi-failed HOMEADMIN_PHPCGI_FILE_EXISTS 
		return
	fi
	## check if enough space
	required=2100
	available=$(df | grep mtdblock7 | awk '{ print $4; }')
	if [ "${available}" -lt "${required}" ]; then
		diff=$(expr ${required} - ${available})
		echo "not enough free space on /home/admin. moving php-cgi failed"
		${BEROCONF} set root rootfs-phpcgi-failed FREEING_ROOTFS_FAILED:HOMEADMIN_NOTENOUGH_SPACE:${diff}
		return
	fi
	## move php-cgi to mtdblock7
	mount -o remount,rw /home/admin
	mkdir -p /home/admin/bin
	mount -o remount,rw /
	if cp /usr/bin/php-cgi /home/admin/bin ; then
		rm /usr/bin/php-cgi
		sleep 1; sync; sleep 1
		ln -sf /home/admin/bin/php-cgi /usr/bin
		${BEROCONF} set root rootfs-phpcgi-success FREEING_ROOTFS_SUCCEEDED
	else
		rm /home/admin/bin
		echo "not enough free space on /home/admin. At least 2.8MB required. Please clean your /home/admin space"
		df | grep mtdblock7
		${BEROCONF} set root rootfs-phpcgi-failed FREEING_ROOTFS_FAILED:HOMEADMIN_NOTENOUGH_SPACE
	fi
	mount -o remount,ro /
	mount -o remount,ro /home/admin
}

### MAIN ####
case ${1} in
	clean)
		FILE=$2
		[ -z $FILE ] && { echo "missing argument"; exit 0; }
		[ ! "$FILE" = "rootfs.files_list" ] && { echo "filename does not match the expected one"; exit 0; }
		[ ! -f $FILE ] && { echo "rootfs.files_list missing"; exit 0; }
		doClean $FILE
		;;
	phpMtd5)
		mvPhpToMtd5
		;;
	phpMtd7)
		mvPhpToMtd7
		;;
	*)
		echo "Usage: ${0} [clean|phpMtd5|phpMtd7] [options]"
		echo "       clean: options=rootfs.file_list required. Will remove unwanted files from the rootfs space"
		echo "       phpMtd5: no options required. Will move the php-cgi binary from mtdblock7 (/home/admin) to mtdblock5 (/) space"
		echo "       phpMtd7: no options required. Will move the php-cgi binary from mtdblock5 (/) to mtdblock7 (/home/admin) space"
		echo ""
		;;
esac

exit 0
