#!/bin/bash
#
# This script is executed only once, just before the app partition
# will be erased (/usr/local).
#

APPFS_TO_INSTALL=${1}
if [ -z ${APPFS_TO_INSTALL} ]; then
	APPFS_TO_INSTALL=1
fi

# we re-install all rootfs-packages from appfs3 or younger
if [ ${APPFS_TO_INSTALL} -le 3 ]; then
	# as we remove /pkginfo it's better to set boot_fwupdate to 0 now
	/usr/fallback/beroconf set root boot_fwupdate 0

	# removing rootfs-stuff that would come in our downgrade-way
	mount -oremount,rw /
	rm -rf /pkginfo
	rm -f /etc/init.d/S30berofix-fpga
	rm -f /lib/modules/berofix-fpga.ko
	mount -oremount,ro /
fi
