<?php

require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");

// TODO: using GUI-Class would avoid to check if the class exists
if (!class_exists('beroAri')) {
	require_once('/usr/local/www/berogui/misc/database.php');
}

/**
 * Implementiert hilfreiche Funktionen die überall benutzt werden können
 * @author Miguel Palmer <mp@beronet.com>
 * @author Florian Kraatz <fk@beronet.com>
 */
class Helper {

	/**
	 * Gateway neustarten
	 */
	public static function reboot($url, $apicall=false) {
		/* rck wird ausgeführt, wenn rck nach 10 Sekunden
		 * nicht richtig beendet wurde, wird rcK gestoppt und die Karte wird
		 * neugestartet. Per AJAX wird geprüft ob die Karte wieder UP ist, die
		 * Loginseite wird dann wieder angezeigt.
		 */
		$handle = popen('/bin/sh /etc/init.d/rcK', 'r');
		$i = 0;
		while (!feof($handle) && $i++ != 10) {
			sleep(1);
		}
		pclose($handle);
		if (!$apicall) {
			print("<script type='text/javascript'>
				window.setTimeout('setRequest()',7000);
		                </script>");
			flush();
		}
		exec('/usr/bin/killall rcK');
		`/sbin/reboot -d5 >> /dev/null &`;
	}

	/**
	 *  Funktion für das Löschen eines Moduls und der entsprechenden Dialplaneinträge,
	 * wenn die Belegung der Line Interfaces sich ändert
	 */
	public static function deleteModul($li, $name, $table) {
			// FUNCTION NEVER USED. SHOULD BE REMODED \\
		$ba = new beroAri();


		//CAS channels und Dialplan Einträge löschen löschen.
		if ($table == "cas") {
			$query = $ba->select("select port from $table where lif='" . sqlite_escape_string($li) . "' and type='" . sqlite_escape_string($name) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$query = $ba->select("select * from cas_channels where port='" . $entry['port'] . "'");
				while ($ent = $ba->fetch_array($query)) {
					$ba->delete("delete from dialplan where fromDirection='" . sqlite_escape_string($table) . "' and fromId='g:" . $ent['gr'] . "'");
					$ba->delete("delete from dialplan where fromDirection='" . sqlite_escape_string($table) . "' and fromId='" . $ent['channel'] . "'");
					$ba->delete("delete from dialplan where toDirection='" . sqlite_escape_string($table) . "' and toId='g:" . $ent['gr'] . "'");
					$ba->delete("delete from dialplan where toDirection='" . sqlite_escape_string($table) . "' and toId='" . $ent['channel'] . "'");
				}
				$ba->delete("delete from cas_channels where port='" . $entry["port"] . "'");
			}
			//Dialplan Einträge aller anderen Technologien löschen
		} else {
			$query = $ba->select("select * from " . sqlite_escape_string($table) . " where lif='" . sqlite_escape_string($li) . "' and type='" . sqlite_escape_string($name) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$ba->delete("delete from dialplan where fromDirection='$table' and fromId='g:" . $entry['gr'] . "'");
				$ba->delete("delete from dialplan where fromDirection='$table' and fromId='" . $entry['port'] . "'");
				$ba->delete("delete from dialplan where toDirection='$table' and toId='g:" . $entry['gr'] . "'");
				$ba->delete("delete from dialplan where toDirection='$table' and toId='" . $entry['port'] . "'");
			}
		}
		$ba->delete("delete from " . sqlite_escape_string($table) . " where lif='" . sqlite_escape_string($li) . "' and type='" . sqlite_escape_string($name) . "'");


		$ba->set('portswitch', 0);

		$q = $ba->select("SELECT type, lif FROM isdn union SELECT type, lif FROM analog union SELECT type, lif FROM gsm order by lif");
		$i = 0;
		while ($ent = $ba->fetch_array($q)) {
			$lif[$i] = $ent['lif'];
			$type[$i] = $ent['type'];
			$i++;
		}

		$revision = self::getRevision();
		if (($type[0] == "bf4S0" || $type[0] == "bf2S02FXS" || $type[0] == "bf4FXS" || $type[0] == "bf4FXO") && !isset($type[1]) && $revision != "1.80" && $revision != "1.8") {
			$ba->set('portswitch', 1);
		}

		$option = $ba->get("activate");
		if ($option <= 3)
			$query = $ba->set('activate', '3');
		echo "<script>aktivieren(1,'state','3','" . ACTIVATE . "');</script>";
	}

	/**
	 * Funktion für das Löschen von Call progress tablea,
	 * wenn die Belegung der Line Interfaces sich ändert
	 */
	public static function deleteCPT($dir) {
		//echo $li.$name.$table;
		$ba = new beroAri();
		$query = $ba->select("select * from callprogress where direction='" . sqlite_escape_string($dir) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$ba->delete("delete from callprogress_entries where id_name='" . $entry['id'] . "'");
		}
		$ba->delete("delete from callprogress where direction='" . sqlite_escape_string($dir) . "'");
	}

	/**
	 *  Fügt in die Datenbank ein neues Modul hinzu
	 */
	public static function createModul($setPortSwitch = false) {

		$ba = new beroAri();

		if ($setPortSwitch == true)
			$ba->set("portswitch", 0);
		$queries_li1 = $ba->add_module_db(1, 0, 0);

		if (!empty($queries_li1)) {
			foreach ($queries_li1 as $query) {
				$ba->exec_query($query);
			}
			unset($queries_li1);
		}

		if ($ba->is_error()) {
			echo '<script>alert(\'' . $ba->error() . '\');</script>';
		}

		$option = $ba->get("activate");
		if ($option <= 3)
			$query = $ba->set('activate', '3');
	}

	public static function getIsdnPorts() {
		//TODO: optimize this function and move it to HelperPstn
		//Ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();
		//ISDN Ports suchen
		$qu = $ba->select("select port from isdn");
		$result = array();
		while ($entry = $ba->fetch_array($qu)) {
			array_push($result, $entry['port']);
		}
		return $result;
	}

	/**
	 * Generiert ein Array mit den neuesten verfügbaren Software Versionen
	 */
	public static function getAvailableFwVersion() {

		$url = 'ftp://appliance.beronet.com/beronet_gateway/firmware_3LI.list';

		if (!($lines = @file($url))) {
			return(false);
		}

		foreach ($lines as $line) {
			if (($line == "\n") || ($line[0] == '#')) {
				continue;
			}

			$tmp = explode(';', trim($line, "\n\t"));

			$ret[] = array('name' => $tmp[0]);
			break;
		}

		return($ret);
	}

	public static function getTimezoneList() {
		$timezones = array(
			'GMT-1200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'BIT',
				'std-offset'	=> '+12',
				'summer-winter' => false,
				'tz' 		=> '(GMT -12:00) Eniwetok, Kwajalein',
			),
			'GMT-1100' => array(
				'dst-abbr'	=> '',
				'sw-rules'	=> '',
				'std-abbr'	=> 'SST',
				'std-offset'	=> '+11',
				'summer-winter' => false,
				'tz' 		=> '(GMT -11:00) Midway Island, Samoa',
			),
			'GMT-1000' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'HAST',
				'std-offset'	=> '+10',
				'summer-winter' => false,
				'tz' 		=> '(GMT -10:00) Hawaii',
			),
			'GMT-0900' => array(
				'dst-abbr'	=> 'AKDT',
				'rules'		=> '',
				'std-abbr'	=> 'AKST',
				'std-offset'	=> '+9',
				'summer-winter' => false,
				'tz' 		=> '(GMT -9:00) Alaska',
			),
			'GMT-0800' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'PST',
				'std-offset'	=> '+8',
				'summer-winter' => false,
				'tz' 		=> '(GMT -8:00) Pacific Standard Time: (US &amp; Canada)',
			),
			'GMT-0700' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'MST',
				'std-offset'	=> '+7',
				'summer-winter' => false,
				'tz' 		=> '(GMT -7:00) Mountain Standard Time: (US &amp; Canada)',
			),
			'GMT-0600' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'CST',
				'std-offset'	=> '+6',
				'summer-winter' => false,
				'tz' 		=> '(GMT -6:00) Central Standard Time: Mexico City, (US &amp; Canada)',
			),
			'GMT-0500' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'EST',
				'std-offset'	=> '+5',
				'summer-winter' => false,
				'tz' 		=> '(GMT -5:00) Eastern Standard Time: Bogota, Lima, (US &amp; Canada)',
			),
			'GMT-0400' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AST',
				'std-offset'	=> '+4',
				'summer-winter' => false,
				'tz' 		=> '(GMT -4:00) Atlantic Standard Time: Caracas, La Paz, (Canada)',
			),
			'GMT-0330' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'NST',
				'std-offset'	=> '+3:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT -3:30) Newfoundland',
			),
			'GMT-0300' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'ART',
				'std-offset'	=> '+3',
				'summer-winter' => false,
				'tz' 		=> '(GMT -3:00) Brasília, Buenos Aires, Georgetown',
			),
			'GMT-0200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AT',
				'std-offset'	=> '+2',
				'summer-winter' => false,
				'tz' 		=> '(GMT -2:00) Mid-Atlantic',
			),
			'GMT-0100' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'WAT',
				'std-offset'	=> '+1',
				'summer-winter' => false,
				'tz' 		=> '(GMT -1:00) West Africa Time: Alger, Jaunde, Rabat',
			),
			'GMT0000' => array(
				'dst-abbr'	=> 'WEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'WET',
				'std-offset'	=> '+0',
				'summer-winter' => true,
				'tz' 		=> '(GMT) Western European Time: London, Lisbon, Casablanca',
			),
			'GMT+0100' => array(
				'dst-abbr'	=> 'CEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'CET',
				'std-offset'	=> '-1',
				'summer-winter' => true,
				'tz' 		=> '(GMT +1:00) Central European Time: Berlin, Brussels, Copenhagen, Madrid, Paris',
			),
			'GMT+0200' => array(
				'dst-abbr'	=> 'EEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'EET',
				'std-offset'	=> '-2',
				'summer-winter' => true,
				'tz' 		=> '(GMT +2:00) Eastern Europen Time: Athens, Bucharest, Helsinki, Sofia',
			),
			'GMT+0300' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'MSK',
				'std-offset'	=> '-3',
				'summer-winter' => false,
				'tz' 		=> '(GMT +3:00) Baghdad, Riyadh, Moscow, St. Petersburg',
			),
			'GMT+0330' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'IRST',
				'std-offset'	=> '-3:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +3:30) Tehran',
			),
			'GMT+0400' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AMT',
				'std-offset'	=> '-4',
				'summer-winter' => false,
				'tz' 		=> '(GMT +4:00) Abu Dhabi, Muscat, Baku, Tbilisi',
			),
			'GMT+0430' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AFT',
				'std-offset'	=> '-4:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +4:30) Kabul',
			),
			'GMT+0500' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'PKT',
				'std-offset'	=> '-5',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:00) Ekaterinburg, Islamabad, Karachi, Tashkent',
			),
			'GMT+0530' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'IST',
				'std-offset'	=> '-5:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:30) Bombay, Calcutta, Madras, New Delhi',
			),
			'GMT+0545' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'NT',
				'std-offset'	=> '-5:45',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:45) Kathmandu',
			),
			'GMT+0600' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'OMSK',
				'std-offset'	=> '-6',
				'summer-winter' => false,
				'tz' 		=> '(GMT +6:00) Almaty, Dhaka, Colombo',
			),
			'GMT+0700' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'KRAT',
				'std-offset'	=> '-7',
				'summer-winter' => false,
				'tz' 		=> '(GMT +7:00) Bangkok, Hanoi, Jakarta',
			),
			'GMT+0800' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'CST',
				'std-offset'	=> '-8',
				'summer-winter' => false,
				'tz' 		=> '(GMT +8:00) Beijing, Perth, Singapore, Hong Kong',
			),
			'GMT+0900' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'JST',
				'std-offset'	=> '-9',
				'summer-winter' => false,
				'tz' 		=> '(GMT +9:00) Tokyo, Seoul, Osaka, Sapporo, Yakutsk',
			),
			'GMT+0930' => array(
				'dst-abbr'	=> 'ACDT',
				'rules'		=> '',
				'std-abbr'	=> 'ACST',
				'std-offset'	=> '-9:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +9:30) Adelaide, Darwin',
			),
			'GMT+1000' => array(
				'dst-abbr'	=> 'AEDT',
				'rules'		=> '',
				'std-abbr'	=> 'AEST',
				'std-offset'	=> '-10',
				'summer-winter' => false,
				'tz' 		=> '(GMT +10:00) Eastern Australia, Guam, Vladivostok',
			),
			'GMT+1100' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'SAKT',
				'std-offset'	=> '-11',
				'summer-winter' => false,
				'tz' 		=> '(GMT +11:00) Magadan, Solomon Islands, New Caledonia',
			),
			'GMT+1200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'HST',
				'std-offset'	=> '-12',
				'summer-winter' => false,
				'tz' 		=> '(GMT +12:00) Auckland, Wellington, Fiji, Kamchatka',
			),
		);

		return $timezones;
	}

	/**
	 * Activate button anzeigen
	 */
	public static function activate($option, $show = false, $m = "", $text = "activate", $given_ba = null) {
		//Ein neues Datenbankobjekt wird erzeugt.
		$ba = is_null($given_ba) ? new beroAri() : $given_ba;
		//ISDN Ports suchen
		$optionSaved = $ba->get("activate");
		
		if (file_exists ("/usr/conf/need_red_activate")) {
			$option = "3";
			unlink ("/usr/conf/need_red_activate");
		}
		
		// check graceful_activate
		$graceful = $ba->get('graceful_action');
		if ($option <= $graceful) {
			return;
		}

		if ($optionSaved <= $option) {
			$query = $ba->set('activate', $ba->get('is_sbc_vm') == 1 ? '1' : $option);
			if ($show)
				return "<script>aktivieren(1,'" . $m . "','" . $option . "','" . $text . "','" . (isset($_GET['opt']) ? Helper::sanitizeGet($_GET['opt'], 'opt') : '') . "');</script>";
		}
	}

	/**
	 * Activate option der API speichern
	 */
	public static function activateApi($option) {
		file_put_contents("/tmp/apioption", $option);
		$ba = new beroAri();
		$ba->set('activate', $option);
	}

	/**
	 * Gibt das aktuelle activate level zurück
	 * @return int
	 */
	public static function getActivateOption() {
		$ba = new beroAri();
		return $ba->get("activate");
	}

	/**
	 * @return int Anzahl an Line interfaces
	 */
	public static function getLifCount() {
		if (file_exists('/sys/class/beronet/gateway/li_count')) {
			return(trim(file_get_contents('/sys/class/beronet/gateway/li_count')));
		}
		return null;
	}

	/**
	 * Gibt den Namen des angefragen Line interfaces zurück
	 * @param int $LifIndex
	 * @return string
	 */
	public static function getLifName($LifIndex) {
		return(file_exists(self::getLifPath() . 'li' . $LifIndex . '/module') ? trim(@file_get_contents(self::getLifPath() . 'li' . $LifIndex . '/module')) : 'none');
	}

	/**
	 * Gibt den Namen aller Line interfaces zurück
	 * @return array
	 */
	public static function getLif() {
		$li = array();
		for ($i = 0; $i < self::getLifCount(); $i++) {
			$li[$i] = self::getLifName($i);
		}
		return($li);
	}

	/**
	 * Gibt einen Pfad zurück
	 * @return string
	 */
	public static function getLifPath() {
		return (is_dir('/usr/conf/lif')) ? '/usr/conf/lif/' : '/sys/class/beronet/';
	}

	/**
	 * Return the specific FXO country setting for the given country $c
	 * @param string $c
	 * @return array
	 */
	public static function getCountrySetting($c = "1TR110_DE") {
		$country = array(
			"FCC" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 1, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"TRB21" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ARGENTINA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"AUSTRALIA" => array('ohs' => 1, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0x3'),
			"AUSTRIA" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"BAHRAIN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"BELGIUM" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"BRAZIL" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0x0'),
			"BULGARIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"CANADA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CHILE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CHINA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0xf'),
			"COLOMBIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CROATIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"CYPRUS" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"CZECH" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"DENMARK" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ECUADOR" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"EGYPT" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"ELSALVADOR" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"FINLAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"FRANCE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"GERMANY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"1TR110_DE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 1, "rt2" => 1, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"GREECE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"GUAM" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"HONGKONG" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"HUNGARY" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"ICELAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"INDIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x4'),
			"INDONESIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"IRELAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ISRAEL" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ITALY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"JAPAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"JORDAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"KAZAKHSTAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"KUWAIT" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"LATVIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"LEBANON" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"LUXEMBOURG" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"MACAO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MALAYSIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MALTA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"MEXICO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MOROCCO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NETHERLANDS" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NEWZEALAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x4'),
			"NIGERIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NORWAY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"OMAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PAKISTAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PERU" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PHILIPPINES" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"POLAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 1, "rt" => 1, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PORTUGAL" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ROMANIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"RUSSIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SAUDIARABIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SINGAPORE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SLOVAKIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x3'),
			"SLOVENIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x2'),
			"SOUTHAFRICA" => array('ohs' => 1, 'ohs2' => 0, 'rz' => 1, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x3'),
			"SOUTHKOREA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SPAIN" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SWEDEN" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SWITZERLAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SYRIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"TAIWAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"THAILAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"UAE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"UK" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x5'),
			"USA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"YEMEN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
		);
		return $country[$c];
	}

	public static function getRevision() {
		return self::_getRevision();
	}

	public static function getDate() {
		return self::_getDate();
	}

	public static function getSerial($is_sbc_vm = '0') {
		$function_list = array(
			'0' => '_getSbcSerial',
			'1' => '_getSbcvmSerial',
		);
		$function = $function_list[$is_sbc_vm == 1 ? '1' : '0'];
		return self::$function();
	}

	public function getFpgaVersion() {
		return self::_getFpgaVersion();
	}

	public static function getDateByFormat($formatString = null) {
		@exec('/bin/date ' . (($formatString != null) ? $formatString : '-R'), $output);
		return(trim($output[0]));
	}

	public static function convertSecondsToDaily($seconds) {
		if ((int)$seconds <= 0) {
			return array('d' => 0, 'h' => 0, 'm' => 0, 's' => 0);
		}
		$num = floatval($seconds);

		$secs = (int)fmod($num, 60);

		$num = (int)($num / 60);
		$mins = $num % 60;

		$num = (int)($num / 60);
		$hours = $num % 24;

		$days = (int)($num / 24);

		return array('d' => $days, 'h' => $hours, 'm' => $mins, 's' => $secs);
	}

	public static function getInfo($bc = null, $ba = null, $isgw = null, $type = 0) {
		// default
		$info_general = array(
			'date'				=> '_getDate', 
			'isgw_uptime'	=> '_getIsgwUptime',
			'openssl'			=> '_getOpensslVersion',
			'php' 				=> '_getPhpVersion',
			's2s_licenses'=> '_getSip2SipLicences',
		);

		$info_by_type = array(
			// sbc
			'0' => array(
				'appfs' 				=> '_getAppFsVersion',
				'fgpa'					=> '_getFpgaVersion',
				'hw_revision'		=> '_getRevision',
				'lif'						=> '_getLifInfo',
				'msp_fw'				=> '_getMspFirmwareVersion', 
				'mtdblock'			=> '_getMtdblock',
				'network'				=> '_getSbcNetworkInfo',
				'rootfs'				=> '_getRootFsVersion',
				'serial'				=> '_getSbcSerial',
				'storage'				=> '_getSbcStorage',
				'system_uptime' => '_getSbcUptime',
			),
			// sbcvm
			'1' => array(
				'network'				=> '_getSbcvmNetworkInfo',
				'package'				=> '_getPackageInformation',
				'serial'				=> '_getSbcvmSerial',
				'system_uptime' => '_getSbcvmUptime',
				'vpn-client'		=> '_getSbcvmVpnClient',
			),
		);

		if (is_null($bc)) {
			require_once('/usr/fallback/beroConf.php');
			$bc = new beroConf('root');
		}

		if (is_null($ba)) {
			require_once('/usr/local/www/berogui/misc/database.php');
			$ba = new beroAri();
		}

		// login to isgw
		if (is_null($isgw)) {
			require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
			$isgw = new isgwtelnet();
			$isgw->isgw_login();
		}

		// get the info
		$info_by_type = array_merge($info_by_type[$type], $info_general);
		foreach ($info_by_type as $key => $function) {
			$info[$key] = self::$function($bc, $ba, $isgw);
		}

		return $info;
	}
	
	/* [PRIVATE METHODS TO getInfo PUBLIC METHOD */
	private static function _getAppFsVersion($bc = null, $ba = null, $isgw = null) {
		if (is_null($bc)) {
			$bc = new beroConf('root');
		}
		preg_match('/appfs-(.*).tar.gz/', $bc->get('root', 'app-image'), $matches);
		return($matches[1]);
	}

	private static function _getDate($bc = null, $ba = null, $isgw = null) {
		@exec('/bin/date -R', $output);
		return(trim($output[0]));
	}

	private static function _getFpgaVersion($bc = null, $ba = null, $isgw = null) {
		return(trim(file_get_contents('/sys/class/beronet/fpga/version')));
	}

	private static function _getIsgwUptime($bc, $ba, $isgw) {
		$isgw_uptime = $isgw->isgw_uptime();
		$isgw_uptime = preg_split("/: /", $isgw_uptime);
		$isgw_uptime = explode(':', $isgw_uptime[1]);
		$isgw_uptime = 3600*$isgw_uptime[0] + 60*$isgw_uptime[1] + $isgw_uptime[2];
		$isgw_uptime = self::convertSecondsToDaily($isgw_uptime);
		return "{$isgw_uptime['d']}d:{$isgw_uptime['h']}h:{$isgw_uptime['m']}m:{$isgw_uptime['s']}s";
	}

	private static function _getLifInfo($bc, $ba, $isgw = null) {
		$info = array();
		for ($i = 0; $i < self::getLifCount(); $i++) {
			$query = $ba->select('SELECT type FROM isdn WHERE lif="' . $i . '" union ' .
				'SELECT type FROM analog WHERE lif="' . $i . '" union ' .
				'SELECT type FROM gsm WHERE lif="' . $i . '" union ' .
				'SELECT type FROM lte WHERE lif="' . $i . '" union ' .
				'SELECT type FROM cas WHERE lif="' . $i . '"');
			$type = sqlite_fetch_single($query);
			if (!empty($type)) {
				$info[$i] = 'li' . $i . ':  ' . $type;
			}
		}
		return $info;
	}

	private static function _getMtdblock($bc = null, $ba = null, $isgw = null) {
		$php_vers_exploded = explode('.', PHP_VERSION);
            	return $php_vers_exploded[0] < '7' ? '5' : '7';
	}

	private static function _getMspFirmwareVersion($bc, $ba, $isgw) {
		$msp = explode(':', $isgw->Query('fw'));
		return $msp[1];
	}

	private static function _getPackageInformation ($bc = null, $ba = null, $isgw = null, $file = '/usr/local/VERSION') {
		if (file_exists($file)) {
			extract(parse_ini_file($file));
			return array(
				'appfs'		=> $APPFS,
				'beronode'=> $BERONODE,
				'version' => $VERSION,
			);
		}
		return 'unknown (error)';
	}

	private static function _getOpensslVersion($bc, $ba = null, $isgw = null) {
		$is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0;
		$cmd = array(
			0	=> "/usr/local/bin/openssl version",
			1 => "/usr/bin/openssl version",
		);
		$version = self::exec($is_sbc_vm, $cmd[$is_sbc_vm]);
		if (preg_match('/OpenSSL ([0-9.a-z]+) .*/', $version, $version_matched)) {
			return $version_matched[1];
		}	
		// default
		return '1.0.2u (default)';
	}

	private static function _getPhpVersion($bc = null, $ba = null, $isgw = null) {
		return PHP_VERSION;
	}

	private static function _getRevision($bc = null, $ba = null, $isgw = null) {
		if (file_exists('/sys/class/beronet/gateway/revision')) {
			return(trim(file_get_contents('/sys/class/beronet/gateway/revision')));
		}
		return null;
	}

	private static function _getRootFsVersion($bc = null, $ba = null, $isgw = null) {
		$f = @file('/pkginfo/VERSION.rootfs');
		$tmp = explode('=', $f[1]);
		return(trim($tmp[1]));
	}

	public static function _getSbcNetworkInfo($bc, $ba = null, $isgw = null) {
		$info['ports'] = $bc->get('root', 'lan-ports');
		$info['mode'] = (strlen($bc->get('root', 'lan-mode')) ? $bc->get('root', 'lan-mode') : 'single');

		// get names of interfaces
		switch ($info['mode']) {
			case 'lan-wan':
				$wan_iface = 'eth0.11';
			case 'single':
				$lan_iface = 'eth0' . (($info['ports'] == 2) ? '.10' : '');
				break;
			case 'bonding':
				$lan_iface = 'eth0';
				break;
		}

		// get lan-info
		$lanGw = false;
		$info['iface']['lan']['macaddr'] = self::getNetworkMacAddr($lan_iface);
		$info['iface']['lan']['ipaddr'] = self::getNetworkIpAddr($lan_iface);
		$info['iface']['lan']['netmask'] = self::getNetworkMask($lan_iface);
		if (in_array($bc->get('root', 'gateway-mode'), array('eth0.10', 'manual'))) {
			$info['provided']['gateway'] = self::getNetworkGateway($lan_iface);
			$lanGw = strlen($info['provided']['gateway']) > 0;
		}

		// get wan-info
		if ($info['mode'] == 'lan-wan') {
			$info['iface']['wan']['macaddr'] = self::getNetworkMacAddr($wan_iface);
			$info['iface']['wan']['ipaddr'] = self::getNetworkIpAddr($wan_iface);
			$info['iface']['wan']['netmask'] = self::getNetworkMask($wan_iface);
			if (!$lanGw && in_array($bc->get('root', 'gateway-mode'), array($wan_iface, 'manual'))) {
				$info['provided']['gateway'] = self::getNetworkGateway($wan_iface);
			}
		}

		if ($bc->get('root', 'gateway-mode') == 'manual') {
			$info['provided']['gateway'] = $bc->get('root', 'lan-gateway');
		}

		// get dns-config
		$info['provided']['nameserver'] = self::getNetworkNameserver();

		return($info);
	}

	public static function getNetworkNameserver() {
		$info = array();
		foreach (file('/etc/resolv.conf') as $line) {
			if (strstr($line, 'nameserver')) {
				$info[] = end(explode(" ", $line));
			}
		}
		return $info;
	}

	private static function _getSbcvmNetworkInfo($bc, $ba = null, $isgw = null, $conf = '/etc/beroNet/sbc.conf') {
		$sbc_conf = parse_ini_file($conf);
		$info['wan']['ipaddr'] = $sbc_conf['SBCVM_IP'];
		$info['wan']['netmask'] = '255.255.255.255';
		if ($bc->get('root', 'is-vpn-running') == 1) {
			$info['lan/vpn']['ipaddr'] = self::getNetworkIpAddr('tun0', 1);
			$info['lan/vpn']['netmask'] = self::getNetworkMask('tun0', 1);
		}
		return $info;
	}

	private static function _getSbcSerial($bc = null, $ba = null, $isgw = null) {
		return(trim(file_get_contents('/sys/class/beronet/gateway/serial')));
	}

	private static function _getSbcvmSerial($bc = null, $ba = null, $isgw = null) {
		if (is_null($bc)) {
			$bc = new beroConf('root');
		}
		return $bc->get('root', 'sbcvm-serial');
	}

	public static function _getSbcStorage($bc = null, $ba = null, $isgw = null) {
		$output = array();
		$storage = array();
		$translate = array(
			5 => 'Root (Rootfs)',
			6 => 'Firmware (Appfs)',
			7 => 'Apps (UserApps)',
			8 => 'Configuration (Conffs)',
		);
		self::exec(0, 'df', $output);
		foreach ($output as $entry) {
			if (preg_match('/^.*mtdblock(?<which>[0-9]+).* (?<used>[0-9]+)%.*$/', $entry, $matched)) {
				$storage[$translate[$matched['which']]] = "{$matched['used']}%";
				unset($matched);
			}
		}
		return($storage);
	}

	private static function _getSbcUptime($bc = null, $ba = null, $isgw = null) {
		$info = array();
		exec('/usr/bin/uptime', $resup);
		preg_match("/(?<t>.+), load /", $resup[0], $uptime);
		return $uptime[1];
	}

	private static function _getSbcvmUptime($bc = null, $ba = null, $isgw = null) {
		$time = self::convertSecondsToDaily(@file_get_contents('/proc/uptime'));
		return "{$time['d']}d:{$time['h']}h:{$time['m']}m:{$time['s']}s";
	}

	private static function _getSbcvmVpnClient($bc = null, $ba = null, $isgw = null) {
		require_once('/usr/local/www/berogui/modules/Vpn/vpn_helper.php');
		return VpnHelper::getDataClients();
	}

	private static function _getSip2SipLicences($bc = null, $ba = null, $isgw) {
		include_once('/usr/local/www/berogui/includes/variables.php');
		require_once('/usr/local/www/berogui/includes/Helper/HelperSip.php');
		return HelperSip::getSip2SipLicenses($isgw);
	}
	/* */

	/**
	 * @return string Gateway type
	 */
	public static function getType() {
		if (file_exists('/sys/class/beronet/gateway/type')) {
			return(trim(file_get_contents('/sys/class/beronet/gateway/type')));
		}
		return null;
	}

	/**
	 * @return int Gateway channels
	 */
	public static function getChannels() {
		// function never used
		if (file_exists('/sys/class/beronet/gateway/channels')) {
			return(trim(file_get_contents('/sys/class/beronet/gateway/channels')));
		}
		return null;
	}

	/**
	 * @return int Reset jumper connected or not
	 */
	public static function getResetJumper() {
		if (file_exists('/sys/class/beronet/gateway/resetjumper')) {
			return(trim(file_get_contents('/sys/class/beronet/gateway/resetjumper')));
		}
		return null;
	}

	public static function getAppFsVersion() {
		return self::_getAppFsVersion();
	}

	public static function getRootFsVersion() {
		return self::_getRootFsVersion();
	}

	/**
	 * @param string $Name
	 * @return string name of network interface
	 */
	public static function getNetworkIfaceByName($name = 'lan', $bc = null) {
		if (is_null($bc)) {
			$bc = new beroConf('root');
		}

		$ports = $bc->get('root', 'lan-ports');
		$mode = $bc->get('root', 'lan-mode');
		$vlan['enable'] = $bc->get('root', 'vlan-enable');
		$vlan['id'] = $bc->get('root', 'vlan-id');

		switch ($name) {
			case 'vpn':
				// lan interface is always 'tun0' if OpenVPN is installed
				if (file_exists('/apps/openvpn/VERSION')) {
					return('tun0');
				}
				break;
			case 'lan':
				switch ($mode) {
					default:
					case 'single':
						// vlan works as of now only on single iface-devices
						if (($vlan['enable'] == 1) && ($vlan['id'] > 0)) {
							return('eth0.' . $vlan['id']);
						}
					case 'lan-wan':
						return('eth0' . (($ports == 2) ? '.10' : ''));
					case 'bonding':
						return('eth0');
				}
				break;
			case 'wan':
				if ($mode == 'lan-wan') {
					return('eth0.11');
				}
				break;
		}

		return(false);
	}

	public static function getNetworkMacAddr($Iface = 'eth0') {
		if (file_exists("/sys/class/net/$Iface/address")) {
			return(trim(file_get_contents('/sys/class/net/' . $Iface . '/address')));
		}
		return "";
	}

	public static function getNetworkIpAddr($Iface = 'eth0', $is_sbc_vm = 0) {
		$cmd = array(
			0	=> '/usr/bin/expr match "$(/sbin/ifconfig '. $Iface .')" ".*inet addr:\([0-9\.]*\)"',
			1	=> '/usr/bin/expr match "$(/usr/sbin/ifconfig '. $Iface .')" ".*inet \([0-9\.]*\)"',
		);
		return trim(self::exec($is_sbc_vm, $cmd[$is_sbc_vm]));
	}

	public static function getNetworkMask($Iface = 'eth0', $is_sbc_vm = 0) {
		$cmd = array(
			0	=> '/usr/bin/expr match "$(/sbin/ifconfig '. $Iface .')" ".* Mask:\([0-9\.]*\)"',
			1 => '/usr/bin/expr match "$(/usr/sbin/ifconfig '. $Iface .')" ".* netmask \([0-9\.]*\)"',
		);
		return trim(self::exec($is_sbc_vm, $cmd[$is_sbc_vm]));
	}

	public static function getNetworkGateway($Iface = 'eth0', $is_sbc_vm = 0) {
		return self::exec($is_sbc_vm, '/usr/bin/expr match "$(/sbin/route -n | grep ' . $Iface . ' | grep UG)" "0.0.0.0 *\([0-9\.]*\)"');
	}

	static public function getTotalCalls() {
		require_once ('/usr/local/www/berogui/includes/isgwtelnet.php');
		$isgw = new isgwtelnet();
		$result = $isgw->isgw_login();
		if ($result == false) {
			return 0;
		}
		$channelresult = $isgw->isgw_channelstate();
		if (preg_match('/TOTAL CALLS:([0-9]*)/', $channelresult, $nb_calls)) {
			return $nb_calls[1];
		}
		// old way. can be removed
		$rows = explode("\n", $channelresult);
		$i = 0;
		$dontUse = array();
		foreach ($rows as $row) {
			$row = htmlspecialchars($row);
			$values = explode("\t", $row);
			if (trim($row) != "" && strpos($row, "LISTING CALL OPERATIONS COMPACT") === false && (!in_array(intval($values[0]), $dontUse))) {
				if (strpos($values[13], "MSP_BRIDGED") !== false) {
					/**
					 * PSTN zu PSTN Einträgen
					 */
					$tmp = explode("=", $values[10]);
					array_push($dontUse, intval($tmp[1]));
					$i++;
				} else {
					$i++;
				}
			}
		}
		return $i;
	}

	static public function getAppList() {
		$ret = array();
		if (!($dh = @opendir('/home/admin/apps/'))) {
			return $ret;
		}

		while (($file = readdir($dh)) !== false) {
			if (($file == '.') || ($file == '..')) {
				continue;
			}
			$ret[] = $file;
		}
		closedir($dh);

		return $ret;
	}

	static public function getConfigFromIsgw($is_sbc_vm = 0) {
		$cmd = array(
			0 => "/usr/local/bin/isgw -C -e/usr/conf",
			1 => "/usr/local/beroNet/sbin/isgw.sh -C -e/etc/beroNet/isgw",
		);
		exec($cmd[$is_sbc_vm ? 1 : 0], $lines);
		reset($lines);
		while (strpos(current($lines), "Default call configuration:") === FALSE && current($lines) !== FALSE) {
			array_shift($lines);
		}
		array_shift($lines);
		return $lines;
	}

	static public function getDefaultConfig($is_sbc_vm = 0) {

		$lines = self::getConfigFromIsgw($is_sbc_vm);
		$default = array();
		foreach ($lines as $line) {
			preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $line, $res);
			$default[$res["name"]] = $res['def'];
		}
		return $default;
	}

	static public function check(&$ba) {
		$pstn = 0;
		if (!($ba->get('is_sbc_vm') == 1)) {
			$query = $ba->select('SELECT DISTINCT gr FROM isdn WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM analog WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM gsm WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM lte WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM cas_channels WHERE gr!="NULL"');
			$pstn = sqlite_num_rows($query);
		}
		$query = $ba->select('select * from sip');
		$sip = sqlite_num_rows($query);
		$query = $ba->select('select  * from dialplan');
		$dialplan = sqlite_num_rows($query);
		if ($pstn == 0 && $sip == 0 && $dialplan == 0) {
			return 1;
		} else {
			return 0;
		}
	}

	static public function sanitizeGet($getInput, $getCheckor, &$ptr_authorize_request = null, &$invalid = array(), $options = array(), $request = 'GET') {
		// TODO: if some modification must be applied on a GET input (exemple, remplace a /), do it here
		// TODO: update the arguments to give the default value of a parameter

		if (!is_null($ptr_authorize_request) && !$ptr_authorize_request) {
			// a previous sanitize failed
			return $getInput;
		}

		$list_checkor_with_default_value = array('m', 'ent', 'opt', 'order', 'sort', 'start');

		// global GET checking coming from a submit or a popup loading
		if (is_array($getInput)) {
			foreach ($getInput as $key => $value) {
				if (isset($getCheckor[$key]) && in_array($getCheckor[$key], $list_checkor_with_default_value)) {
					$getInput[$key] = Helper::sanitizeGet($value, $getCheckor[$key], $ptr_authorize_request, $invalid, isset($options[$key]) ? $options[$key] : array());
				} else if (isset($getCheckor[$key]) && !Helper::checkInputData($getCheckor[$key], $value, count($options) > 0 ? $options[$key] : '')) {
					$invalid = array('request' => $request, 'key' => $key, 'checkor' => $getCheckor[$key]);
					$ptr_authorize_request = 0;
					break;
				}
			}	
		}
		// we check an unique input coming from a GET request
		else {
			$direction_list = array('sip', 'isdn', 'analog', 'cas', 'lte', 'gsm');
			switch ($getCheckor) {
				// Global Variables -> if sanitize fails, return a default value (expected opt which update the ptr_authorize_request pointer)
				case 'ent':
					$list_ent = array(10, 15, 20, 25, 30, 35, 40, 45, 50);
					if (!(in_array($getInput, $list_ent))) {
						return 10;
					}
					break;
				case 'm':
					if (!Helper::checkInputData($getCheckor, $getInput)) {
						return 'State';	
					}
					break;
				case 'opt':
					if ($getInput !== '') {
						$whitelist_opt = array();
						$beroAri = new beroAri();

						if (!($beroAri->get('is_sbc_vm') == 1)) {
							/*Analog*/
							if (sqlite_num_rows($beroAri->select("SELECT * from analog where port_type='FXO'")) > 0) {
								array_push($whitelist_opt, 'fxo');
							}
							if (sqlite_num_rows($beroAri->select("SELECT * from analog where port_type='FXS'")) > 0) {
								array_push($whitelist_opt, 'fxs');
							}

							/*ISDN*/
							if (sqlite_num_rows($beroAri->select("SELECT * from isdn where port_type='PRI'")) > 0) {
								array_push($whitelist_opt, 'pri');
							}
							if (sqlite_num_rows($beroAri->select("SELECT * from isdn where port_type='BRI'")) > 0) {
								array_push($whitelist_opt, 'bri');
							}
						
							/*GSM*/
							if (sqlite_num_rows($beroAri->select("SELECT * from gsm")) > 0) {
								array_push($whitelist_opt, 'gsm');
							}

							/*CAS*/
							if (sqlite_num_rows($beroAri->select("SELECT * from cas_channels")) > 0) {
								array_push($whitelist_opt, 'cas');
							}

							/*LTE*/
							if (sqlite_num_rows($beroAri->select("SELECT * from lte")) > 0) {
								array_push($whitelist_opt, 'lte');
							}
						}

						if (!(in_array(strtolower($getInput), $whitelist_opt))) {
							$invalid = array('request' => $request, 'checkor' => 'opt');
							$ptr_authorize_request = 0;
						}
					}
					break;
				case 'order':
				case 'sort':
				case 'start':
					if (!Helper::checkInputData('int>=0', $getInput)) {
						return 0;
					}
					break;
				// Specific Variables -> if sanitize fails, update ptr_authorize_request to false
				case 'direction':
					if (!Helper::checkInputData('select', $getInput, $direction_list)) {
						$invalid = array('request' => $request, 'checkor' => 'direction');
						$ptr_authorize_request = 0;
					}
					break;	
				case 'group-name':
					if (!Helper::checkInputData($getCheckor, $getInput)) {
						$invalid = array('request' => $request, 'checkor' => 'group-name');
						$ptr_authorize_request = 0;
					}
					break;
				case 'id':
					if (is_array($getInput)) {
						$list_id = array();
						foreach ($getInput as $id) {
							$list_id[] = Helper::sanitizeGet($getCheckor, $id, $ptr_authorize_request);
						}
						$getInput = $list_id;
					} else if (!Helper::checkInputData($getCheckor, $getInput)) {
						$invalid = array('request' => $request, 'checkor' => 'id');
						$ptr_authorize_request = 0;
					}
					break;
				default:
					if (!Helper::checkInputData($getCheckor, $getInput, $options)) {
						$invalid = array('request' => $request, 'checkor' => $getCheckor);
						$ptr_authorize_request = 0;
					}
					break;
				}
			}

		return $getInput;
	}

	static public function sanitizePost($postInput, $postCheckor, &$ptr_authorize_request = null, &$invalid = array(), $list_options = array(), $request = 'POST') {
		// TODO: if some modification must be applied on a POST input (exemple, remplace a /), do it here
		
		if (!is_null($ptr_authorize_request) && !$ptr_authorize_request) {
			// a previous sanitize failed
			return $postInput;
		}

		// global POST checking coming from a submit
		if (is_array($postInput)) {
			foreach ($postInput as $key => $value) {
				if (!isset($postCheckor[$key]) || !(Helper::checkInputData($postCheckor[$key], $value, count($list_options) > 0 ? $list_options[$key] : ''))) {
					//TODO: line can be removed echo "problem POST request:<br/><br/>\t key = $key<br/><br/>value:<pre>"; print_r($value); echo "</pre><br/><br/>options:<pre>"; print_r($list_options); echo "</pre><br/>";
					$invalid = array('request' => $request, 'key' => $key, 'checkor' => $postCheckor[$key]);
					$ptr_authorize_request = 0;
					break;
				}
			}
		} 
		else {
			switch ($postCheckor) {
				case 'gui-mode':
					// if gui-mode unknown, we set to 'simple'
					$whitelist_gui_mode = array('simple', 'advanced');
					if (!(in_array(strtolower($postInput), $whitelist_gui_mode))) {
						return 'simple';
					}
					return $postInput;
				case 'lang':
					// if lang unknown, we set to 'en'
					$whitelist_lang = array('en', 'de');
					if (!(in_array($postInput, $whitelist_lang))) {
						return 'en';
					}
					return $postInput;
				default:
					if (!Helper::checkInputData($postCheckor, $postInput, $list_options)) {
						$invalid = array('request' => $request, 'checkor' => $postCheck[$key]);
						$ptr_authorize_request = 0;
					}
					break;
			}
		}

		return $postInput;
	}

	static public function sanitizeSession($sessionInput, $sessionCheckor, $ptr_authorize_session = null, &$invalid = array(), $list_options = array()) {

		if (!Helper::checkInputData($sessionCheckor, $sessionInput)) {
			$invalid = array('request' => $request, 'checkor' => $sessionCheckor);
			$ptr_authorize_session = 0;
		}

		return $sessionInput;
	}

	static public function checkArrayInputs($checkor, $array, $options = array()) {
		foreach ($array as $input) {
			if (!Helper::checkInputData($checkor, $input, $options)) {
				return 0;
			}
		}
		return 1;
	}

	static public function checkInputData($checkor, $data, $options = '') {
		// in case where the variable is declared but not defined
		if ($data === '') {
			return 1;
		}
		// in case where the input data is an array
		else if (is_array($data)) {
			return Helper::checkArrayInputs($checkor, $data, $options);
		}

		// multiple condition/type required
		if (is_array($checkor)) {
			// min length = 3 -> (operator + 2 conditions)
			if (count($checkor) < 3) {
				return 0;
			}

			// getting operator type
			$operator = $checkor[0];
			unset($checkor[0]);
			// getting total condition
			$data_trusted = ($operator == '||') ? 0 : 1;
			foreach ($checkor as $condition) {
				if ($operator == '||') {
					$data_trusted = $data_trusted || Helper::checkInputData($condition, $data, $options);
				} else {
					$data_trusted = $data_trusted && Helper::checkInputData($condition, $data, $options);
				}
			}
			return $data_trusted;
		}
		// an unique type required
		else {
			// checking all inputs
			switch ($checkor) {
				case 'accept':
					// the check is not necessary: the data is not stored (SQL) or displayed to the GUI (XSS)
					return 1;
				case 'alphanumeric':
					return preg_match('/^[0-9a-zA-Z]+$/', $data);
				case 'bool':
					return (is_bool($data) || (string)$data === '1' || (string)$data === '0' || $data === 'yes' || $data === 'no' || $data === 'on' || $data === 'off' || $data === 'true' || $data === 'false');
				case 'comment':
					return !preg_match('/[äÄöÖüÜß!@#$%^&*()+=[\]\';,\/{}|\"<>?]+/', $data);
				case 'config-option':
					// avoid XSS injection ... but how avoid SQL injection ?? TODO
					return !preg_match('/<script>|<\/script>|<javascript>|<\/javascript>/', $data);
				case 'dir-exists':
					if (is_array($options)) {
						$exist = 0;
						foreach ($options as $option) {
							if ($data === $option) {
								$exist = 1;
								break;
							}
						}
						return $exist;
					}
					return ($options === '' ? file_exists($data) : file_exists($options .'/'. $data));;
				case 'direction':
					$list_directions = array('all');
					foreach ($options as $dir) {
						foreach ($options as $dir1) {
							array_push($list_directions, "$dir-$dir1");
						}
					}
					return in_array(strtolower($data), array_map('strtolower', $list_directions));
				case 'file-exists':
					if (is_array($options)) {
						$exist = 0;
						foreach ($options as $option) {
							if (file_exists($option .'/'. $data)) {
								$exist = 1;
								break;
							}
						}
						return $exist;
					}
					return ($options === '' ? file_exists($data) : file_exists($options .'/'. $data));
				case 'from-to-id':
					return preg_match('/^[a-zA-Z0-9\_\-\:]+$/', $data);
				case 'gmt':
					return preg_match('/^GMT0|GMT(-|\+)[:\d]{1,5}$/', $data);
				case 'group-name':
					return preg_match('/^[a-zA-Z0-9\_\-]+$/', $data);
				case 'group-name-space':
					return preg_match('/^[ a-zA-Z0-9\_\-]+$/', $data);
				case 'hostname':
					return preg_match('/^((?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*(?::(?:[0-9]){1,5})?)*$/i', $data);
				case 'id':
					if (preg_match('/[,]+/', $data)) {
						return Helper::checkInputData('id', explode(',', $data));
					}
					return Helper::checkInputData('int>=0', $data);
				case 'int':
					$toInt = (is_string($data) && is_numeric($data)) ? (int)$data : $data;
					return is_int($toInt);
				case 'int>0':
					return (Helper::checkInputData('int', $data) && $data > 0);
				case 'int>=0':
					return preg_match('/^[\d]+$/', $data);
				case 'int-length':
					$bool_int = 0;
					switch ($options['operator']) {
						case '=':
							$bool_int = Helper::checkInputData('int', $data);
							break;
						case '>':
							$bool_int = Helper::checkInputData('int>0', $data);
							break;
						case '>=':
							$bool_int = Helper::checkInputData('int>=0', $data);
							break;
						default:
							break;
					}
					return ($bool_int && strlen((string)$data) === $options['length']);
				case 'int-piped':
					return preg_match('/^[\d\|]+$/', $data);
				case 'int-range':
					return (Helper::checkInputData('int', $data) && (isset($options['min']) && isset($options['max']) && ($data >= $options['min'] && $data <= $options['max'])));
				case 'int-ranged':
					return preg_match('/^[-0-9]+$/', $data);
				case 'international-code':
					return preg_match('/^\+?[0-9]{1,70}?$/', $data);
				case 'ip4':
					return preg_match('/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/', $data);
				case 'ip6':
					// TODO
					return 1;
				case 'm':
					// general whitelist
					// TODO: list directories under /usr/local/www/berogui/modules
					$whitelist_class = array(
						'Acl', 'BackupRestore', 'Dialplan', 'DialplanDebug', 
						'Dos', 'FulltraceGui', 'Info',  'IsgwCauses', 'Logging', 'Miscellaneous',
						'NetConf', 'RebootReset', 'Security', 
						'Sip', 'SipStack', 'SipLicense', 'State', 'StateCalls', 'StateStatistic', 'Telnet', 'UpdateTool',
					);
	
					$beroAri = new beroAri();	

					if ($beroAri->get('is_sbc_vm') == 1) {
						$whitelist_class[] = 'Vpn';
					}
					else {	
						$whitelist_class = array_merge($whitelist_class, array('Market', 'CallProgress', 'RemoteManagement', 'TimeConf', 'Wizard', 'Provisioning', 'BeroCloud', 'Berofos', 'Cdr', 'PstnHardware'));

						// append Analog to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from analog")) > 0) {
							$whitelist_class[] = 'Analog';
						}
						// append Isdn to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from isdn")) > 0) {
							$whitelist_class[] = 'Isdn';
						}
						// append Gsm to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from gsm")) > 0) {
							$whitelist_class = array_merge($whitelist_class, array('Gsm', 'Sms'));
						}
						// append Lte to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from lte")) > 0) {
							$whitelist_class = array_merge($whitelist_class, array('Lte', 'Sms'));
						}
						// append Cas to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from cas_channels")) > 0) {
							$whitelist_class[] = 'Cas';
						}
					}
					// check the class to load
					$class = $data;
					$path_to_class = "/usr/local/www/berogui/modules/$class/$class.php";
					// unset
					unset($beroAri);
					return (in_array($class, $whitelist_class) && is_file($path_to_class));
				case 'mac':
					return preg_match('/^([0-9A-Fa-f]{2}([:-]|$)){6}$|([0-9A-Fa-f]{4}([.]|$)){3}$/i', $data);
				case 'match':
					return preg_match('/'. $options .'/', $data);
				case 'netmask':
					return (Helper::checkInputData('ip4', $data) || (Helper::checkInputData('int', $data) && ($data >= 0 && $data <= 32)));
				case 'password':
					// not necessary to check the password since they must be hashed
					return 1;
				case 'phone-char':
					return preg_match('/^[0-9#_+]+$/', $data);
				case 'select':
					return is_array($options) ? in_array(strtolower($data), array_map('strtolower', $options)) : $data === $options;
				case 'snmp':
					return preg_match('/^[a-zA-Z0-9\@\#\$\%\^\*\(\)\_\-\+\/\?\{\}\[\]\.\,]*$/', $data);
				case 'special-char':
					return !preg_match('/[äÄöÖüÜß#$%^()[\]\'\/{}|\"<> ]+/', $data);
				case 'str-length':
					$lgth = strlen($data);
					return (Helper::checkInputData('config-option', $data) && isset($options['min']) && isset($options['max']) && ($lgth >= $options['min'] && $lgth <= $options['max']));
				case 'tones':
					return preg_match('/^\[[-a-z0-9]+\]$/', $data);
				case 'uri':
					return Helper::checkInputData('config-option', urldecode($data));
				case 'url':
					$is_with_ip = preg_match("/^((https?|t?ftp):\/\/)?((25[0-5]|(2[0-4]|1[0-9]|[1-9]|)[0-9])(\.(?!$)|)){4}([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/", $data);
					$is_without_ip = preg_match("/^((https?|t?ftp):\/\/)?(www.)?[a-zA-Z0-9-_]+(\.[a-zA-Z]+)+((\/)[\w#.-?&]+)*(\/\w+\?[a-zA-Z0-9_]+=\w+(&[a-zA-Z0-9_]+=\w+)*)?([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/", $data);
					return ($is_with_ip || $is_without_ip);
				default:
					// unknown type -> the check is incorrect
					// TODO -> TOREMOVE: echo "unknown checkor = $checkor; <br/>data<pre>"; print_r($data); echo "<pre>options:<pre>"; print_r($options); echo "</pre>";
					return 0;
			}	
		}
	}

	static public function displayErrorMessage($request, $checkor = null, $key = null) {
		// TODO: update this table => make a huge table 
		//
		//		$list_checkor = array(
		//					checkor1 => array('function' => 'functionNameRelatedToCheckor1', 'error' => PHP_VALIDATOR_CHECKOR1_REQUIREMENT),
		//					checkor2 => array('function' => 'functionNameRelatedToCheckor2', 'error' => PHP_VALIDATOR_CHECKOR2_REQUIREMENT),
		//				     );
		//			-> this way, the checkInputData can be highly simplified without the swicth condition
		//

		$error_table = array(
					'alphanumeric'		=> array('define' => 'PHP_VALIDATOR_ALPHANUMERIC', 'chars' => ''),
					'bool'			=> array('define' => 'PHP_VALIDATOR_BOOLEAN', 'chars' => ''),
					'comment'		=> array('define' => 'PHP_VALIDATOR_COMMENT', 'chars' => 'äÄöÖüÜß!@#$%^&*()+=[\]\';,\/{}|\"<>?'),
					'config-option'		=> array('define' => 'PHP_VALIDATOR_CONFIG_OPTION', 'chars' => ''),
					'dir-exists'		=> array('define' => 'PHP_VALIDATOR_DIR_EXISTS', 'chars' => ''),
					'direction'		=> array('define' => 'PHP_VALIDATOR_DIRECTION', 'chars' => ''),
					'file-exists'		=> array('define' => 'PHP_VALIDATOR_FILE_EXISTS', 'chars' => ''),
					'from-to-id'		=> array('define' => 'PHP_VALIDATOR_FROMTO_ID', 'chars' => ''),
					'gmt'			=> array('define' => 'PHP_VALIDATOR_GMT', 'chars' => ''),
					'group-name'		=> array('define' => 'PHP_VALIDATOR_GROUP_NAME', 'chars' => 'a-z, A-Z, 0-9, _ and -.'),
					'group-name-space'	=> array('define' => 'PHP_VALIDATOR_GROUP_NAME_SPACE', 'chars' => 'a-z, A-Z, 0-9, _ and -.'),
					'hostname'		=> array('define' => 'PHP_VALIDATOR_HOSTNAME', 'chars' => ''),
					'id'			=> array('define' => 'PHP_VALIDATOR_ID', 'chars' => ''),
					'int'			=> array('define' => 'PHP_VALIDATOR_INT', 'chars' => ''),
					'int>0'			=> array('define' => 'PHP_VALIDATOR_INT_STRICT_POSTI', 'chars' => ''), 
					'int>=0'		=> array('define' => 'PHP_VALIDATOR_INT_POSITNULL', 'chars' => ''),
					'int-length' 		=> array('define' => 'PHP_VALIDATOR_INT_LENGHT', 'chars' => ''),
					'int-piped'		=> array('define' => 'PHP_VALIDATOR_INT_PIPED', 'chars' => ''),
					'int-range' 		=> array('define' => 'PHP_VALIDATOR_INT_RANGE', 'chars' => ''),
					'int-ranged'		=> array('define' => 'PHP_VALIDATOR_INT_RANGED', 'chars' => ''),
					'international-code'	=> array('define' => 'PHP_VALIDATOR_INTERNATIONAL_CODE', 'chars' => ''),
					'ip4'			=> array('define' => 'PHP_VALIDATOR_IP4', 'chars' => ''),
					'ip6'			=> array('define' => 'PHP_VALIDATOR_IP6', 'chars' => ''),
					'mac'			=> array('define' => 'PHP_VALIDATOR_MAC', 'chars' => ''),
					'match'			=> array('define' => 'PHP_VALIDATOR_MATCH', 'chars' => ''),
					'netmask'		=> array('define' => 'PHP_VALIDATOR_NETMASK', 'chars' => ''),
					'phone-char' 		=> array('define' => 'PHP_VALIDATOR_PHONE_CHAR', 'chars' => ''),
					'select'		=> array('define' => 'PHP_VALIDATOR_SELECT', 'chars' => ''),
					'snmp'			=> array('define' => 'PHP_VALIDATOR_SNMP', 'chars' => ''),
					'special-char'		=> array('define' => 'PHP_VALIDATOR_SPECIAL_CHAR', 'chars' => 'äÄöÖüÜß#$%^&*()[\]\'\/{}|\" <>'),
					'str-length'		=> array('define' => 'PHP_VALIDATOR_STRING_LENGTH', 'chars' => ''),
					'tones' 		=> array('define' => 'PHP_VALIDATOR_TONES', 'chars' => ''),
					'url' 			=> array('define' => 'PHP_VALIDATOR_URL', 'chars' => ''),
				    );

		if (is_null($checkor)) {
			$message = $request;
		}
		else {
			$message = "$request". PHP_VALIDATOR_REQUEST .(isset($key) ? " (". PHP_VALIDATOR_PARAMETER ." = $key)" : '') .". "; 
			if (!is_array($checkor) && isset($error_table[$checkor])) {
				$message .= defined($error_table[$checkor]['define']) ? constant($error_table[$checkor]['define']) : $error_table[$checkor]['define'];
				$message .= $error_table[$checkor]['chars'];
			}
			else {
				$message .= PHP_VALIDATOR_UNKNOWN_CHECKOR;
			}
		}

		return 	  "\t<div id='error-validator' class='text-center' style='margin-top: 5px; color: red;'>\n"
			. "\t\t$message"
			. "\t</div>\n";
	}

	static public function addGracefulToCrontab($action, $overwrite = null, $cron_path = '/usr/conf/cron/root') {
        	$crontab = file_get_contents($cron_path);
        	$graceful_sh = '/usr/local/sbin/graceful-action.sh';
        	$line = "*/1 * * * * $graceful_sh $action";
        	if (preg_match("/". str_replace('/', '\/', $graceful_sh) ."/", $crontab) && is_array($overwrite)) {
        	        // overwrite reboot by activate
        	        $crontab = preg_replace("/graceful-action.sh {$overwrite['old']}/", "graceful-action {$overwrite['new']}", $crontab);
        	        file_put_contents($cron_path, $crontab);
        	}
        	else {
        	        file_put_contents($cron_path, $line, FILE_APPEND);
        	}
        	// restart crond
        	exec('/etc/init.d/S45cron restart');
	}

	static public function removeGracefulToCrontab() {
        	$apply = false;
        	$cron_str = '';
        	$cron_path = '/usr/conf/cron/root';
        	$cron_tasks = file_get_contents($cron_path);
        	// activate
        	foreach (explode("\n", $cron_tasks) as $cron_task) {
               	 	if (strlen($cron_task) > 0) {
                	        if (preg_match('/graceful-action.sh/', $cron_task)) {
                	                $apply = true;
                	        }
                	        else {
                	                $cron_str .= "$cron_task\n";
                	        }
                	}
        	}
        	// restart cron
        	file_put_contents($cron_path, $cron_str);
        	exec('/etc/init.d/S45cron restart');
        	return $apply;
	}

	static public function cleanCronDirectories($script, $directory_list) {
		foreach ($directory_list as $directory) {
 			if (file_exists("/etc/cron.$directory/$script")) {
				if (!self::system(true, "rm -f /etc/cron.$directory/$script")) {
					return false;
    		}
			}
		}
		return true;
	}

	static public function isRebootRequired() {
		return file_exists('/var/run/reboot-required');
	}

	static public function manageUpdateNotification($bc, $is_sbc_vm, $show_notif, $has_update_cmd, $update_message) {
		$major_issue 	= $bc->get('root', 'has-major-issue');
		$force_update = $bc->get('root', 'sbcvmupdate-notif');

		if (strlen($major_issue) > 0) {
			return 	"\n"
						. self::forceUpdateJavascript($is_sbc_vm)
						. "<div id='force-update' class='text-center' style='margin-top:5px; color:red;'>". constant($major_issue) ."</div>";
		}
		else if ($is_sbc_vm && strlen($force_update) > 0) {
			return	"\n"
						. self::forceUpdateJavascript($is_sbc_vm)
						. "<div id='force-update' class='text-center' style='margin-top:5px;color:red;'>". constant($force_update) ."</div>";
		}
		else if ($show_notif && $bc->get('root', $has_update_cmd)) {
			return	"\n"
						. "<div id='newer_firmware_available' class='text-center' style='margin-top:5px; color:red;'>". constant($update_message) ."</div>";
		}
		return '';
	}

	static public function forceUpdateJavascript($is_sbc_vm) {
		if (!$is_sbc_vm) {
			return '';
		}
		ob_start();
		?>
 		<script type='text/javascript' language='javascript'>
			function forceCheckUpdata() {
				$.ajax({
					cache: false,
					data: { check_update:1 },
					error: function(request, stat, error) {
						forceCheckUpdate();
					},
					success: function(data) {
						if (typeof data.success !== 'undefined') {
							$('#newer_firmware_available').hide();
							$('#newer_firmware_available').html('');
							$('#id_sbcvm-current-package').val(data.current_package);
							$('.form-group.sbcvm-available-package').hide();
							$('#ajax-response').css('color', 'green');
							$('#force-update').html('<?php echo constant($message['successful']); ?>');
							document.getElementById("wait_div").style.display = "none";
						}
						else if (typeof data.rebooting !== 'undefined') {
							window.setInterval(session, 1000);
							$("#wait_div").html("<p>"+ data.rebooting +"<img src='./includes/images/waitlogo1.gif'/></p>");
						}
						else {
							forceCheckUpdate();
						}
					},
					timeout: 3000,
					type: 'POST',
					url: './modules/UpdateTool/updatetool_ajax.php',
				});
			}
 			function forceUpdate() {
	 			document.getElementById('wait_div').style.display = 'block';
 				$.ajax({
 					cache: false,
 					data: { 'force-update' : true },
 					error: function(request, stat, error) {
						forceCheckUpdate();
 					},
 					success: function(data) {
						// should not happen. the update overwrite the update_ajax.php leading to a failure
 						if (typeof data.error === 'undefined') {
							$('#force-update').css('color', 'green');
							$('#force-update').html(data.success);
 						}
 						else {
 							$('#force-update').css('color', 'red');
 							$('#force-update').html(data.error);
						}
						document.getElementById('wait_div').style.display = 'none';
					},\n"
					timeout: 60000,
					type: 'POST',
					url: './modules/UpdateTool/updatetool_ajax.php',
				});
			}
		</script>
		<?php
		return ob_get_clean() ."\n";
	}

	public static function jsonEncode($data, $flags = 0) {
		if (PHP_VERSION == '5.2.6') {
			$encoded = '{';
			foreach ($data as $key => $value) {
				if (is_array($value)) {
					$encoded .= "\"$key\":". self::jsonEncode($value) .",";
					continue;
				}
				$encoded .= "\"$key\":\"". trim(str_replace('"', '\"', defined($value) ? constant($value) : $value)) ."\",";
			}
			$encoded = substr($encoded, 0, -1);
			$encoded .= "}";
			return $encoded;
		}
		return json_encode($data, $flags);
	}

	public static function buildIniString($data, $str = '') {
		foreach ($data as $key => $value) {
			if (is_array($value)) {
				$str .= "[$key]\n";
				$str = 	self::buildIniString($value, $str);
			}
			else {
				$str .= "$key=\"$value\"\n";
			}
		}
		return $str;
	}

	public static function getGuiMode($ba = null) {
		$ba = is_null($ba) ? new beroAri() : $ba;
		return $ba->get('gui_mode');
	}

	public static function headerMessage($which, $bc) {
		$color = 'red';
		$message = '';
		switch ($which) {
			case 'fw-opened':
				$ports = array();
				$ports2value = array(
					'-1'	=> 'SIP',
					'-2'	=> 'SIP/TLS',
					'22' 	=> 'SSH',
					'80' 	=> 'HTTP',
					'161'	=> 'SNMP',
					'162'	=> 'SNMP/Trap',
					'443'	=> 'HTTPS',
					'all' => 'All Ports',
				);
				$value = $bc->get('root', $which);
				$message = defined($value) ? constant($value) : '';
				foreach (explode(':', $bc->get('root', "$which-ports")) as $port) {
					$ports[] = isset($ports2value[$port]) ? $ports2value[$port] : $port;
				}
				$message .= implode(', ', $ports);
				break;
			case 'new-gui-password':
				$email = $bc->get('root', 'factory-reset-email');
				if ($email == '-1') {
					$message .= FACTORY_RESET_SBCVM_ISSUE_NEW_BEROGUI_PASSWORD;
					$bc->delete('root', 'factory-reset-email');
				}
				else if (strlen($email) > 0) {
					$message .= FACTORY_RESET_SBCVM_NEW_BEROGUI_PASSWORD . $email;
					$bc->delete('root', 'factory-reset-email');
				}
				break;
			case 'sbcvm-invalid-subscription':
				$invalid = $bc->get('root', $which);
				if (preg_match('/^([_A-Z]+):([0-9]+):([_A-Z]+)$/', $invalid, $matched)) {
					// differentiation always > 0 since once = 0 the cloud sbc is shut down
					$timer = self::convertSecondsToDaily((int)($matched[2]+86400-time()));
					$message .= constant($matched[1]) ."<div id='timer_shutdown'>{$timer['h']}h:{$timer['m']}m:{$timer['s']}s</div>\n". constant($matched[3]);
					ob_start();
					?>
					<script>
						window.setInterval(timerShutdown, 1000);
						function checkSubscription() {
							$.ajax({
								cache: false,
								error: function() {
									$('#checking_failed').html('<?php echo SBCVM_CHECKINGSUBSCRIPTION_ERROR; ?>');
								},
								success: function(data) {
									if (data == '1') {
										$('#alert_shutdown').html('<?php echo SBCVM_SUBSCRIPTION_CONFIRMED; ?>');
										$('#alert_shutdown').css('color', 'green');
									}
									else {
										$('#checking_failed').html('<?php echo SBCVM_CHECKINGSUBSCRIPTION_FAILED; ?>');
									}
								},
								timeout: 1000,
								url: 'misc/checkSubscription.php',
							});
						}
						function timerShutdown() {
							let final_time = parseInt(<?php echo $matched[2]; ?>) + 86400;
							const current_time = new Date().getTime();
							let timer = ~~(final_time - current_time / 1000); // convert timestamp from milliseconds to seconds
							var hours = ~~(timer / 3600);
							var minutes = "0" + ~~((timer % 3600) / 60);
							var seconds = "0" + ~~(timer % 60);
							$('#timer_shutdown').html(hours +'h:'+ minutes.substr(-2) +'m:'+ seconds.substr(-2) +'s');
						}
					</script>
					<?php
					return 	"\n\t<div class='text-center' style='margin-top:5px;color:$color;' id='alert_shutdown'>\n\t\t$message\n\t</div>\n"
								.	"\t<div class='text-center' style='margin-top:5px;color:$color;' id='checking_failed'></div>\n"
								. ob_get_clean();
				}
				break;
			case 'rootfs-phpcgi-failed':
				$value = $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				else if (preg_match('/^(.*):(.*):([0-9]*)$/', $value, $matched)) {
					$message .= constant($matched[1]).'<br/>'.constant($matched[2]).'<br/>('.round($matched[3] * 0.001, 1).'MB)';
				}
				else if (preg_match('/^(.*):(.*)$/', $value, $matched)) {
					$message .= constant($matched[1]).'<br/>'.constant($matched[2]);
				}
				else {
					$message .= constant($value);
				}
				$bc->delete('root', $which);
				break;
			case 'rootfs-phpcgi-success':
				$value = $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				$color = 'green';
				$message .= constant($value);
				$bc->delete('root', $which);
				break;
			default:
				$value = $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				$message .= constant($value);
				break;
		}
		if (strlen($message) > 0) {
			$message = 	"\n\t<div class='text-center' style='margin-top:25px;color:$color;'>\n"
								. "\t\t$message\n"
								. "\t</div>\n";
		}
		return($message);
	}

	static public function setDataValidator($parameters, &$list_data = array(), &$options_data = array()) {
		foreach ($parameters as $key => $param) {
			$list_data[$key] = $param['validator'];
			if (isset($param['options'][$param['validator']])) {
				switch ($param['validator']) {
				case 'select':
					$options_data[$key] = array_keys($param['options'][$param['validator']]);
					break;
				default:
					$options_data[$key] = $param['options'][$param['validator']];
					break;
				}
			}
		}
	}

	## // STRING FUNCTIONS \\ ##
	static public function concatenateString($string, $what_concatenate) {
		return "{$what_concatenate}{$string}";
	}

	static public function truncateString($string, $what_truncate) {
		return str_replace($what_truncate, '', $string);
	}

	## // BERONODE FUNCTIONS \\ ##
	static public function isBeronodeRunning(&$error = null) {
		require_once('/usr/local/php/include/beronode/ServerApi.php');
		$server_api = new ServerApi();
		$res = $server_api->state();
		if ($res['state'] == 'RUNNING') {
			return true;
		}
		$error = $server_api->getError();
		return false;
	}

	## // COMMAND FUNCTIONS \\ ##
	static public function beronodeCommand($cmd) {
		require_once('/usr/local/php/include/beronode/Api.php');
		$node_api = new Api();
		$response = $node_api->exec($cmd);
		if ($node_api->hasError()) {
			$error = $node_api->getError();
			throw new Exception($error['msg'], $error['code']);
		}
		return isset($response['success']);
	}

	static public function chown($is_sbc_vm, $owner, $group, $file, $options = array()) {
		if ($is_sbc_vm) {
			try {
				return self::beronodeCommand("chown ". implode(" ", $options) ." $owner:$group $file");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return chown($file, $group);
	}

	static public function chmod($is_sbc_vm, $file, $privileges, $options = array()) {
		if ($is_sbc_vm) {
			try {
				return self::beronodeCommand("chmod $privileges $file");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return chmod($file, $privileges);
	}

	static public function copy($is_sbc_vm, $source, $dest) {
		if ($is_sbc_vm) {
			try {
				return self::beronodeCommand("cp '$source' '$dest'");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return copy($source, $dest);
	}

	static public function exec($is_sbc_vm, $cmd, &$output = null, $options = array()) {
		if ($is_sbc_vm) {
			require_once('/usr/local/php/include/beronode/Api.php');
			$node_api = new Api();
			$response = $node_api->exec($cmd, $options);
			// response without error
			if (isset($response['success'])) {
				$output = (isset($response['output']) ? $response['output'] : '');
				return $output;
			}
			// error between berogui / beronode
			else if ($node_api->hasError()) {
				$output = $node_api->getError();
				return false;
			}
			// command error
			$output = $response['error'];
			return $output;
		}
		$res = exec($cmd, $output);
		return $res;
	}

	static public function mkdir($is_sbc_vm, $directory, $permissions = 0777, $recursive = false) {
		if ($is_sbc_vm) {
			try {
				$_R = $recursive ? "-p" : "";
				self::beronodeCommand("mkdir $_R $directory");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return mkdir($directory, $permissions, $recursive);
	}

	static public function rmdir($is_sbc_vm, $dir) {
		if ($is_sbc_vm) {
			try {
				self::beronodeCommand("rm -rf '$dir'");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return rmdir($dir);
	}

	static public function system($is_sbc_vm, $cmd, &$output = null, $options = array()) {
		if ($is_sbc_vm) {
			require_once('/usr/local/php/include/beronode/Api.php');
			$node_api = new Api();
			$response = $node_api->exec($cmd, $options);
			// response without error
			if (isset($response['success'])) {
				$output = (isset($response['output']) ? $response['output'] : '');
				return true;
			}
			// error between berogui / beronode
			else if ($node_api->hasError()) {
				$error = $node_api->getError();
				throw new Exception($error['msg'], $error['code']);
			}
			// command error
			$output = $response['error'];
			return false;
		}
		system($cmd, $retval);
		return $retval;
	}

	static public function unlink($is_sbc_vm, $file) {
		if ($is_sbc_vm) {
			try {
				return self::beronodeCommand("rm -f '$file'");
			}
			catch (Exception $e) {
				throw $e;
			}
		}
		return @unlink($file);
	}

	## // REDIRECT FUNCTIONS \\ ##
	static public function redirectAfterSubmit($db, $m, $uri = '') {
		//if ($db->is_error()) {
		//	echo "<script>alert('{$db->error()}');</script>";
		//	exit(0);
		//}
		echo "<script>window.location='../../index.php?m=$m$uri'</script>";
		exit(0);
	}

	static public function redirectOnError($m, $code, $msg, $path = '../../index.php') {
		echo "<script>window.location='$path?m=$m&error=$code&reason=". htmlentities(str_replace("'", "\'", $msg)) ."'</script>";
		exit(1);
	}

	static public function redirectOnBeronodeError($m, $error) {
		echo "<script>window.location='../../index.php?m=$m&error=2&reason=". htmlentities(str_replace("'", "\'", trim($error['msg']))) ."'</script>";
		exit(1);
	}

	static public function redirectOnInvalidData($m, $invalid) {
		echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
		exit(1);
	}
	#####
}
?>
