<!DOCTYPE html>
<?php 
// Feedback button
// <script type="text/javascript" src="https://beronet.atlassian.net/s/d41d8cd98f00b204e9800998ecf8427e-T/-p0v7s4/100026/c/1000.718.3/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector.js?locale=en-US&collectorId=49be9d97"></script>

// check if the 'Helper' class is loaded
if (!class_exists('Helper')) {
	require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
}

$hostname = file_exists('/etc/hostname') ? file_get_contents("/etc/hostname") : file_get_contents('/etc/hostname.default');

$version_fw = '';
$file_path = "/usr/local/FILENAME";
if (file_exists($file_path) && preg_match("/^appfs-([0-9]{2}).([0-9]{2,4}).tar.gz$/", file_get_contents($file_path), $version_matched)) {
	$version_fw = $version_matched[1] . $version_matched[2];
} else {
	$version_fw = date("Ymd");
}

$ba = new beroAri();
if (isset($_POST['lang'])) {
	$ba->set("lang", Helper::sanitizePost($_POST['lang'], 'lang'));
}
if (isset($_POST['gui_mode'])) {
	$ba->set("gui_mode", Helper::sanitizePost($_POST['gui_mode'], 'gui-mode'));
}

($ba->get('gui_mode') != "") ? $guiMode = $ba->get('gui_mode') : $guiMode = "advanced";


if ($is_sbc_vm = $ba->get('is_sbc_vm')) {
	$header_settings = array(
		'bc-fw-update'	=> 'sbcvm-has-update',
		'fw-update-mess'=> 'NEW_PACKAGE_AVAILABLE_MESSAGE_DIS',
		'fw-reboot-mess'=> 'REBOOT_REQUIRED_MESSAGE_DIS',
		'gui-title'			=> 'GUI_SBCVM_TITLE',
	);
}
else {
	$header_settings = array(
		'bc-fw-update'	=> 'new-app-image-available',
		'fw-update-mess'=> 'FIRMWARE_UPDATE_AVAILABLE_MESSAGE_DIS',
		'gui-title'			=> 'GUI_TITLE',
	);
}

require_once("./includes/lang.php");
require_once("./includes/Helper/Helper.php");
?>
<html lang="en">
    <head>
		<meta charset="iso-8859-1">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="icon" href="./includes/images/favicon.ico" type="image/x-icon">
		<link type="text/css" href="includes/css/custom-theme/jquery-ui.min.css?<?php echo $version_fw; ?>" rel="Stylesheet" />
		<link type="text/css" href="includes/css/bootstrap.min.css?<?php echo $version_fw; ?>" rel="Stylesheet" />
		<link rel="stylesheet" type="text/css" href="includes/css/template_css.css?<?php echo $version_fw; ?>" />
		<script type="text/javascript" language="javascript" src="includes/js/jquery-1.7.2.min.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" language="javascript" src="includes/js/jquery-validation/jquery.validate.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" src="includes/js/bootstrap.min.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" src="includes/js/jquery-ui.min.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" language="javascript" src="includes/js/validation_modul.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" language="javascript">
	jQuery.validator.setDefaults({
                highlight: function (element) {
                    $(element).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (element, error) {
									if (typeof $(element).attr('isFormTable') == 'undefined') {
                		$(element).closest('.form-group').removeClass('has-error');
									}
                },
                errorElement: 'span',
                errorClass: 'help-block',
                errorPlacement: function (error, element) {
									var errorId = error.attr('id').replace("[]", "");
									if (typeof $(element).attr('isFormTable') == 'undefined') {
                    if (element.parent('.input-group').length) {
                    	error.insertAfter(element.parent());
                    } else if (!($('#'+ errorId).is(":visible"))) {
                      error.insertAfter(element);
										}
									}
									else {
										$('#'+ $(element).attr('isFormTable')).html(error.text());
										$('#'+ $(element).attr('isFormTable')).show();
									}
                }
            });
            var validateMethod = $.fn.validate;
            $.fn.validate = function (o) {
                if (o && o.rules) {
									var match;
                    for (var name in o.rules) {
                        var rule = o.rules[name];
                        if (rule.required === true || rule.atLeastOnePort === true || rule.atLeastOnePortWizard === true) {
													if (match = name.match(/data\[(\w+)\]/)) {
														addAsterisk(match[1]);
													}
													else {
                            addAsterisk(name);
													}
                        }
                    }
                }
                return $.proxy(validateMethod, this)(o);
            };
            function addAsterisk(name) {
                var label = $('label[for="' + name + '"]');
                var text = label.text();
                var lastChar = text.substr(text.length - 1);
                if (lastChar != "*") {
                    label.html(label.html() + "<span style=color:red>*</span>");
                }
            }
            function deleteAsterisk(name) {
                var label = $('label[for="' + name + '"]');
                var text = label.text();
                var lastChar = text.substr(text.length - 1);
                if (lastChar == "*") {
                    var newText = label.html(); // <span style=color:red>*</span> ---> string.length = 30
                    label.html(newText.substring(0, newText.length - 30));
                }
            }

            var activated = false;

            var req = false;

            //AJAX Request nach dem reboot
            function setRequest() {
                // Request erzeugen
                if (window.XMLHttpRequest) {
                    req = new XMLHttpRequest(); // Mozilla, Safari, Opera
                } else if (window.ActiveXObject) {
                    try {
                        req = new ActiveXObject('Msxml2.XMLHTTP'); // IE 5
                    } catch (e) {
                        try {
                            req = new ActiveXObject('Microsoft.XMLHTTP'); // IE 6
                        } catch (e) {
                        }
                    }
                }


                // überprüfen, ob Request erzeugt wurde
                if (!req) {
                    alert('Can not create an XMLHTTP instance');
                    return false;
                } else {
                    // Request öffnen
                    req.open('GET', "/", true);
                    // Requestheader senden
                    // Request senden
                    req.send(null);
                    // Request auswerten
                    req.onreadystatechange = interpretRequest;
                }
            }

            // Request auswerten
            function interpretRequest() {
                switch (req.readyState) {
                    // wenn der readyState 4 und der request.status 200 ist, dann ist alles korrekt gelaufen
                    case 4:
                        if (req.status != 200) {
                            //Request senden solange die karte down ist.
                            setRequest();
                        } else {
                            // Die karte wurde schon neugestartet
                            window.location = '/';
                        }
                        break;
                    default:
                        break;
                }
            }
            //AJAX Request Ende
            function getTotalCalls() {
                $.ajax({
                    url: "misc/getTotalCalls.php",
                    cache: false,
                    success: function (data) {
                        $("#totalcalls").html(data);
                    },
                });
            }

            //Erzeugt die Netmaske anhand der IP Adresse
            function makeNetMask(IPvalue) {
                var ipPattern = /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
                var ipArray = IPvalue.match(ipPattern);

                if (ipArray != null) {
                    if (ipArray[1] >= 0 && ipArray[1] <= 127)
                        return "255.0.0.0";
                    if (ipArray[1] >= 128 && ipArray[1] <= 191)
                        return "255.255.0.0";
                    if (ipArray[1] >= 192 && ipArray[1] <= 223)
                        return "255.255.255.0";
                }
                return "";
            }

            //Popup Fenster öffnen
            function new_window(URL) {
                left_pos = ((screen.width - 750) / 2);
                height_pos = ((screen.height - 400) / 2);
                window.open(URL, "beroAri", "width=750, height=400, left=" + left_pos + ", top=" + height_pos + " , menubar=no, location=no, resizable=yes, scrollbars=yes, status=no");
            }


            //Anzeige der verschiedene "activate" knöpfe
            function aktivieren(aktiv, m, option, text) {

                if (aktiv == 1 && activated == false) {
                    if (option == 2) {
                        document.getElementById('aktiv').innerHTML = '<input type=\'button\' id=\'aktivieren\' class=\'aktivieren2\' value=\'' + text + '\'>';
                    } else if (option == 3) {
                        document.getElementById('aktiv').innerHTML = '<input type=\'button\' id=\'aktivieren\' class=\'aktivieren3\' value=\'' + text + '\'>';
                    } else {
                        document.getElementById('aktiv').innerHTML = '<input type=\'button\' id=\'aktivieren\' class=\'aktivieren1\' value=\'' + text + '\'>';
                    }
                    activated = true;
                }
            }

            //Der Button "Easy Configuration Wizard" wird angezeigt
            //wenn die Datenbank sich in einem leeren Zustand befindet
    		function wizard(check, text) 
		{
<?php 	
	$atLeastOneModulePlugged = false;
	foreach (Helper::getLif() as $lif)
	{
		if (!(preg_match('#none#', $lif)))
		{
			$atLeastOneModulePlugged = true;
		}		
	}

	if (isset($_GET['m']) && $_GET['m'] != 'RebootReset' && $atLeastOneModulePlugged)
	{ ?>
			if (check == 1)
			{
				document.getElementById('wiz').innerHTML = "<a id='wizard' role='button' data-remote='false' data-toggle='modal' data-target='#general-popup' class='btn btn-default' style='margin-right: 4px;' onclick=\"$('#generalModalLabel').html('"+ text +"');\">"+ text +"</a>";
		
			}
<?php	} ?>
 	   	}

		// TODO: try to combine with hide_element to generalise with Dialplan
		function manageManualSelect(selfSelect, manualId) {

			if (selfSelect.options[selfSelect.length - 1].selected == true) {
				$('#'+ manualId).show();
			} else {
				if ($('#'+ manualId).attr('aria-invalid')) {
					$('#'+ manualId).val('');
					$('#'+ manualId +'-error').remove();
				}
				$('#'+ manualId).hide();
			}
		}

		function deleteById(id, action, module, script, confirmMsg) {
			if (confirm(confirmMsg)) {
				var entryid = [id];
				ajaxDelete(module, script, {action: action, entryid: entryid, entryname: ''});
			}
		}

		function deleteAll(action, module, script, confirmMsg) {
			var i = 0;
			var entryid = [];
			var entryname = [];
			$('.entryid.'+ action).each(function() {
				if (this.checked) {
					entryid[i] = $(this).attr('value1');
					entryname[i] = $(this).attr('value2');
					i++;
				}
			});
			if (i>0 && confirm(confirmMsg)) {
				ajaxDelete(module, script, {action: action, entryid: entryid, entryname: entryname});
			}
		}

		function ajaxDelete(module, script, formObj) {
			$.post('./modules/'+ module +'/'+ script, formObj).done(function(res) {
				var data = JSON.parse(JSON.stringify(res));
				if (data.error == '1') {
					window.location = '../../index.php?m='+ module +'.php&error='+ data.error +'&request='+ data.request +'&checkor='+ data.checkor +'&key='+ data.key;
			}
			else {
				location.reload();
			}
			});
		}

		function showFieldForm(paramList, mustShow) {
			if (mustShow) {
				paramList.forEach(function (param) {
					$('.form-group.'+ param).show();
				});
			}
			else {
				paramList.forEach(function (param) {
					$('.form-group.'+ param).hide();
				});
			}
		}

		function updateSelectOptions(idList, newOptions) {
			idList.forEach(function(id) {
				$('#'+ id).empty();
				$.each(newOptions, function(key, value) {
					$('#'+ id).append($("<option></option>").attr("value", key).text(value));
				});
			});
		}
		</script>
		<title><?php echo constant($header_settings['gui-title']); echo strlen($hostname)>0?" - ".$hostname:""; ?></title>
		<?php	
		$beroConf = new beroConf('root');
		$is_cloud_status_show = ($ba->get('cloud_show_status') == 1);
    		$is_cloud_enable = ($beroConf->get('root','cloud_enable'));
    		$cloud_key = $beroConf->get("root", "cloud_key");
    		$ba_error = $ba->get('error');
		
		$show_notif = $is_sbc_vm ? $beroConf->get('root', 'sbcvmupdate-shownotif') : true;

		$firmware_update = Helper::manageUpdateNotification($beroConf, $is_sbc_vm, $show_notif, $header_settings['bc-fw-update'], $header_settings['fw-update-mess']);

		$reboot_required = '';
		if ($show_notif && Helper::isRebootRequired()) {
			$reboot_required = "<div id='reboot-required' class='text-center' style='margin-top:5px; color:red;'>". constant($header_settings['fw-reboot-mess']) ."</div>";
		} 

		$warning = '';
		foreach (array('rootfs-notenough-space', 'new-gui-password', 'fw-opened', 'sshtunnel-fromproxy-failed', 'sshtunnel-toproxy-failed', 'sbcvm-invalid-subscription', 'rootfs-phpcgi-failed', 'rootfs-phpcgi-success') as $key) {
			$warning .= Helper::headerMessage($key, $beroConf);
		}
		unset($beroConf);

		$option = $ba->get("activate");

		$option_graceful = 0;
		$is_graceful_action = false;
		$crontab = @file_get_contents('/usr/conf/cron/root');
		if (preg_match('/graceful-action.sh/', $crontab)) {	
			$option_graceful = $ba->get("graceful_action");
			if ($option > $option_graceful) {
				Helper::removeGracefulToCrontab();
			} else if ($option_graceful > 0) {
				$is_graceful_action = true;
			}
		}

		if ($option != 0)
			$aktiv = '1';
		else
			$aktiv = 0;
		
		$query = $ba->select('SELECT password FROM users WHERE user = \'admin\'');
		$pw_chk = $ba->fetch_array($query);
		if (tep_validate_password('admin', $pw_chk['password']) !== false) {
			$showSecurityMessage = '1';
		}


		// _GET['m'] has been sanitized into the index.php script
		$_GET['opt'] = isset($_GET['opt']) ? Helper::sanitizeGet($_GET['opt'], 'opt') : '';
		?>
		<script type="text/javascript">
			function showDialog(targetUrl, message, title, action = null) {
				if (action == null) {
					$("#dialog-confirm").dialog({
						autoOpen: false,
						modal: true
					});
					$('#dialog-confirm').dialog('option', 'title', title);	
					$("#dialogtext").html(message);
					$("#dialog-confirm").dialog("open");
					$("#dialog-confirm").dialog({
						buttons: {
							"Confirm": function () {
								$("#aktivieren").prop("disabled", true);
								$(this).dialog("close");
								window.location.href = targetUrl;
							},
							"Cancel": function () {
								$(this).dialog("close");
							}
						}
					});
				}
				else {
					$("#dialog-confirm").dialog({
						autoOpen: false,
						width: 485,
						top: 230,
						modal: true
					});
					$('#dialog-confirm').dialog('option', 'title', title);	
					$("#dialogtext").html(message);
					$("#dialog-confirm").dialog("open");
					$("#dialog-confirm").dialog({
						buttons: {
							"<?php echo WARNING_GRACEFUL_DIALOG_BUTTON_CONFIRM; ?>": function () {
								$("#aktivieren").prop("disabled", true);
								$(this).dialog("close");
								window.location.href = targetUrl;
							},
							"<?php echo WARNING_GRACEFUL_DIALOG_BUTTON_GRACEFUL; ?>": function () {
								$("#aktivieren").prop("disabled", true);
								$(this).dialog("close");
								window.location.href = 'misc/gracefulAction.php?m=<?php echo $_GET['m']; ?>&action='+ action;
							},
							"<?php echo WARNING_GRACEFUL_DIALOG_BUTTON_CANCEL; ?>": function () {
								$(this).dialog("close");
							}
						}
					});
				}
			}
			$(document).ready(function () {
				$('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover'});
				aktivieren("<?php echo $aktiv ?> ", "<?php echo $_GET['m']; ?> ", "<?php echo $option; ?>", "<?php echo ACTIVATE; ?>");
				wizard(" <?php echo Helper::check($ba); ?>", " <?php echo WIZARD; ?>");

				$("#aktivieren").click(function (e) {
					e.preventDefault();
					var aktivierenThis = this;
					var targetUrl = 'includes/create_files.php?m=<?php echo $_GET['m']; ?>&opt=<?php echo $_GET['opt']; ?>';
					
					//always show a warning when calls are running, even for yellow activate
					if (1) {
						$.ajax({
							url: "misc/getTotalCalls.php?checkForYellowConfirm=1",
							cache: false,
							success: function (data) {
								if (data == 0) {
									if ($(aktivierenThis).prop("class") == 'aktivieren3') {
										var message = 'This action will reboot the system.';
										showDialog(targetUrl, message, 'Activate your settings ?');
									}
									else {
										$(aktivierenThis).prop("disabled", true);
										window.location.href = targetUrl;
									}
								}
								else {
									
									var tr_notruf = 0;
									if (data < 0) {
										data = data * -1;
										tr_notruf = 1;
									}
									var message = "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_CALLCOUNT2; ?>" + data + "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_CALLCOUNT3; ?>";
									if (data == 1) {
										message = "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_CALLCOUNT1; ?>";
									}
									
									if ($(aktivierenThis).prop("class") == 'aktivieren1') {
										if (tr_notruf == 0) {
											$(this).prop("disabled", true);
											window.location.href = targetUrl;
											return;
										}
										message = message + "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_YELLOW; ?>";
									}
									else if ($(aktivierenThis).prop("class") == 'aktivieren2') {
										message = message + "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_ORANGE; ?>";
									}
									else if ($(aktivierenThis).prop("class") == 'aktivieren3') {
										message = message + "<?php echo WARNING_GRACEFUL_DIALOG_MESSAGE_RED; ?>";
									}
									
									showDialog(targetUrl, message, 'Activate your settings ?', 'activate');
								}
							},
						});
					}
                		});
			});
		</script>
    </head>
	<?php
//Aufbau des HTML Codes
	$ret .= "<body onclick='refresh_session_timer()'>
<script type=\"text/javascript\" src=\"./includes/notes/wz_tooltip.js?$version_fw\"></script>
<div id='dialog-confirm' title='Activate your settings?'>
  <p id='dialogtext'></p>
</div>
<div id='wait_div' class='text-center' style='display:none;	padding-top:100px;	position:absolute;	width:100%;	height:100%;	z-index:110;	background-color: rgb(255, 255, 255);'><p>" . UPLOAD_WAIT . "</p><br/>
	<img src='./includes/images/waitlogo1.gif'/>
</div>
<div class=\"container boxed\" id=\"page\">";
	include "includes/menu.php";
	
	$ret .= "<script type=\"text/javascript\"  language=\"javascript\">
		window.refreshSessionTimer = false;
		function refresh_session_timer() {
			if (window.refreshSessionTimer === true) {
				return;
			}
			window.refreshSessionTimer = true;
			$.ajax({
				error: function() {
					window.refreshSessionTimer = false;
				},
				success: function() {
					window.refreshSessionTimer = false;
				},
				timeout: 1000,
				url: 'includes/session.php?update=true',
			});
		}
	</script>
	";
	
	$ret .= "
 <br/>
    <div id=\"pageName\" class=\"clear\">
        <!-- Languages -->
        <div class=\"part2\">
        <div class=\"part2\">
			<form action='' method='POST'>
				<input type='hidden' name='lang' value='de'>
				<input type='image' style='vertical-align: text-top' src=\"./includes/images/deutsch.gif\" height='15px' width='22px'/>
			</form>
		</div>
		<div class=\"part2\">
    	<form action='' method='POST'>
				<input type='hidden' name='lang' value='en'>
				<input type='image' style='vertical-align: text-top' src=\"./includes/images/englisch.gif\" height='15px' width='22px'/>
			</form>
		</div>
		<div class=\"part2\">
        " . LANGUAGES . ":
        </div>
		</div>
	<div class=\"part2\">";
	if ($guiMode == 'simple')
		$ret .= "<div class=\"part2\">
			<form action='' id='guiAdvanced' method='POST'>
				<input type='hidden' name='gui_mode' value='advanced'>
				<span style='color:grey;'>Easy</span>&nbsp;/&nbsp;<a href='javascript:{}' onClick='guiAdvanced.submit();'>Advanced</a>
			</form>
		</div>";
	if ($guiMode == 'advanced')
		$ret .= "<div class=\"part2\">
			<form action='' id='guiEasy' method='POST'>
				<input type='hidden' name='gui_mode' value='simple'>
				<a href='javascript:{}' onClick='guiEasy.submit();'>Easy</a>&nbsp;/&nbsp;<span style='color:grey;'>Advanced</span>
			</form>
		</div>";
	$ret .= "<div class=\"part2\">
        " . GUI_MODE . ":
        </div></div>";
        
    $ret .= "<div class=\"part2\">";
    if ($is_cloud_status_show && !$is_sbc_vm) {
        if ($is_cloud_enable == 1 && empty($cloud_key) == false && $ba_error == '' ) {
            $ret .= "<a id='cloud_status' class='part2' href='index.php?m=BeroCloud' data-toggle='tooltip' data-placement='top' title='" . BEROCLOUD_STATUS_SUCCESS_DIS . "'>
                     <span style='color:black'>beroCloud: </span><img style='vertical-align: text-top' src='./includes/images/punkt_gruen.gif'></a>";

        } else {
            $ret .= "<a id='cloud_status' class='part2' href='index.php?m=BeroCloud' data-toggle='tooltip' data-placement='top' title='" . BEROCLOUD_STATUS_FAIL_DIS . "'>
                     <span style='color:black'>beroCloud: </span><img style='vertical-align: text-top' src='./includes/images/punkt_rot.gif'></a>";
        }        
    }
		else if ($is_sbc_vm) {
			$status = array(
				0 => array('image' => 'rot'		, 'title' => BERONODE_STATUS_FAIL_DIS),
				1 => array('image' => 'gruen'	, 'title' => BERONODE_STATUS_SUCCESS_DIS),
			);
			$status = $status[Helper::isBeronodeRunning() ? 1 : 0];
			$ret .= "\n"
						. "\t\t<a id='beronode_status' class='part2' href='index.php?m=State' data-toggle='tooltip' data-placement='top' title='{$status['title']}'>\n"
						.	"\t\t\t<span style='color:black;'>beroNode: </span><img style='vertical-align:text-top' src='./includes/images/punkt_{$status['image']}.gif'>\n"
						. "\t\t</a>\n";
		}

    $ret .= "</div>
		
    <!-- PageName  -->
        <div class=\"part1\">
			<h1>" . constant($name) . "</h1><div id='showNotif'></div>
        </div>
         </div>";
	//TODO: Notification Center	so gui isn't cluttered in error messages all the time
	$ret .= "<br>
				<div id='hardware_ch' class='text-center' style='color:red; font-size:13px;'></div>
				<div id='wiz' class='text-center' style='margin-top:5px;'></div>
				<div id='aktiv' class='text-center' style='margin-top:5px;'></div>
				<div id='ajaxErrors' class='text-center' style='margin-top:5px;'></div>
				<div id='reset_jumper' class='text-center' style='color:red;'></div>";
				
	if ($is_graceful_action) {
		$ret .= "<br/><div class='text-center' style='margin-top:5px; color:red;'>"
			. ($graceful_action == '1' ? WARNING_GRACEFUL_REBOOT_DIS : WARNING_GRACEFUL_ACTIVATE_DIS) ."<br/>" 
			. "<a href='misc/gracefulAction.php?m={$_GET['m']}&action=cancel'>". WARNING_GRACEFUL_CANCEL_DIS ."</a>"
			. "</div>";
	}

	$ret .= $warning.$firmware_update.$reboot_required;
	
		if ($showSecurityMessage) {
		$ret .= "
	<br/>
    <div id='security_mess' class='text-center' style='margin-top:5px; color:red;'>" . SECURITY_CHANGE_PASSWORD_MESSAGE_DIS . "</div>";
	}

	if (file_exists('/tmp/error_certificate.log'))
	{
		$ret .= "
	<br/>
	<div id='error_certificate' class='text-center' style='margin-top:5px; color:red;'>". ERROR_HTTPS_CERTIFICATE_MESSAGE_DIS . "</div>";
	}
	?>
