jQuery.validator.addMethod("checkPassword", function(value, element) {
	let RegExPattern = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[ !"#$%&\'\(\)\*\+,-.\/:;<=>\?@\[\]^_`\{\|\}~])[A-Za-z\d !"#$%&\'\(\)\*\+,-.\/:;<=>\?@\[\]^_`\{\|\}~]{5,}/;
	if (value=="") return true;
	if (RegExPattern.test(value))
        return true;
    else
        return false;  
}, "Invalid Password (needed parameters: min. 5 characters, 1 uppercase, 1 lowercase, 1 special and 1 number)");

jQuery.validator.addMethod("verifyIP", function(value, element) { 

    var ipPattern = /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
    var ipArray = value.match(ipPattern);
    if (value=="") return true;
    if (ipArray == null)
        return false;
    else {
        for (var i = 1; i <= 4; i++) {
            thisSegment = ipArray[i];
            if (thisSegment > 255) {
                return false;
            }
        }
    }
    
    return true;
}, "This is not a valid IP address.");

jQuery.validator.addMethod("checkHostname", function(value, element) {
	var RegExPattern = /^((?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*(?::(?:[0-9]){1,5})?)*$/i;
	if (value=="") return true;
	if (RegExPattern.test(value))
		return true;
	else
		return false;  
}, "Invalid value. Please enter a valid IP Address or a valid hostname");

jQuery.validator.addMethod("checkUrl", function(value, element) {
	if (value != '') {
		//check url with IP address
		var RegExPattern = /^((https?|t?ftp):\/\/)?((25[0-5]|(2[0-4]|1[0-9]|[1-9]|)[0-9])(\.(?!$)|)){4}([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/i;
		if (RegExPattern.test(value)) {
			return true;		
		}
		//check general url
		var RegExPattern = /^((https?|t?ftp):\/\/)?(www.)?[a-zA-Z0-9-_]+(\.[a-zA-Z]+)+((\/)[\w#.-?&]+)*(\/\w+\?[a-zA-Z0-9_]+=\w+(&[a-zA-Z0-9_]+=\w+)*)?([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/i;
		return RegExPattern.test(value);
	}
	return true;
}, "Invalid value. Please enter a valid URL");

jQuery.validator.addMethod("checkMac", function(value, element) { 
    var RegExPattern = /^([0-9a-f]{2}([:-]|$)){6}$|([0-9a-f]{4}([.]|$)){3}$/i;

    if (RegExPattern.test(value))
        return true;
    else
        return false;  
}, "Invalid Media Access Control Address.");

jQuery.validator.addMethod("checkPhoneNumber", function(value, element) { 
   if (value.match('^\\+?[0-9]{1,70}?$') == null  && value!="")
        return false;
   else
        return true; 
}, "Invalid value.");

jQuery.validator.addMethod("sharePath", function(value, element) { 
   if (value.match(/^\\\\/) == null)
        return false;
   else
        return true; 
}, "Invalid value.");

jQuery.validator.addMethod("checkPin", function(value, element) { 
   if (value.match('^[0-9]{4,4}?$') == null)
        return false;
   else
        return true; 
}, "Invalid PIN number.");

jQuery.validator.addMethod("checkvlan", function(value, element) { 
   if (value.match('^\\+?[0-9]{1,70}?$') == null  && value!="")
        return false;
   else
        return true; 
}, "Invalid value.");

function checkvlan(ch){
    if (ch){
        if (!confirm("Do you want to save this settings? The beroNet Gateway will not be longer be accesible via network")) return false;
        return true;
    }else return true;

}

function countAndLimitChars( divId, textareaId, name ) {

    // TextArea auslesen
    var text = document.getElementById( textareaId ).value;

    // TextArea auf 670 Zeichen beschränken
    if( text.length > 670 ) {
        text = text.substring( 0, 670 );
        document.getElementById( textareaId ).value = text;
    }

    // Zeichen der TextArea zählen
    var rest = 670 - text.length;
    var str = name + ': ' + rest;
    document.getElementById( divId ).innerHTML = str;
}

//RTP port range
jQuery.validator.addMethod("rtpFormat", function(value, element) { 
    var ranges=value.split(',');
    for (i=0; i<ranges.length;i++){
        if (!ranges[i].match(/^\d+-?\d+$/))
            return false;
    }
    return true;
}, "This RTP port range is not valid.");

jQuery.validator.addMethod("rtpBindCheck", function(value, element, param) { 
    var ranges=value.split(',');
    for (i=0; i<ranges.length;i++){
        var values=ranges[i].split("-");
        var max=parseInt(values[1]);
        var min=parseInt(values[0]);
        if (min<=$('#'+param).val() && $('#'+param).val()<=max)
            return false;
        
    }
    return true;
}, "The bindport cannot be within the RTP port Range - please check your settings.");

jQuery.validator.addMethod("rtpCount", function(value, element) { 
    var ranges=value.split(',');
    var count=0;
    for (i=0; i<ranges.length;i++){
        var values=ranges[i].split("-");
        if (values.length>1) count+=values[1]-values[0];
        else count+=1;
    }
    if (count<240 || !isNaN(value))
        return false;
    
    return true;
}, "The number of RTP ports must be at least 240."); 

jQuery.validator.addMethod("sipPortCheck",function (value,element,param){
    var ranges=param.split(',');
    var address=value.split(':');
    var port=parseInt(address[1]);
    for (i=0; i<ranges.length;i++){
        var values=ranges[i].split("-");
        var max=parseInt(values[1]);
        var min=parseInt(values[0]);
        if (min<=port && port<=max)
            return false;
        
    }
    return true;
}, "The sip port cannot be within the RTP port Range - please check your settings");

jQuery.validator.addMethod("compareName", function(value, element, param) { 
	if (jQuery.inArray(value.toLowerCase(), param.map(function(strValue) { return strValue.toLowerCase(); }))!=-1) {
		return false;
	} 
	else {
		return true;
	}
}, "Invalid value.");

jQuery.validator.addMethod("specChar", function(value, element) { 
//Sip User und Secret dürfen +,-,_,@,$,&,!,.,/,\,?,*,# enthalten
  var germanChars = "äÄöÖüÜß";
  if (element.name=="user" || element.name=="displayname" || element.name=="auth_user")
      var iChars = germanChars + "%^()=[]\';{}|\"<>";
  else if (element.name=="secret")
      var iChars = germanChars + "\'\"<>";
  else if (element.name=="sip_to_user_setting_manual" || element.name=="sip_from_user_setting_manual" || element.name=="sip_from_display_setting_manual" || element.name=="sip_pai_user_setting_manual" || element.name=="sip_ppi_user_setting_manual")
      var iChars = germanChars + "!@#%^&*()=[]\';,/|\"<>?";
  else if (element.name==element.name=="isdn_dad_setting_manual")
      var iChars = germanChars + "!@#%^&*()+=[]\';,/|\"<>?";
  else
      var iChars = germanChars + "!@#$%^&*()+=[]\';,/{}|\"<>?";
    for (var i = 0; i < value.length; i++) {
        if (iChars.indexOf(value.charAt(i)) != -1)
            return false;
    }
    return true; 
},  function(params, element) {
    iChars="";
    var germanChars = "äÄöÖüÜß";
    if (element.name=="user" || element.name=="displayname" || element.name=="auth_user")
       iChars = "%^()=[]\';,{}|\"<>";
    else if (element.name=="secret")
       iChars = "\'\"<>";
   else if (element.name=="sip_to_user_setting_manual" || element.name=="sip_from_user_setting_manual" || element.name=="sip_from_display_setting_manual" || element.name=="sip_pai_user_setting_manual" || element.name=="sip_ppi_user_setting_manual")
      var iChars = "!@#%^&*()=[]\';,/|\"<>?";
   else if (element.name=="isdn_dad_setting_manual")
      var iChars = "!@#%^&*()+=[]\';,/|\"<>?";

    else
       iChars = "!@#$%^&*()+=[]\';,/{}|\"<>?";
    return "This field contains special characters. The German orthography and these characters are not allowed: "+ iChars +". Please remove them and try again."
});

jQuery.validator.addMethod("checkDigChar", function(value, element) { 
    regexp = /^[a-zA-Z0-9\_\-]+$/g;

    if (regexp.test(value)==false)
        return false;
    return true; 
}, "This field contains special characters or whitespaces. These are not allowed. Please remove them and try again.");

jQuery.validator.addMethod("checkSnmp", function(value, element) { 
    regexp = /^[a-zA-Z0-9\@\#\$\%\^\*\(\)\_\-\+\/\?\{\}\[\]\.\,]*$/g;
    if (regexp.test(value)==false)
        return false;
    return true; 
}, "This field contains some special characters or whitespaces, which are not allowed. Please remove them and try again.");

jQuery.validator.addMethod("checkBlank", function(value, element) { 
   if (value.indexOf(" ")!=-1){
        return false;
    }
    return true;
}, "This field may not contain blanks.");

jQuery.validator.addMethod("atLeastOnePort", function(value, element) { 
    var chk = document.getElementsByName(element.name);
    var len = chk.length;

    for(i=0;i<len;i++)
    {
         if(chk[i].checked && !chk[i].disabled){
        return true;
          }
    }
    return false;
}, "Please select at least one port.");

jQuery.validator.addMethod("atLeastOnePortWizard", function(value, element) {
	var chk = document.getElementsByName(element.name);
	var len = chk.length;

	for (i=0; i < len; i++)
	{
		if ($("#" + chk[i].id).is(':checked'))
		{
			return true;
		}
	}

	return false;

}, "Please select at least one port.");

jQuery.validator.addMethod("alphanumeric", function(value, element) {
	if (value != '') {
		regexp = /^[\d\w]+$/g;
    		return regexp.test(value);
	}
	return true;
}, "Invalid value. Only alphanumerics are accepted.");

jQuery.validator.addMethod("checkManual", function(value, element) {
	if (value != '') {
		regexp = /<script>|<\/script>|<javascript>|<\/javascript>/;
		return !regexp.test(value);
	}
	return true;
}, "Value not allowed."); 

jQuery.validator.addMethod("checkIntPiped", function(value, element) {
	if (value != '') {
		regexp = /^[\d\|]+$/;
		return regexp.test(value);
	}
	return true;
}, "Invalid value. Only numbers and | are accepted.");

jQuery.validator.addMethod("forbidPassword", function(value, element) {
	if (value) {
		return false;
	}
	return true;
}, "Please choose a password different of: '*****'."); 

jQuery.validator.addMethod("checkPhoneKeys", function(value, element) {
	if (value != '') {
		regexp = /^[0-9_#+]+$/;
		return regexp.test(value);
	}
	return true;
}, "Invalid value. Only keys of a keybord phone are accepted.");

jQuery.validator.addMethod("checkInt", function(value, element) {
	if (value != '') {
		regexp = /^-1$|^[0-9]+$/;
		return regexp.test(value);
	}
	return true;
}, "Invalid value. Only -1 and digits are accepted.");

jQuery.validator.addMethod("checkGmt", function(value, element) {
	if (value != '') {
		regexp = /^GMT0|GMT(-|\+)[:\d]{1,5}$/;
		return regexp.test(value);
	}
	return true;
}, "Invalid value. The accepted values are: GMT0, GMT+X, GMT-X where X is the timezone offset.");

jQuery.validator.addMethod("comparePassword", function(value, element, newPassID) {
	return value == $('#'+ newPassID).val();
}, "Invalid value. The password does not match.");

jQuery.validator.addMethod("verifyIPrange", function(value, element) {
	var ipRange = value.split('.');
	if (ipRange.length == 4) {
		return ipRange['3'] == '0';
	}
	// always combined with verifyIP. In other scenarii, verifyIP check the input value.
	return true;
}, "Invalid value. Please follow the schema: 'x.x.x.0'");

jQuery.validator.addMethod("matchSubnet", function(value, element, data) {
	// check
	if (!$(element).is(':visible')) {
		return true;
	}
	// intern function
	function convertIp(IPaddress) {
		var ip = IPaddress.match(/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/);
		if(ip) {
			return (+ip[1]<<24) + (+ip[2]<<16) + (+ip[3]<<8) + (+ip[4]);
		} /*else*/ return null;
	}
	// check lan
	var lanSubnet = true;
	var lanGw = convertIp($('#' + data[0]).val());
	var lanIp = convertIp($('#' + data[1][0]).val());
	var lanMk = convertIp($('#' + data[1][1]).val());

	lanGw &= lanMk;
	lanSubnet = (lanIp & lanMk) == lanGw;

	if (typeof($('#'+data[2]).val()) !== 'undefined') {
		// check wan
		var wanSubnet = true;
		var wanGw = convertIp($('#' + data[0]).val());
		var wanIp = convertIp($('#' + data[2][0]).val());
		var wanMk = convertIp($('#' + data[2][1]).val());

		wanGw &= wanMk;
		wanSubnet = (wanIp & wanMk) == wanGw;

		return lanSubnet | wanSubnet;
	}

return lanSubnet;
}, "Invalid Value. The subnet does not match.");
